/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.pdf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.util.OStrings;

public class PdfFilter
extends AbstractFilter {
    private static final Pattern LINEBREAK_PATTERN = Pattern.compile("^\\s*?$");

    @Override
    public String getFileFormatName() {
        return OStrings.getString("PDFFILTER_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.pdf", null, null, "${nameOnly}.txt")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public BufferedReader createReader(File infile, String encoding) throws IOException {
        PDFTextStripper stripper = new PDFTextStripper();
        stripper.setLineSeparator("\n");
        stripper.setSortByPosition(true);
        PDDocument document = PDDocument.load(infile.getAbsolutePath());
        String text = stripper.getText(document);
        document.close();
        return new BufferedReader(new StringReader(text));
    }

    @Override
    public void processFile(BufferedReader in, BufferedWriter out, FilterContext fc) {
        StringBuilder sb = new StringBuilder();
        String s = "";
        try {
            while ((s = in.readLine()) != null) {
                Matcher m = LINEBREAK_PATTERN.matcher(s);
                if (m.find()) {
                    out.write(this.processEntry(sb.toString()));
                    sb.setLength(0);
                    out.write("\n\n");
                    continue;
                }
                sb.append(s);
                sb.append(" ");
            }
            if (sb.length() > 0) {
                out.write(this.processEntry(sb.toString()));
                sb.setLength(0);
                out.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

