/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.omegat.core.Core;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.gui.editor.autocompleter.AutoCompleterListView;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class GlossaryAutoCompleterView
extends AutoCompleterListView {
    public GlossaryAutoCompleterView() {
        super(OStrings.getString("AC_GLOSSARY_VIEW"));
    }

    @Override
    public boolean shouldPopUp() {
        String leadingText = this.getLeadingText();
        List<AutoCompleterItem> entries = this.computeListData(leadingText, true);
        return !entries.isEmpty() && (leadingText.codePointCount(0, leadingText.length()) > 1 || entries.size() <= 10);
    }

    @Override
    public List<AutoCompleterItem> computeListData(String prevText, boolean contextualOnly) {
        String wordChunk;
        String sortMatchTo = wordChunk = this.getLastToken(prevText);
        ArrayList<AutoCompleterItem> result = new ArrayList<AutoCompleterItem>();
        List<GlossaryEntry> entries = Core.getGlossary().getDisplayedEntries();
        this.fillMatchingTerms(result, entries, wordChunk);
        if (result.isEmpty() && !contextualOnly) {
            this.fillMatchingTerms(result, entries, null);
            sortMatchTo = null;
        }
        Collections.sort(result, new GlossaryComparator(entries, sortMatchTo));
        return result;
    }

    private void fillMatchingTerms(List<AutoCompleterItem> result, List<GlossaryEntry> glossary, String context) {
        if ("".equals(context)) {
            return;
        }
        for (GlossaryEntry entry : glossary) {
            for (String term : entry.getLocTerms(true)) {
                if (!this.termMatchesChunk(term, context)) continue;
                int length = context == null ? 0 : context.length();
                String payload = StringUtil.matchCapitalization(term, context, this.getTargetLocale());
                AutoCompleterItem item = new AutoCompleterItem(payload, new String[]{entry.getSrcText()}, length);
                if (!result.contains(item)) {
                    result.add(item);
                }
                if (payload.equals(term)) continue;
                result.add(new AutoCompleterItem(term, new String[]{entry.getSrcText()}, length));
            }
        }
    }

    private boolean termMatchesChunk(String term, String context) {
        String lowerContext;
        if (context == null) {
            return true;
        }
        Locale locale = this.getTargetLocale();
        String lowerTerm = term.toLowerCase(locale);
        return !lowerTerm.equals(lowerContext = context.toLowerCase(locale)) && lowerTerm.startsWith(lowerContext);
    }

    private Locale getTargetLocale() {
        return Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
    }

    @Override
    public String itemToString(AutoCompleterItem item) {
        if (Preferences.isPreference("ac_glossary_show_source") && item.extras != null) {
            if (Preferences.isPreference("ac_glossary_show_target_before_source")) {
                return item.payload + " \u2190 " + item.extras[0];
            }
            return item.extras[0] + " \u2192 " + item.payload;
        }
        return item.payload;
    }

    static class GlossaryComparator
    implements Comparator<AutoCompleterItem> {
        private boolean bySource = Preferences.isPreference("ac_glossary_sort_by_source");
        private boolean byLength = Preferences.isPreference("ac_glossary_sort_by_length");
        private boolean alphabetically = Preferences.isPreference("ac_glossary_sort_alphabetically");
        private final List<GlossaryEntry> entries;
        private final String matchTo;

        public GlossaryComparator(List<GlossaryEntry> entries, String matchTo) {
            this.entries = entries;
            this.matchTo = matchTo;
        }

        @Override
        public int compare(AutoCompleterItem o1, AutoCompleterItem o2) {
            int result;
            if (!StringUtil.isEmpty(this.matchTo)) {
                boolean o1Matches = o1.payload.startsWith(this.matchTo);
                boolean o2Matches = o2.payload.startsWith(this.matchTo);
                if (o1Matches && !o2Matches) {
                    return -1;
                }
                if (!o1Matches && o2Matches) {
                    return 1;
                }
            }
            if (this.bySource && (result = o1.extras[0].compareTo(o2.extras[0])) != 0) {
                return result;
            }
            if (o1.extras[0].equals(o2.extras[0])) {
                if (this.byLength) {
                    if (o1.payload.length() < o2.payload.length()) {
                        return 1;
                    }
                    if (o1.payload.length() > o2.payload.length()) {
                        return -1;
                    }
                }
                if (this.alphabetically) {
                    return o1.payload.compareTo(o2.payload);
                }
            }
            int i1 = -1;
            int i2 = -1;
            for (int i = 0; i < this.entries.size(); ++i) {
                if (this.entries.get(i).getSrcText().equals(o1.extras[0])) {
                    i1 = i;
                }
                if (this.entries.get(i).getSrcText().equals(o2.extras[0])) {
                    i2 = i;
                }
                if (i1 != -1 && i2 != -1) break;
            }
            if (i1 < i2) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }
    }
}

