/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.List;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Preferences;

public class TransTips {
    private static List<Integer> afterExcludeCases = new ArrayList<Integer>();
    private static List<Integer> beforeExcludeCases;

    public static void search(String sourceText, GlossaryEntry glossaryEntry, Search callback) {
        int firstOffset = -1;
        String word = glossaryEntry.getSrcText();
        if (word == null || word.equals("")) {
            return;
        }
        String content = sourceText;
        if (!word.equals(word.toUpperCase())) {
            content = sourceText.toLowerCase();
            word = word.toLowerCase();
        }
        int lastIndex = 0;
        int wordSize = word.length();
        while ((lastIndex = content.indexOf(word, lastIndex)) != -1) {
            int endIndex = lastIndex + wordSize;
            if (Preferences.isPreference("transtips_exact_search")) {
                if (TransTips.isWordAlone(content, lastIndex, word)) {
                    callback.found(glossaryEntry, lastIndex, endIndex);
                    if (firstOffset == -1) {
                        firstOffset = lastIndex;
                    }
                }
            } else {
                callback.found(glossaryEntry, lastIndex, endIndex);
                if (firstOffset == -1) {
                    firstOffset = lastIndex;
                }
            }
            lastIndex = endIndex;
        }
    }

    public static boolean isWordAlone(String sourceText, int testIndex, String glosSrc) {
        int after;
        int before;
        sourceText = sourceText.replaceAll("[\u202a|\u202b|\u202c]", " ");
        try {
            before = sourceText.toLowerCase().codePointBefore(testIndex);
        }
        catch (Exception ex) {
            before = 32;
        }
        try {
            after = sourceText.toLowerCase().codePointAt(testIndex + glosSrc.length());
        }
        catch (Exception cp) {
            after = 32;
        }
        if (afterExcludeCases.contains(after)) {
            after = 32;
        }
        if (beforeExcludeCases.contains(before)) {
            before = 32;
        }
        return before == 32 && after == 32;
    }

    static {
        afterExcludeCases.add(46);
        afterExcludeCases.add(33);
        afterExcludeCases.add(63);
        afterExcludeCases.add(58);
        afterExcludeCases.add(44);
        afterExcludeCases.add(59);
        afterExcludeCases.add(60);
        afterExcludeCases.add(41);
        afterExcludeCases.add(45);
        beforeExcludeCases = new ArrayList<Integer>();
        beforeExcludeCases.add(62);
        beforeExcludeCases.add(40);
        beforeExcludeCases.add(32);
    }

    public static interface Search {
        public void found(GlossaryEntry var1, int var2, int var3);
    }
}

