/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.Locale;

public class StringUtil {
    public static final char TRUNCATE_CHAR = '\u2026';

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isLowerCase(String input) {
        int cp;
        if (input.isEmpty()) {
            return false;
        }
        boolean hasLetters = false;
        for (int i = 0; i < input.length(); i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            if (!Character.isLetter(cp)) continue;
            hasLetters = true;
            if (Character.isLowerCase(cp)) continue;
            return false;
        }
        return hasLetters;
    }

    public static boolean isUpperCase(String input) {
        int cp;
        if (input.isEmpty()) {
            return false;
        }
        boolean hasLetters = false;
        for (int i = 0; i < input.length(); i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            if (!Character.isLetter(cp)) continue;
            hasLetters = true;
            if (Character.isUpperCase(cp)) continue;
            return false;
        }
        return hasLetters;
    }

    public static boolean isMixedCase(String input) {
        int cp;
        if (input.isEmpty() || input.codePointCount(0, input.length()) < 2) {
            return false;
        }
        boolean hasUpper = false;
        boolean hasLower = false;
        for (int i = 0; i < input.length(); i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            if (!Character.isLetter(cp)) continue;
            if (Character.isUpperCase(cp) && i > 0) {
                hasUpper = true;
            } else if (Character.isLowerCase(cp)) {
                hasLower = true;
            }
            if (!hasUpper || !hasLower) continue;
            return true;
        }
        return false;
    }

    public static boolean isTitleCase(String input) {
        if (input.isEmpty()) {
            return false;
        }
        if (input.codePointCount(0, input.length()) > 1) {
            return StringUtil.isTitleCase(input.codePointAt(0)) && StringUtil.isLowerCase(input.substring(input.offsetByCodePoints(0, 1)));
        }
        return StringUtil.isTitleCase(input.codePointAt(0));
    }

    public static boolean isTitleCase(int codePoint) {
        return Character.isTitleCase(codePoint) || Character.isUpperCase(codePoint) && Character.toTitleCase(codePoint) == codePoint;
    }

    public static boolean isWhiteSpace(String input) {
        int cp;
        if (input.isEmpty()) {
            return false;
        }
        for (int i = 0; i < input.length(); i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            if (StringUtil.isWhiteSpace(cp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhiteSpace(int codePoint) {
        return Character.isWhitespace(codePoint) || codePoint == 160 || codePoint == 8199 || codePoint == 8239;
    }

    public static boolean isCJK(String input) {
        int cp;
        if (input.isEmpty()) {
            return false;
        }
        for (int i = 0; i < input.length(); i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            if (cp >= 11904) continue;
            return false;
        }
        return true;
    }

    public static String capitalizeFirst(String text, Locale locale) {
        int remainder = text.offsetByCodePoints(0, 1);
        String firstCP = text.substring(0, remainder);
        return StringUtil.toTitleCase(firstCP, locale) + text.substring(remainder);
    }

    public static String matchCapitalization(String text, String matchTo, Locale locale) {
        if (StringUtil.isEmpty(matchTo)) {
            return text;
        }
        if (text.startsWith(matchTo)) {
            return text;
        }
        if (StringUtil.isTitleCase(matchTo)) {
            return StringUtil.capitalizeFirst(text, locale);
        }
        if (StringUtil.isLowerCase(matchTo)) {
            return text.toLowerCase(locale);
        }
        if (StringUtil.isUpperCase(matchTo)) {
            return text.toUpperCase(locale);
        }
        return text;
    }

    public static String toTitleCase(String text, Locale locale) {
        int firstLetterIndex;
        int cp;
        if (text.isEmpty()) {
            return text;
        }
        for (firstLetterIndex = 0; firstLetterIndex < text.length() && !Character.isLetter(cp = text.codePointAt(firstLetterIndex)); firstLetterIndex += Character.charCount(cp)) {
        }
        if (firstLetterIndex == text.length()) {
            return text;
        }
        int firstTitleCase = Character.toTitleCase(text.codePointAt(firstLetterIndex));
        int remainderOffset = text.offsetByCodePoints(firstLetterIndex, 1);
        String first = Character.isTitleCase(firstTitleCase) ? String.valueOf(Character.toChars(firstTitleCase)) : text.substring(0, remainderOffset).toUpperCase(locale);
        return first + text.substring(remainderOffset).toLowerCase(locale);
    }

    public static <T> T nvl(T ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            return values[i];
        }
        return null;
    }

    public static long nvlLong(long ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0L) continue;
            return values[i];
        }
        return 0L;
    }

    public static <T> boolean equalsWithNulls(T v1, T v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 != null && v2 != null) {
            return v1.equals(v2);
        }
        return false;
    }

    public static <T extends Comparable<T>> int compareToWithNulls(T v1, T v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null && v2 != null) {
            return -1;
        }
        if (v1 != null && v2 == null) {
            return 1;
        }
        return v1.compareTo(v2);
    }

    public static String firstN(String str, int len) {
        if (str.codePointCount(0, str.length()) <= len) {
            return str;
        }
        return str.substring(0, str.offsetByCodePoints(0, len));
    }

    public static String truncate(String text, int len) {
        if (text.codePointCount(0, text.length()) <= len) {
            return text;
        }
        return StringUtil.firstN(text, len - 1) + '\u2026';
    }

    public static int getFirstLetterLowercase(String s) {
        int cp;
        if (s == null) {
            return 0;
        }
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            if (!Character.isLetter(cp)) continue;
            return Character.toLowerCase(cp);
        }
        return 0;
    }

    public static boolean isSubstringAfter(String text, int pos, String substring) {
        if (pos + substring.length() > text.length()) {
            return false;
        }
        return substring.equals(text.substring(pos, pos + substring.length()));
    }

    public static boolean isSubstringBefore(String text, int pos, String substring) {
        if (pos - substring.length() < 0) {
            return false;
        }
        return substring.equals(text.substring(pos - substring.length(), pos));
    }

    public static String stripFromEnd(String string, String ... toStrip) {
        if (string == null) {
            return null;
        }
        if (toStrip == null) {
            return string;
        }
        for (String s : toStrip) {
            if (!string.endsWith(s)) continue;
            string = string.substring(0, string.length() - s.length());
        }
        return string;
    }

    public static String normalizeUnicode(CharSequence text) {
        return Normalizer.isNormalized(text, Normalizer.Form.NFC) ? text.toString() : Normalizer.normalize(text, Normalizer.Form.NFC);
    }

    public static String removeXMLInvalidChars(String str) {
        int c;
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); i += Character.charCount(c)) {
            c = str.codePointAt(i);
            if (!StringUtil.isValidXMLChar(c)) {
                c = 32;
            }
            sb.appendCodePoint(c);
        }
        return sb.toString();
    }

    public static boolean isValidXMLChar(int codePoint) {
        if (codePoint < 32) {
            if (codePoint != 9 && codePoint != 10 && codePoint != 13) {
                return false;
            }
        } else if (!(codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF)) {
            return false;
        }
        return true;
    }

    public static String makeValidXML(String plaintext) {
        int cp;
        StringBuilder out = new StringBuilder();
        String text = StringUtil.removeXMLInvalidChars(plaintext);
        for (int i = 0; i < text.length(); i += Character.charCount(cp)) {
            cp = text.codePointAt(i);
            out.append(StringUtil.escapeXMLChars(cp));
        }
        return out.toString();
    }

    public static String compressSpaces(String str) {
        int cp;
        int strlen = str.length();
        StringBuilder res = new StringBuilder(strlen);
        boolean wasspace = true;
        for (int i = 0; i < strlen; i += Character.charCount(cp)) {
            cp = str.codePointAt(i);
            if (Character.isWhitespace(cp)) {
                if (wasspace) continue;
                wasspace = true;
                continue;
            }
            if (wasspace && res.length() > 0) {
                res.append(' ');
            }
            res.appendCodePoint(cp);
            wasspace = false;
        }
        return res.toString();
    }

    public static String escapeXMLChars(int cp) {
        switch (cp) {
            case 38: {
                return "&amp;";
            }
            case 62: {
                return "&gt;";
            }
            case 60: {
                return "&lt;";
            }
            case 34: {
                return "&quot;";
            }
        }
        return String.valueOf(Character.toChars(cp));
    }

    public static String unescapeXMLEntities(String text) {
        if (text.contains("&gt;")) {
            text = text.replaceAll("&gt;", ">");
        }
        if (text.contains("&lt;")) {
            text = text.replaceAll("&lt;", "<");
        }
        if (text.contains("&quot;")) {
            text = text.replaceAll("&quot;", "\"");
        }
        if (text.contains("&amp;")) {
            text = text.replaceAll("&amp;", "&");
        }
        return text;
    }

    public static boolean equal(String one, String two) {
        return one == null && two == null || one != null && one.equals(two);
    }

    public static String format(String str, Object ... arguments) {
        str = str.replaceAll("'", "''");
        return MessageFormat.format(str, arguments);
    }

    public static String normalizeWidth(String text) {
        StringBuilder sb = new StringBuilder(text);
        block197: for (int i = 0; i < sb.length(); ++i) {
            char ch = sb.charAt(i);
            if (ch >= '\uff01' && ch <= '\uff5e') {
                sb.setCharAt(i, (char)(ch - 65248));
                continue;
            }
            if (ch == '\u3000') {
                sb.setCharAt(i, ' ');
            }
            switch (ch) {
                case '\uff61': {
                    sb.setCharAt(i, '\u3002');
                    break;
                }
                case '\uff62': {
                    sb.setCharAt(i, '\u300c');
                    break;
                }
                case '\uff63': {
                    sb.setCharAt(i, '\u300d');
                    break;
                }
                case '\uff64': {
                    sb.setCharAt(i, '\u3001');
                    break;
                }
                case '\uff65': {
                    sb.setCharAt(i, '\u30fb');
                    break;
                }
                case '\uff66': {
                    sb.setCharAt(i, '\u30f2');
                    break;
                }
                case '\uff67': {
                    sb.setCharAt(i, '\u30a1');
                    break;
                }
                case '\uff68': {
                    sb.setCharAt(i, '\u30a3');
                    break;
                }
                case '\uff69': {
                    sb.setCharAt(i, '\u30a5');
                    break;
                }
                case '\uff6a': {
                    sb.setCharAt(i, '\u30a7');
                    break;
                }
                case '\uff6b': {
                    sb.setCharAt(i, '\u30a9');
                    break;
                }
                case '\uff6c': {
                    sb.setCharAt(i, '\u30e3');
                    break;
                }
                case '\uff6d': {
                    sb.setCharAt(i, '\u30e5');
                    break;
                }
                case '\uff6e': {
                    sb.setCharAt(i, '\u30e7');
                    break;
                }
                case '\uff6f': {
                    sb.setCharAt(i, '\u30c3');
                    break;
                }
                case '\uff70': {
                    sb.setCharAt(i, '\u30fc');
                    break;
                }
                case '\uff71': {
                    sb.setCharAt(i, '\u30a2');
                    break;
                }
                case '\uff72': {
                    sb.setCharAt(i, '\u30a4');
                    break;
                }
                case '\uff73': {
                    sb.setCharAt(i, '\u30a6');
                    break;
                }
                case '\uff74': {
                    sb.setCharAt(i, '\u30a8');
                    break;
                }
                case '\uff75': {
                    sb.setCharAt(i, '\u30aa');
                    break;
                }
                case '\uff76': {
                    sb.setCharAt(i, '\u30ab');
                    break;
                }
                case '\uff77': {
                    sb.setCharAt(i, '\u30ad');
                    break;
                }
                case '\uff78': {
                    sb.setCharAt(i, '\u30af');
                    break;
                }
                case '\uff79': {
                    sb.setCharAt(i, '\u30b1');
                    break;
                }
                case '\uff7a': {
                    sb.setCharAt(i, '\u30b3');
                    break;
                }
                case '\uff7b': {
                    sb.setCharAt(i, '\u30b5');
                    break;
                }
                case '\uff7c': {
                    sb.setCharAt(i, '\u30b7');
                    break;
                }
                case '\uff7d': {
                    sb.setCharAt(i, '\u30b9');
                    break;
                }
                case '\uff7e': {
                    sb.setCharAt(i, '\u30bb');
                    break;
                }
                case '\uff7f': {
                    sb.setCharAt(i, '\u30bd');
                    break;
                }
                case '\uff80': {
                    sb.setCharAt(i, '\u30bf');
                    break;
                }
                case '\uff81': {
                    sb.setCharAt(i, '\u30c1');
                    break;
                }
                case '\uff82': {
                    sb.setCharAt(i, '\u30c4');
                    break;
                }
                case '\uff83': {
                    sb.setCharAt(i, '\u30c6');
                    break;
                }
                case '\uff84': {
                    sb.setCharAt(i, '\u30c8');
                    break;
                }
                case '\uff85': {
                    sb.setCharAt(i, '\u30ca');
                    break;
                }
                case '\uff86': {
                    sb.setCharAt(i, '\u30cb');
                    break;
                }
                case '\uff87': {
                    sb.setCharAt(i, '\u30cc');
                    break;
                }
                case '\uff88': {
                    sb.setCharAt(i, '\u30cd');
                    break;
                }
                case '\uff89': {
                    sb.setCharAt(i, '\u30ce');
                    break;
                }
                case '\uff8a': {
                    sb.setCharAt(i, '\u30cf');
                    break;
                }
                case '\uff8b': {
                    sb.setCharAt(i, '\u30d2');
                    break;
                }
                case '\uff8c': {
                    sb.setCharAt(i, '\u30d5');
                    break;
                }
                case '\uff8d': {
                    sb.setCharAt(i, '\u30d8');
                    break;
                }
                case '\uff8e': {
                    sb.setCharAt(i, '\u30db');
                    break;
                }
                case '\uff8f': {
                    sb.setCharAt(i, '\u30de');
                    break;
                }
                case '\uff90': {
                    sb.setCharAt(i, '\u30df');
                    break;
                }
                case '\uff91': {
                    sb.setCharAt(i, '\u30e0');
                    break;
                }
                case '\uff92': {
                    sb.setCharAt(i, '\u30e1');
                    break;
                }
                case '\uff93': {
                    sb.setCharAt(i, '\u30e2');
                    break;
                }
                case '\uff94': {
                    sb.setCharAt(i, '\u30e4');
                    break;
                }
                case '\uff95': {
                    sb.setCharAt(i, '\u30e6');
                    break;
                }
                case '\uff96': {
                    sb.setCharAt(i, '\u30e8');
                    break;
                }
                case '\uff97': {
                    sb.setCharAt(i, '\u30e9');
                    break;
                }
                case '\uff98': {
                    sb.setCharAt(i, '\u30ea');
                    break;
                }
                case '\uff99': {
                    sb.setCharAt(i, '\u30eb');
                    break;
                }
                case '\uff9a': {
                    sb.setCharAt(i, '\u30ec');
                    break;
                }
                case '\uff9b': {
                    sb.setCharAt(i, '\u30ed');
                    break;
                }
                case '\uff9c': {
                    sb.setCharAt(i, '\u30ef');
                    break;
                }
                case '\uff9d': {
                    sb.setCharAt(i, '\u30f3');
                    break;
                }
                case '\uff9e': {
                    sb.setCharAt(i, '\u3099');
                    break;
                }
                case '\uff9f': {
                    sb.setCharAt(i, '\u309a');
                }
            }
            if (ch > '\uffa1' && ch <= '\uffbe') {
                sb.setCharAt(i, (char)(ch - 52848));
                continue;
            }
            switch (ch) {
                case '\uffa0': {
                    sb.setCharAt(i, '\u3164');
                    break;
                }
                case '\uffda': {
                    sb.setCharAt(i, '\u3161');
                    break;
                }
                case '\uffdb': {
                    sb.setCharAt(i, '\u3162');
                    break;
                }
                case '\uffdc': {
                    sb.setCharAt(i, '\u3163');
                    break;
                }
                case '\uffe8': {
                    sb.setCharAt(i, '\u2502');
                    break;
                }
                case '\uffe9': {
                    sb.setCharAt(i, '\u2190');
                    break;
                }
                case '\uffea': {
                    sb.setCharAt(i, '\u2191');
                    break;
                }
                case '\uffeb': {
                    sb.setCharAt(i, '\u2192');
                    break;
                }
                case '\uffec': {
                    sb.setCharAt(i, '\u2193');
                    break;
                }
                case '\uffed': {
                    sb.setCharAt(i, '\u25a0');
                    break;
                }
                case '\uffee': {
                    sb.setCharAt(i, '\u25cb');
                }
            }
            switch (ch) {
                case '\u2100': {
                    sb.setCharAt(i, 'a');
                    sb.insert(i + 1, "/c");
                    i += 2;
                    break;
                }
                case '\u2101': {
                    sb.setCharAt(i, 'a');
                    sb.insert(i + 1, "/s");
                    i += 2;
                    break;
                }
                case '\u2105': {
                    sb.setCharAt(i, 'c');
                    sb.insert(i + 1, "/o");
                    i += 2;
                    break;
                }
                case '\u2103': {
                    sb.setCharAt(i, '\u00b0');
                    sb.insert(i + 1, "C");
                    ++i;
                    break;
                }
                case '\u2109': {
                    sb.setCharAt(i, '\u00b0');
                    sb.insert(i + 1, "F");
                    ++i;
                    break;
                }
                case '\u2116': {
                    sb.setCharAt(i, 'N');
                    sb.insert(i + 1, "o");
                    ++i;
                    break;
                }
                case '\u212a': {
                    sb.setCharAt(i, 'K');
                    break;
                }
                case '\u212b': {
                    sb.setCharAt(i, '\u00c5');
                }
            }
            switch (ch) {
                case '\u3371': {
                    sb.setCharAt(i, 'h');
                    sb.insert(i + 1, "Pa");
                    i += 2;
                    continue block197;
                }
                case '\u3372': {
                    sb.setCharAt(i, 'd');
                    sb.insert(i + 1, "a");
                    ++i;
                    continue block197;
                }
                case '\u3373': {
                    sb.setCharAt(i, 'A');
                    sb.insert(i + 1, "U");
                    ++i;
                    continue block197;
                }
                case '\u3374': {
                    sb.setCharAt(i, 'b');
                    sb.insert(i + 1, "ar");
                    i += 2;
                    continue block197;
                }
                case '\u3375': {
                    sb.setCharAt(i, 'o');
                    sb.insert(i + 1, "V");
                    ++i;
                    continue block197;
                }
                case '\u3376': {
                    sb.setCharAt(i, 'p');
                    sb.insert(i + 1, "c");
                    ++i;
                    continue block197;
                }
                case '\u3377': {
                    sb.setCharAt(i, 'd');
                    sb.insert(i + 1, "m");
                    ++i;
                    continue block197;
                }
                case '\u3378': {
                    sb.setCharAt(i, 'd');
                    sb.insert(i + 1, "m\u00b2");
                    i += 2;
                    continue block197;
                }
                case '\u3379': {
                    sb.setCharAt(i, 'd');
                    sb.insert(i + 1, "m\u00b3");
                    i += 2;
                    continue block197;
                }
                case '\u337a': {
                    sb.setCharAt(i, 'I');
                    sb.insert(i + 1, "U");
                    ++i;
                    continue block197;
                }
                case '\u3380': {
                    sb.setCharAt(i, 'p');
                    sb.insert(i + 1, "A");
                    ++i;
                    continue block197;
                }
                case '\u3381': {
                    sb.setCharAt(i, 'n');
                    sb.insert(i + 1, "A");
                    ++i;
                    continue block197;
                }
                case '\u3382': {
                    sb.setCharAt(i, '\u03bc');
                    sb.insert(i + 1, "A");
                    ++i;
                    continue block197;
                }
                case '\u3383': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "A");
                    ++i;
                    continue block197;
                }
                case '\u3384': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "A");
                    ++i;
                    continue block197;
                }
                case '\u3385': {
                    sb.setCharAt(i, 'K');
                    sb.insert(i + 1, "B");
                    ++i;
                    continue block197;
                }
                case '\u3386': {
                    sb.setCharAt(i, 'M');
                    sb.insert(i + 1, "B");
                    ++i;
                    continue block197;
                }
                case '\u3387': {
                    sb.setCharAt(i, 'G');
                    sb.insert(i + 1, "B");
                    ++i;
                    continue block197;
                }
                case '\u3388': {
                    sb.setCharAt(i, 'c');
                    sb.insert(i + 1, "al");
                    i += 2;
                    continue block197;
                }
                case '\u3389': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "cal");
                    i += 3;
                    continue block197;
                }
                case '\u338a': {
                    sb.setCharAt(i, 'p');
                    sb.insert(i + 1, "F");
                    ++i;
                    continue block197;
                }
                case '\u338b': {
                    sb.setCharAt(i, 'n');
                    sb.insert(i + 1, "F");
                    ++i;
                    continue block197;
                }
                case '\u338c': {
                    sb.setCharAt(i, '\u03bc');
                    sb.insert(i + 1, "F");
                    ++i;
                    continue block197;
                }
                case '\u338d': {
                    sb.setCharAt(i, '\u03bc');
                    sb.insert(i + 1, "g");
                    ++i;
                    continue block197;
                }
                case '\u338e': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "g");
                    ++i;
                    continue block197;
                }
                case '\u338f': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "g");
                    ++i;
                    continue block197;
                }
                case '\u3390': {
                    sb.setCharAt(i, 'H');
                    sb.insert(i + 1, "z");
                    ++i;
                    continue block197;
                }
                case '\u3391': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "Hz");
                    i += 2;
                    continue block197;
                }
                case '\u3392': {
                    sb.setCharAt(i, 'M');
                    sb.insert(i + 1, "Hz");
                    i += 2;
                    continue block197;
                }
                case '\u3393': {
                    sb.setCharAt(i, 'G');
                    sb.insert(i + 1, "Hz");
                    i += 2;
                    continue block197;
                }
                case '\u3394': {
                    sb.setCharAt(i, 'T');
                    sb.insert(i + 1, "Hz");
                    i += 2;
                    continue block197;
                }
                case '\u3395': {
                    sb.setCharAt(i, '\u03bc');
                    sb.insert(i + 1, "\u2113");
                    ++i;
                    continue block197;
                }
                case '\u3396': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "\u2113");
                    ++i;
                    continue block197;
                }
                case '\u3397': {
                    sb.setCharAt(i, 'd');
                    sb.insert(i + 1, "\u2113");
                    ++i;
                    continue block197;
                }
                case '\u3398': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "\u2113");
                    ++i;
                    continue block197;
                }
                case '\u3399': {
                    sb.setCharAt(i, 'f');
                    sb.insert(i + 1, "m");
                    ++i;
                    continue block197;
                }
                case '\u339a': {
                    sb.setCharAt(i, 'n');
                    sb.insert(i + 1, "m");
                    ++i;
                    continue block197;
                }
                case '\u339b': {
                    sb.setCharAt(i, '\u03bc');
                    sb.insert(i + 1, "m");
                    ++i;
                    continue block197;
                }
                case '\u339c': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "m");
                    ++i;
                    continue block197;
                }
                case '\u339d': {
                    sb.setCharAt(i, 'c');
                    sb.insert(i + 1, "m");
                    ++i;
                    continue block197;
                }
                case '\u339e': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "m");
                    ++i;
                    continue block197;
                }
                case '\u339f': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "m\u00b2");
                    i += 2;
                    continue block197;
                }
                case '\u33a0': {
                    sb.setCharAt(i, 'c');
                    sb.insert(i + 1, "m\u00b2");
                    i += 2;
                    continue block197;
                }
                case '\u33a1': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "\u00b2");
                    ++i;
                    continue block197;
                }
                case '\u33a2': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "m\u00b2");
                    i += 2;
                    continue block197;
                }
                case '\u33a3': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "m\u00b3");
                    i += 2;
                    continue block197;
                }
                case '\u33a4': {
                    sb.setCharAt(i, 'c');
                    sb.insert(i + 1, "m\u00b3");
                    i += 2;
                    continue block197;
                }
                case '\u33a5': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "\u00b3");
                    ++i;
                    continue block197;
                }
                case '\u33a6': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "m\u00b3");
                    i += 2;
                    continue block197;
                }
                case '\u33a7': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "/s");
                    i += 2;
                    continue block197;
                }
                case '\u33a8': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "/s\u00b2");
                    i += 3;
                    continue block197;
                }
                case '\u33a9': {
                    sb.setCharAt(i, 'P');
                    sb.insert(i + 1, "a");
                    ++i;
                    continue block197;
                }
                case '\u33aa': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "Pa");
                    i += 2;
                    continue block197;
                }
                case '\u33ab': {
                    sb.setCharAt(i, 'M');
                    sb.insert(i + 1, "Pa");
                    i += 2;
                    continue block197;
                }
                case '\u33ac': {
                    sb.setCharAt(i, 'G');
                    sb.insert(i + 1, "Pa");
                    i += 2;
                    continue block197;
                }
                case '\u33ad': {
                    sb.setCharAt(i, 'r');
                    sb.insert(i + 1, "ad");
                    i += 2;
                    continue block197;
                }
                case '\u33ae': {
                    sb.setCharAt(i, 'r');
                    sb.insert(i + 1, "ad/s");
                    i += 4;
                    continue block197;
                }
                case '\u33af': {
                    sb.setCharAt(i, 'r');
                    sb.insert(i + 1, "ad/s\u00b2");
                    i += 5;
                    continue block197;
                }
                case '\u33b0': {
                    sb.setCharAt(i, 'p');
                    sb.insert(i + 1, "s");
                    ++i;
                    continue block197;
                }
                case '\u33b1': {
                    sb.setCharAt(i, 'n');
                    sb.insert(i + 1, "s");
                    ++i;
                    continue block197;
                }
                case '\u33b2': {
                    sb.setCharAt(i, '\u03bc');
                    sb.insert(i + 1, "s");
                    ++i;
                    continue block197;
                }
                case '\u33b3': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "s");
                    ++i;
                    continue block197;
                }
                case '\u33b4': {
                    sb.setCharAt(i, 'p');
                    sb.insert(i + 1, "V");
                    ++i;
                    continue block197;
                }
                case '\u33b5': {
                    sb.setCharAt(i, 'n');
                    sb.insert(i + 1, "V");
                    ++i;
                    continue block197;
                }
                case '\u33b6': {
                    sb.setCharAt(i, '\u03bc');
                    sb.insert(i + 1, "V");
                    ++i;
                    continue block197;
                }
                case '\u33b7': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "V");
                    ++i;
                    continue block197;
                }
                case '\u33b8': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "V");
                    ++i;
                    continue block197;
                }
                case '\u33b9': {
                    sb.setCharAt(i, 'M');
                    sb.insert(i + 1, "V");
                    ++i;
                    continue block197;
                }
                case '\u33ba': {
                    sb.setCharAt(i, 'p');
                    sb.insert(i + 1, "W");
                    ++i;
                    continue block197;
                }
                case '\u33bb': {
                    sb.setCharAt(i, 'n');
                    sb.insert(i + 1, "W");
                    ++i;
                    continue block197;
                }
                case '\u33bc': {
                    sb.setCharAt(i, '\u03bc');
                    sb.insert(i + 1, "W");
                    ++i;
                    continue block197;
                }
                case '\u33bd': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "W");
                    ++i;
                    continue block197;
                }
                case '\u33be': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "W");
                    ++i;
                    continue block197;
                }
                case '\u33bf': {
                    sb.setCharAt(i, 'M');
                    sb.insert(i + 1, "W");
                    ++i;
                    continue block197;
                }
                case '\u33c0': {
                    sb.setCharAt(i, 'k');
                    sb.insert(i + 1, "\u03a9");
                    ++i;
                    continue block197;
                }
                case '\u33c1': {
                    sb.setCharAt(i, 'M');
                    sb.insert(i + 1, "\u03a9");
                    ++i;
                    continue block197;
                }
                case '\u33c2': {
                    sb.setCharAt(i, 'a');
                    sb.insert(i + 1, ".m.");
                    i += 3;
                    continue block197;
                }
                case '\u33c3': {
                    sb.setCharAt(i, 'B');
                    sb.insert(i + 1, "q");
                    ++i;
                    continue block197;
                }
                case '\u33c4': {
                    sb.setCharAt(i, 'c');
                    sb.insert(i + 1, "c");
                    ++i;
                    continue block197;
                }
                case '\u33c5': {
                    sb.setCharAt(i, 'c');
                    sb.insert(i + 1, "d");
                    ++i;
                    continue block197;
                }
                case '\u33c6': {
                    sb.setCharAt(i, 'C');
                    sb.insert(i + 1, "/kg");
                    i += 3;
                    continue block197;
                }
                case '\u33c7': {
                    sb.setCharAt(i, 'C');
                    sb.insert(i + 1, "o.");
                    i += 2;
                    continue block197;
                }
                case '\u33c8': {
                    sb.setCharAt(i, 'd');
                    sb.insert(i + 1, "B");
                    ++i;
                    continue block197;
                }
                case '\u33c9': {
                    sb.setCharAt(i, 'G');
                    sb.insert(i + 1, "y");
                    ++i;
                    continue block197;
                }
                case '\u33ca': {
                    sb.setCharAt(i, 'h');
                    sb.insert(i + 1, "a");
                    ++i;
                    continue block197;
                }
                case '\u33cb': {
                    sb.setCharAt(i, 'H');
                    sb.insert(i + 1, "P");
                    ++i;
                    continue block197;
                }
                case '\u33cc': {
                    sb.setCharAt(i, 'i');
                    sb.insert(i + 1, "n");
                    ++i;
                    continue block197;
                }
                case '\u33cd': {
                    sb.setCharAt(i, 'K');
                    sb.insert(i + 1, "K");
                    ++i;
                    continue block197;
                }
                case '\u33ce': {
                    sb.setCharAt(i, 'K');
                    sb.insert(i + 1, "M");
                    ++i;
                    continue block197;
                }
                case '\u33cf': {
                    sb.setCharAt(i, 'K');
                    sb.insert(i + 1, "t");
                    ++i;
                    continue block197;
                }
                case '\u33d0': {
                    sb.setCharAt(i, 'l');
                    sb.insert(i + 1, "m");
                    ++i;
                    continue block197;
                }
                case '\u33d1': {
                    sb.setCharAt(i, 'l');
                    sb.insert(i + 1, "n");
                    ++i;
                    continue block197;
                }
                case '\u33d2': {
                    sb.setCharAt(i, 'l');
                    sb.insert(i + 1, "og");
                    i += 2;
                    continue block197;
                }
                case '\u33d3': {
                    sb.setCharAt(i, 'l');
                    sb.insert(i + 1, "x");
                    ++i;
                    continue block197;
                }
                case '\u33d4': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "b");
                    ++i;
                    continue block197;
                }
                case '\u33d5': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "il");
                    i += 2;
                    continue block197;
                }
                case '\u33d6': {
                    sb.setCharAt(i, 'm');
                    sb.insert(i + 1, "ol");
                    i += 2;
                    continue block197;
                }
                case '\u33d7': {
                    sb.setCharAt(i, 'p');
                    sb.insert(i + 1, "H");
                    ++i;
                    continue block197;
                }
                case '\u33d8': {
                    sb.setCharAt(i, 'p');
                    sb.insert(i + 1, ".m.");
                    i += 3;
                    continue block197;
                }
                case '\u33d9': {
                    sb.setCharAt(i, 'P');
                    sb.insert(i + 1, "PM");
                    i += 2;
                    continue block197;
                }
                case '\u33da': {
                    sb.setCharAt(i, 'P');
                    sb.insert(i + 1, "R");
                    ++i;
                    continue block197;
                }
                case '\u33db': {
                    sb.setCharAt(i, 's');
                    sb.insert(i + 1, "r");
                    ++i;
                    continue block197;
                }
                case '\u33dc': {
                    sb.setCharAt(i, 'S');
                    sb.insert(i + 1, "v");
                    ++i;
                    continue block197;
                }
                case '\u33dd': {
                    sb.setCharAt(i, 'W');
                    sb.insert(i + 1, "b");
                    ++i;
                    continue block197;
                }
                case '\u33de': {
                    sb.setCharAt(i, 'v');
                    sb.insert(i + 1, "/m");
                    i += 2;
                    continue block197;
                }
                case '\u33df': {
                    sb.setCharAt(i, 'a');
                    sb.insert(i + 1, "/m");
                    i += 2;
                    continue block197;
                }
                case '\u33ff': {
                    sb.setCharAt(i, 'g');
                    sb.insert(i + 1, "al");
                    i += 2;
                }
            }
        }
        String result = sb.toString();
        if (text.equals(result)) {
            return text;
        }
        return StringUtil.normalizeUnicode(result);
    }

    public static String rstrip(String text) {
        int cp;
        for (int i = text.length(); i >= 0; i -= Character.charCount(cp)) {
            if (i == 0) {
                return "";
            }
            cp = text.codePointBefore(i);
            if (Character.isWhitespace(cp)) continue;
            return text.substring(0, i);
        }
        return text;
    }
}

