/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omegat.core.Core;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXDateParser;
import org.omegat.util.xml.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TMXReader
extends DefaultHandler {
    private String creationtool = null;
    public static final String CT_OMEGAT = "OmegaT";
    private String creationtoolversion = null;
    public static final String CTV_OMEGAT_1 = "1";
    public static final String CTV_OMEGAT_1_6_RC3_RC11 = "1.6";
    public static final String CTV_OMEGAT_1_6_RC12 = "1.6 RC12";
    public static final String CTV_OMEGAT_1_6_0_FINAL = "1.6.0";
    public static final String CTV_OMEGAT_1_6_1 = "1.6.1";
    public static final String CTV_OMEGAT_CURRENT = "1.6.1";
    boolean upgradeCheckComplete = false;
    boolean upgrade14X = false;
    boolean upgradeSentSeg = false;
    private String segtype;
    public static final String SEG_PARAGRAPH = "paragraph";
    public static final String SEG_SENTENCE = "sentence";
    private int tagNumber;
    private StringBuffer currentTag = new StringBuffer();
    private boolean insideTag;
    private boolean closeTag;
    private boolean standAloneTag;
    private static final String TMX_TMX_TAG = "tmx";
    private static final String TMX_TAG_HEADER = "header";
    private static final String TMX_TAG_BODY = "body";
    private static final String TMX_TAG_TU = "tu";
    private static final String TMX_TAG_TUV = "tuv";
    private static final String TMX_TAG_SEG = "seg";
    private static final String TMX_TAG_BPT = "bpt";
    private static final String TMX_TAG_EPT = "ept";
    private static final String TMX_TAG_HI = "hi";
    private static final String TMX_TAG_IT = "it";
    private static final String TMX_TAG_PH = "ph";
    private static final String TMX_TAG_UT = "ut";
    private static final String TMX_TAG_SUB = "sub";
    private static final String TMX_TAG_PROP = "prop";
    private static final String TMX_TAG_INLINE = "inline";
    private static final String TMX_TAG_NONE = "none";
    private static final String TMX_ATTR_LANG = "lang";
    private static final String TMX_ATTR_LANG_NS = "xml:lang";
    private static final String TMX_ATTR_CREATIONTOOL = "creationtool";
    private static final String TMX_ATTR_CREATIONTOOLVERSION = "creationtoolversion";
    private static final String TMX_ATTR_SEGTYPE = "segtype";
    private static final String TMX_ATTR_SRCLANG = "srclang";
    private static final String TMX_ATTR_TYPE = "type";
    private static final String TMX_ATTR_CHANGEID = "changeid";
    private static final String TMX_ATTR_CHANGEDATE = "changedate";
    private static final String TMX_ATTR_CREATIONID = "creationid";
    private static final String TMX_ATTR_CREATIONDATE = "creationdate";
    private static final String PROPERTY_VARIANT_LANGUAGES = "OmegaT:VariantLanguages";
    private String m_encoding;
    private List<String> m_srcList;
    private List<String> m_tarList;
    private List<String> m_tarChangeIdList;
    private List<Long> m_tarChangeDateList;
    private Map<String, String> m_properties;
    private Set<String> m_variantLanguages;
    private Language sourceLang;
    private Language targetLang;
    private String sourceLanguage;
    private String targetLanguage;
    private String tmxSourceLanguage;
    private boolean includeLevel2;
    private boolean isOmegaT;
    private boolean isProjectTMX;
    private boolean headerParsed;
    private boolean inHeader;
    private boolean inProperty;
    private boolean inTU;
    private boolean inTUV;
    private boolean inSegment;
    private boolean sourceNotFound;
    private List<TUV> tuvs;
    private Stack<String> currentElement;
    private Stack<StringBuffer> currentSub;
    private String currentProperty;
    private boolean isSegmentingEnabled;
    private TMXDateParser dateParser;

    public TMXReader(String encoding, Language sourceLanguage, Language targetLanguage, boolean isSegmentingEnabled) {
        this.m_encoding = encoding;
        this.m_srcList = new ArrayList<String>();
        this.m_tarList = new ArrayList<String>();
        this.m_tarChangeIdList = new ArrayList<String>();
        this.m_tarChangeDateList = new ArrayList<Long>();
        this.m_properties = new HashMap<String, String>();
        this.m_variantLanguages = new HashSet<String>();
        this.sourceLang = sourceLanguage;
        this.targetLang = targetLanguage;
        this.sourceLanguage = sourceLanguage.getLanguage();
        this.targetLanguage = targetLanguage.getLanguage();
        this.isSegmentingEnabled = isSegmentingEnabled;
        this.dateParser = new TMXDateParser();
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public int numSegments() {
        return this.m_srcList.size();
    }

    public String getSourceSegment(int n) {
        if (n < 0 || n >= this.numSegments()) {
            return "";
        }
        return this.m_srcList.get(n);
    }

    public String getTargetSegment(int n) {
        if (n < 0 || n >= this.numSegments()) {
            return "";
        }
        return this.m_tarList.get(n);
    }

    public String getTargetChangeId(int n) {
        if (n < 0 || n >= this.numSegments()) {
            return null;
        }
        return this.m_tarChangeIdList.get(n);
    }

    public long getTargetChangeDate(int n) {
        if (n < 0 || n >= this.numSegments()) {
            return 0L;
        }
        return this.m_tarChangeDateList.get(n);
    }

    public String getCreationTool() {
        return this.creationtool;
    }

    public String getCreationToolVersion() {
        return this.creationtoolversion;
    }

    public String getProperty(String name) {
        return this.m_properties.get(name);
    }

    private void checkForUpgrades() {
        if (!this.upgradeCheckComplete) {
            if (this.getCreationTool() == null || this.getCreationToolVersion() == null) {
                return;
            }
            if (CT_OMEGAT.equals(this.getCreationTool())) {
                this.upgrade14X = this.getCreationToolVersion().compareTo(CTV_OMEGAT_1) <= 0;
                this.upgradeSentSeg = SEG_PARAGRAPH.equals(this.getSegType()) && this.isSegmentingEnabled;
            }
            this.upgradeCheckComplete = true;
        }
    }

    private boolean isUpgradeSentSeg() {
        this.checkForUpgrades();
        return this.upgradeSentSeg;
    }

    private boolean isUpgrade14X() {
        this.checkForUpgrades();
        return this.upgrade14X;
    }

    private String upgradeSegment(String segment) {
        if (this.isUpgrade14X()) {
            segment = this.upgradeOldTagsNumberingAndPairs(segment);
        }
        return segment;
    }

    private String upgradeOldTagsNumberingAndPairs(String segment) {
        if (!PatternConsts.OMEGAT_TAG.matcher(segment).find()) {
            return segment;
        }
        try {
            int i;
            boolean alone;
            StringBuffer buf = new StringBuffer(segment);
            Matcher matcher = PatternConsts.OMEGAT_TAG_DECOMPILE.matcher(segment);
            int tagstart = matcher.start();
            int tagend = matcher.end();
            boolean end = !matcher.group(1).isEmpty();
            String name = matcher.group(2);
            int num = Integer.parseInt(matcher.group(3));
            boolean bl = alone = !matcher.group(4).isEmpty();
            if (num == 1) {
                num = 0;
            }
            Tag tag = new Tag(end, name, num, alone);
            ArrayList<Tag> unclosedTags = new ArrayList<Tag>();
            ArrayList<Tag> unopenedTags = new ArrayList<Tag>();
            HashMap<String, Tag> unclosedTagsNames = new HashMap<String, Tag>();
            HashMap<String, Tag> unopenedTagsNames = new HashMap<String, Tag>();
            if (end) {
                unopenedTags.add(tag);
                unopenedTagsNames.put(name, tag);
            } else if (!alone) {
                unclosedTags.add(tag);
                unclosedTagsNames.put(name, tag);
            }
            int maxnum = num;
            buf.replace(tagstart, tagend, tag.toString());
            while (matcher.find()) {
                tagstart = matcher.start();
                tagend = matcher.end();
                end = !matcher.group(1).isEmpty();
                name = matcher.group(2);
                alone = !matcher.group(4).isEmpty();
                tag = new Tag(end, name, num, alone);
                if (end && unclosedTagsNames.containsKey(name)) {
                    Tag starttag = (Tag)unclosedTagsNames.get(name);
                    num = starttag.num;
                    unclosedTagsNames.remove(name);
                    unclosedTags.remove(starttag);
                } else {
                    num = maxnum + 1;
                    if (end) {
                        unopenedTags.add(tag);
                        unopenedTagsNames.put(name, tag);
                    } else if (!alone) {
                        unclosedTags.add(tag);
                        unclosedTagsNames.put(name, tag);
                    }
                }
                if (maxnum < num) {
                    maxnum = num;
                }
                buf.replace(tagstart, tagend, tag.toString());
            }
            StringBuffer res = new StringBuffer();
            for (i = unopenedTags.size() - 1; i > 0; --i) {
                tag = (Tag)unopenedTags.get(i);
                res.append(tag.toStringPaired());
            }
            res.append(buf);
            for (i = unclosedTags.size() - 1; i > 0; --i) {
                tag = (Tag)unclosedTags.get(i);
                res.append(tag.toStringPaired());
            }
            return res.toString();
        }
        catch (Exception e) {
            return segment;
        }
    }

    private void storeSegment(String source, String translation, String changeId, long changeDate) {
        source = StringUtil.normalizeUnicode(source);
        source = this.upgradeSegment(source);
        translation = StringUtil.normalizeUnicode(translation);
        translation = this.upgradeSegment(translation);
        if (this.isUpgradeSentSeg()) {
            List<String> srcSegments = Core.getSegmenter().segment(this.sourceLang, source, null, null);
            List<String> tarSegments = Core.getSegmenter().segment(this.targetLang, translation, null, null);
            int n = srcSegments.size();
            if (n == tarSegments.size()) {
                for (int j = 0; j < n; ++j) {
                    String srcseg = srcSegments.get(j);
                    String tarseg = tarSegments.get(j);
                    this.m_srcList.add(srcseg);
                    this.m_tarList.add(tarseg);
                    this.m_tarChangeDateList.add(changeDate);
                    this.m_tarChangeIdList.add(changeId);
                }
            } else {
                this.m_srcList.add(source);
                this.m_tarList.add(translation);
                this.m_tarChangeDateList.add(changeDate);
                this.m_tarChangeIdList.add(changeId);
            }
        } else {
            this.m_srcList.add(source);
            this.m_tarList.add(translation);
            this.m_tarChangeDateList.add(changeDate);
            this.m_tarChangeIdList.add(changeId);
        }
    }

    public String getSegType() {
        return this.segtype;
    }

    private void checkLevel2() {
        this.isOmegaT = this.includeLevel2 = this.creationtool.equals(CT_OMEGAT);
    }

    public void loadFile(String filename, boolean isProjectTMX) throws IOException {
        this.isProjectTMX = isProjectTMX;
        String displayFilename = filename.endsWith(".tmp") ? filename.substring(0, filename.length() - 4) : filename;
        try {
            Log.logRB("TMXR_INFO_READING_FILE", displayFilename);
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(false);
            SAXParser parser = parserFactory.newSAXParser();
            parser.getXMLReader().setEntityResolver(this);
            InputSource is = new InputSource(new XMLReader(filename, this.m_encoding));
            is.setSystemId("");
            parser.parse(is, (DefaultHandler)this);
            if (!isProjectTMX && this.sourceNotFound) {
                Log.logWarningRB("TMXR_WARNING_SOURCE_NOT_FOUND", new Object[0]);
            }
            Log.logRB("TMXR_INFO_READING_COMPLETE", new Object[0]);
            Log.log("");
        }
        catch (SAXParseException ex) {
            Log.logErrorRB(ex, "TMXR_FATAL_ERROR_WHILE_PARSING", ex.getLineNumber(), ex.getColumnNumber());
            Core.getMainWindow().displayErrorRB(ex, "TMXR_FATAL_ERROR_WHILE_PARSING", ex.getLineNumber(), ex.getColumnNumber());
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "TMXR_EXCEPTION_WHILE_PARSING", displayFilename, Log.getLogLocation());
            Core.getMainWindow().displayErrorRB(ex, "TMXR_EXCEPTION_WHILE_PARSING", displayFilename, Log.getLogLocation());
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        Log.logWarningRB("TMXR_WARNING_WHILE_PARSING", exception.getLineNumber(), exception.getColumnNumber());
        Log.log(exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        Log.logErrorRB("TMXR_RECOVERABLE_ERROR_WHILE_PARSING", exception.getLineNumber(), exception.getColumnNumber());
        Log.log(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        Log.logErrorRB("TMXR_FATAL_ERROR_WHILE_PARSING", exception.getLineNumber(), exception.getColumnNumber());
        Log.log(exception);
    }

    @Override
    public void startDocument() {
        this.headerParsed = false;
        this.inHeader = false;
        this.inTU = false;
        this.inTUV = false;
        this.inSegment = false;
        this.tuvs = new ArrayList<TUV>();
        this.currentElement = new Stack();
        this.currentSub = new Stack();
        this.currentElement.push(TMX_TAG_NONE);
    }

    @Override
    public void endDocument() {
        this.tuvs = null;
        this.currentElement = null;
        this.currentSub = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(TMX_TAG_HEADER)) {
            this.startElementHeader(attributes);
        } else if (qName.equals(TMX_TAG_TU)) {
            this.startElementTU(attributes);
        } else if (qName.equals(TMX_TAG_TUV)) {
            this.startElementTUV(attributes);
        } else if (qName.equals(TMX_TAG_SEG)) {
            this.startElementSegment(attributes);
        } else if (qName.equals(TMX_TAG_BPT) || qName.equals(TMX_TAG_EPT) || qName.equals(TMX_TAG_HI) || qName.equals(TMX_TAG_IT) || qName.equals(TMX_TAG_PH) || qName.equals(TMX_TAG_UT)) {
            ++this.tagNumber;
            if (qName.equals(TMX_TAG_EPT)) {
                this.closeTag = true;
                --this.tagNumber;
            } else {
                this.closeTag = false;
            }
            this.standAloneTag = !qName.equals(TMX_TAG_BPT) && !qName.equals(TMX_TAG_EPT);
            this.startElementInline(attributes);
        } else if (qName.equals(TMX_TAG_SUB)) {
            this.startElementSub(attributes);
        } else if (qName.equals(TMX_TAG_PROP)) {
            this.startElementProperty(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(TMX_TAG_HEADER)) {
            this.endElementHeader();
        } else if (qName.equals(TMX_TAG_TU)) {
            this.endElementTU();
        } else if (qName.equals(TMX_TAG_TUV)) {
            this.endElementTUV();
        } else if (qName.equals(TMX_TAG_SEG)) {
            this.endElementSegment();
        } else if (qName.equals(TMX_TAG_BPT) || qName.equals(TMX_TAG_EPT) || qName.equals(TMX_TAG_HI) || qName.equals(TMX_TAG_IT) || qName.equals(TMX_TAG_PH) || qName.equals(TMX_TAG_UT)) {
            this.endElementInline();
        } else if (qName.equals(TMX_TAG_SUB)) {
            this.endElementSub();
        } else if (qName.equals(TMX_TAG_PROP)) {
            this.endElementProperty();
        }
    }

    private StringBuffer makeShortcut(StringBuffer tag) {
        char letter = ' ';
        String returnTag = "<";
        String tagEnding = ">";
        if (this.closeTag) {
            returnTag = returnTag + "/";
        }
        if (this.standAloneTag && Preferences.isPreference("ext_tmx_use_slash")) {
            tagEnding = "/>";
        }
        for (int i = 0; i < tag.length(); ++i) {
            letter = tag.charAt(i);
            if (!Character.isLetter(letter)) continue;
            letter = Character.toLowerCase(letter);
            return new StringBuffer(returnTag + String.valueOf(letter) + Integer.toString(this.tagNumber) + tagEnding);
        }
        return new StringBuffer(returnTag + "f" + Integer.toString(this.tagNumber) + tagEnding);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inProperty || this.inSegment) {
            if (this.currentElement.peek().equals(TMX_TAG_INLINE)) {
                if (!this.isOmegaT) {
                    if (Preferences.isPreference("ext_tmx_show_level2")) {
                        if (!this.insideTag) {
                            this.insideTag = true;
                            this.currentTag.setLength(0);
                        }
                        this.currentTag.append(ch, start, length);
                    }
                } else {
                    this.currentSub.peek().append(ch, start, length);
                }
            } else {
                if (this.insideTag && !this.isOmegaT) {
                    this.insideTag = false;
                    if (this.currentTag.length() > 0) {
                        this.currentTag = this.makeShortcut(this.currentTag);
                        this.currentSub.peek().append(this.currentTag);
                    }
                }
                this.currentSub.peek().append(ch, start, length);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.inProperty || this.inSegment && (this.includeLevel2 && this.currentElement.peek().equals(TMX_TAG_INLINE) || !this.currentElement.peek().equals(TMX_TAG_INLINE))) {
            this.currentSub.peek().append(ch, start, length);
        }
    }

    private void startElementHeader(Attributes attributes) {
        this.inHeader = true;
        this.creationtool = attributes.getValue(TMX_ATTR_CREATIONTOOL);
        this.creationtoolversion = attributes.getValue(TMX_ATTR_CREATIONTOOLVERSION);
        this.segtype = attributes.getValue(TMX_ATTR_SEGTYPE);
        this.tmxSourceLanguage = attributes.getValue(TMX_ATTR_SRCLANG);
        Log.logRB("TMXR_INFO_CREATION_TOOL", this.creationtool);
        Log.logRB("TMXR_INFO_CREATION_TOOL_VERSION", this.creationtoolversion);
        Log.logRB("TMXR_INFO_SEG_TYPE", this.segtype);
        Log.logRB("TMXR_INFO_SOURCE_LANG", this.tmxSourceLanguage);
        if (!this.tmxSourceLanguage.equalsIgnoreCase(this.sourceLanguage)) {
            Log.logWarningRB("TMXR_WARNING_INCORRECT_SOURCE_LANG", this.tmxSourceLanguage, this.sourceLanguage);
        }
        if (this.isUpgrade14X()) {
            Log.logWarningRB("TMXR_WARNING_UPGRADE_14X", new Object[0]);
        }
        if (this.isUpgradeSentSeg()) {
            Log.logWarningRB("TMXR_WARNING_UPGRADE_SENTSEG", new Object[0]);
        }
        this.checkLevel2();
    }

    private void endElementHeader() {
        this.headerParsed = true;
        this.inHeader = false;
        String propVariantLanguages = this.getProperty(PROPERTY_VARIANT_LANGUAGES);
        if (propVariantLanguages != null) {
            int commaPos = 0;
            StringBuffer languages = new StringBuffer();
            do {
                String language;
                String string = language = (commaPos = propVariantLanguages.indexOf(44)) > 0 ? propVariantLanguages.substring(0, commaPos).trim() : propVariantLanguages.trim();
                if (!language.isEmpty()) {
                    this.m_variantLanguages.add(language.substring(0, 2).toUpperCase(Locale.ENGLISH));
                    if (languages.length() > 0) {
                        languages.append(", ");
                    }
                    languages.append(language.substring(0, 2).toUpperCase(Locale.ENGLISH));
                }
                propVariantLanguages = propVariantLanguages.substring(commaPos + 1);
            } while (commaPos > 0);
            Log.logRB("TMXR_INFO_VARIANT_LANGUAGES_DISPLAYED", languages.toString());
        }
    }

    private void startElementProperty(Attributes attributes) throws SAXException {
        this.currentElement.push(TMX_TAG_PROP);
        if (!this.inHeader) {
            return;
        }
        this.currentProperty = attributes.getValue(TMX_ATTR_TYPE);
        this.currentSub.push(new StringBuffer());
        this.inProperty = true;
    }

    private void endElementProperty() {
        this.currentElement.pop();
        this.inProperty = false;
        if (!this.inHeader) {
            return;
        }
        StringBuffer propertyValue = this.currentSub.pop();
        this.m_properties.put(this.currentProperty, propertyValue.toString());
        this.currentProperty = null;
    }

    private void startElementTU(Attributes attributes) throws SAXException {
        this.currentElement.push(TMX_TAG_TU);
        if (!this.headerParsed) {
            throw new SAXException(OStrings.getString("TMXR_ERROR_TU_BEFORE_HEADER"));
        }
        this.inTU = true;
        this.tuvs.clear();
    }

    private void endElementTU() {
        long changeDate;
        String changeId;
        TUV target;
        TUV source;
        block31: {
            this.currentElement.pop();
            this.inTU = false;
            source = null;
            target = null;
            TUV sourceC = null;
            TUV targetC = null;
            TUV sourceT = null;
            TUV sourceTC = null;
            TUV targetT = null;
            for (TUV tuv : this.tuvs) {
                if (source == null && tuv.language.equalsIgnoreCase(this.sourceLanguage)) {
                    source = tuv;
                } else if (target == null && tuv.language.equalsIgnoreCase(this.targetLanguage)) {
                    target = tuv;
                } else if (sourceC == null && tuv.language.regionMatches(true, 0, this.sourceLanguage, 0, 2)) {
                    sourceC = tuv;
                } else if (targetC == null && tuv.language.regionMatches(true, 0, this.targetLanguage, 0, 2)) {
                    targetC = tuv;
                } else if (this.isProjectTMX) {
                    if (sourceT == null && (tuv.language.equalsIgnoreCase(this.tmxSourceLanguage) || this.tmxSourceLanguage.equalsIgnoreCase("*all*"))) {
                        sourceT = tuv;
                    } else if (sourceTC == null && tuv.language.regionMatches(true, 0, this.tmxSourceLanguage, 0, 2)) {
                        sourceTC = tuv;
                    }
                    if (targetT == null && !tuv.language.equalsIgnoreCase(this.tmxSourceLanguage)) {
                        targetT = tuv;
                    }
                }
                if (source == null || target == null) continue;
                break;
            }
            if (source == null) {
                source = sourceC;
            }
            if (source == null) {
                source = sourceT;
            }
            if (source == null) {
                source = sourceTC;
            }
            if (source == null) {
                this.sourceNotFound = true;
                return;
            }
            if (target == null) {
                target = targetC;
            }
            if (target == null) {
                target = targetT;
            }
            if (target == null) {
                target = new TUV();
            }
            if ((changeId = target.changeId) == null) {
                changeId = target.creationId;
            }
            changeDate = 0L;
            if (target.changeDate != null) {
                try {
                    changeDate = this.dateParser.parse(target.changeDate).getTime();
                }
                catch (ParseException e) {
                    if (target.creationDate == null) break block31;
                    try {
                        changeDate = this.dateParser.parse(target.creationDate).getTime();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
        this.storeSegment(source.text.toString(), target.text.toString(), changeId, changeDate);
        for (int i = 0; i < source.subSegments.size(); ++i) {
            String starget = "";
            if (i < target.subSegments.size()) {
                starget = target.subSegments.get(i).toString();
            }
            this.storeSegment(source.subSegments.get(i).toString(), starget, changeId, changeDate);
        }
        if (!this.isProjectTMX) {
            for (TUV tuv : this.tuvs) {
                if (tuv == source || tuv == target || !this.m_variantLanguages.isEmpty() && !this.m_variantLanguages.contains(tuv.language.substring(0, 2).toUpperCase(Locale.ENGLISH))) continue;
                this.storeSegment(source.text.toString(), tuv.text.toString(), changeId, changeDate);
            }
        }
    }

    private void startElementTUV(Attributes attributes) {
        this.currentElement.push(TMX_TAG_TUV);
        if (!this.inTU) {
            Log.logWarningRB("TMXR_WARNING_TUV_NOT_IN_TU", new Object[0]);
            return;
        }
        String language = attributes.getValue(TMX_ATTR_LANG_NS);
        if (language == null) {
            language = attributes.getValue(TMX_ATTR_LANG);
        }
        if (language == null) {
            Log.logWarningRB("TMXR_WARNING_TUV_LANG_NOT_SPECIFIED", new Object[0]);
            return;
        }
        TUV tuv = new TUV();
        tuv.language = language;
        tuv.changeDate = attributes.getValue(TMX_ATTR_CHANGEDATE);
        tuv.changeId = attributes.getValue(TMX_ATTR_CHANGEID);
        tuv.creationDate = attributes.getValue(TMX_ATTR_CREATIONDATE);
        tuv.creationId = attributes.getValue(TMX_ATTR_CREATIONID);
        this.tuvs.add(tuv);
        this.inTUV = true;
        this.currentSub.clear();
        this.currentTag.setLength(0);
        this.tagNumber = -1;
    }

    private void endElementTUV() {
        this.currentElement.pop();
        this.inTUV = false;
    }

    private void startElementSegment(Attributes attributes) {
        this.currentElement.push(TMX_TAG_SEG);
        if (!this.inTUV) {
            Log.logWarningRB("TMXR_WARNING_SEG_NOT_IN_TUV", new Object[0]);
            return;
        }
        this.currentSub.push(this.tuvs.get((int)(this.tuvs.size() - 1)).text);
        this.inSegment = true;
    }

    private void endElementSegment() {
        this.currentElement.pop();
        if (!this.inTUV) {
            return;
        }
        this.currentSub.pop();
        this.inSegment = false;
    }

    private void startElementInline(Attributes attributes) {
        this.currentElement.push(TMX_TAG_INLINE);
    }

    private void endElementInline() {
        this.currentElement.pop();
    }

    private void startElementSub(Attributes attributes) {
        this.currentElement.push(TMX_TAG_SUB);
        StringBuffer sub = new StringBuffer();
        this.tuvs.get((int)(this.tuvs.size() - 1)).subSegments.add(sub);
        this.currentSub.push(sub);
    }

    private void endElementSub() throws SAXException {
        this.currentElement.pop();
        this.currentSub.pop();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    private static class TUV {
        public String language;
        public StringBuffer text = new StringBuffer();
        public String changeDate;
        public String changeId;
        public String creationDate;
        public String creationId;
        public ArrayList<StringBuffer> subSegments = new ArrayList();
    }

    static class Tag {
        public boolean end;
        public String name;
        public int num;
        public boolean alone;

        public Tag(boolean end, String name, int num, boolean alone) {
            this.end = end;
            this.name = name;
            this.num = num;
            this.alone = alone;
        }

        public String toString() {
            return "<" + (this.end ? "/" : "") + this.name + this.num + (this.alone ? "/" : "") + ">";
        }

        public String toStringPaired() {
            if (this.alone) {
                return this.toString();
            }
            return "<" + (this.end ? "" : "/") + this.name + this.num + ">";
        }
    }
}

