/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

class KoreanTokenizerImpl {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0000\u0001\u0010\u0001\u0000\u0001\u0000\u0001\u000f\u0012\u0000\u0001\u0000\u0005\u0000\u0001\u0003\u0001\u0001\u0004\u0000\u0001\u0007\u0001\u0005\u0001\u0002\u0001\u0007\n\t\u0006\u0000\u0001\u0004\u001a\b\u0004\u0000\u0001\u0006\u0001\u0000\u001a\bE\u0000\u0017\b\u0001\u0000\u001f\b\u0001\u0000\u0568\b\n\n\u0086\b\n\n\u026c\b\n\nv\b\n\nv\b\n\nv\b\n\nv\b\n\nw\b\t\nv\b\n\nv\b\n\nv\b\n\n\u00e0\b\n\nv\b\n\n\u0166\b\n\n\u00b6\b\u0100\f\u0e00\b\u1040\u0000\u0150\u000e`\u0000\u0010\u000e\u0100\u0000\u0080\u000e\u0080\u0000\u19c0\r@\u0000\u5200\r\u0c00\u0000\u2bb0\u000b\u2150\u0000\u0200\r\u0465\u0000;\u000e=\b#\u0000";
    private static final char[] ZZ_CMAP = KoreanTokenizerImpl.zzUnpackCMap("\t\u0000\u0001\u0000\u0001\u0010\u0001\u0000\u0001\u0000\u0001\u000f\u0012\u0000\u0001\u0000\u0005\u0000\u0001\u0003\u0001\u0001\u0004\u0000\u0001\u0007\u0001\u0005\u0001\u0002\u0001\u0007\n\t\u0006\u0000\u0001\u0004\u001a\b\u0004\u0000\u0001\u0006\u0001\u0000\u001a\bE\u0000\u0017\b\u0001\u0000\u001f\b\u0001\u0000\u0568\b\n\n\u0086\b\n\n\u026c\b\n\nv\b\n\nv\b\n\nv\b\n\nv\b\n\nw\b\t\nv\b\n\nv\b\n\nv\b\n\n\u00e0\b\n\nv\b\n\n\u0166\b\n\n\u00b6\b\u0100\f\u0e00\b\u1040\u0000\u0150\u000e`\u0000\u0010\u000e\u0100\u0000\u0080\u000e\u0080\u0000\u19c0\r@\u0000\u5200\r\u0c00\u0000\u2bb0\u000b\u2150\u0000\u0200\r\u0465\u0000;\u000e=\b#\u0000");
    private static final int[] ZZ_ACTION = KoreanTokenizerImpl.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0002\u0001\u0003\u0002\u0002\u0003\u0001\u0004\u0001\u0005\u0001\u0001\u0001\u0006\u0006\u0000\u0003\u0002\u0001\u0003\u0001\u0006\u0003\u0000\u0001\u0002\u0001\u0003\u0001\u0006\u0001\u0002\u0004\u0003\u0001\u0004\u0003\u0000\u0001\u0003\u0001\u0007\u0003\b\u0002\t\u0002\u0000\u0002\u0006\u0002\u0000\u0002\b\u0001\u0003\u0004\u0006\u0001\u0000\u0002\b\u0001\u0003\u0004\u0000\u0002\u0003\u0001\n\u0001\u0000\u0001\b\u0001\u000b\u0002\u0000\u0002\b\u0001\u0003\u0001\n\u0001\u0000\u0002\u0006\u0001\u0003\u0002\u0006\u0001\u0003\u0002\u000b\u0001\b\u0002\u0003\u0001\u0006\u0002\u0003\u0001\u0006\u0002\u0003\u0002\n\u0001\u0000\u0002\b\u0001\u0000\u0001\u000b\u0001\b\u0002\u0006\u0001\u000b\u0002\u0000\u0001\u000b\u0001\u0003\u0001\b\u0001\f\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u000b\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\b\u0001\u0003\u0001\u0006\u0001\u0003\u0001\u0006\u0001\u0003\u0001\b\u0002\u0006\u0001\u000b\u0002\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u000b\u0001\b\u0001\u0003\u0002\u0000\u0002\u0003\u0001\u000b\u0001\u0000\u0002\b\u0002\u0000\u0001\u000b\u0001\u0000\u0002\b\u0001\u0003\u0002\u0000\u0001\u0003\u0001\b\u0001\u0000\u0001\u000b\u0001\u0000\u0001\u000b\u0001\u0003\u0001\u0000\u0003\u0003";
    private static final int[] ZZ_ROWMAP = KoreanTokenizerImpl.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0011\u0000\"\u00003\u0000D\u0000U\u0000f\u0000w\u0000\u0088\u0000\u0099\u0000\u00aa\u0000\u00bb\u0000\u00cc\u0000\u00dd\u0000\u00ee\u0000\u00ff\u0000\u0110\u0000\u0121\u0000\u0132\u0000\u0143\u0000\u0154\u0000\u0165\u0000\u0176\u0000\u0187\u0000\u0198\u0000\u01a9\u0000\u01ba\u0000\u01cb\u0000\u01dc\u0000\u01ed\u0000\u01fe\u0000\u020f\u0000\u0220\u0000\u0231\u0000\u0242\u0000\u0253\u0000\u0264\u0000\u0275\u0000\u0286\u0000\u0297\u0000\u02a8\u0000\u02b9\u0000\u02ca\u0000\u00ee\u0000\u02db\u0000\u02ec\u0000\u02fd\u0000\u030e\u0000\u031f\u0000\u0330\u0000\u0176\u0000\u0341\u0000\u0352\u0000\u0363\u0000\u0374\u0000\u0385\u0000\u0396\u0000\u03a7\u0000\u03b8\u0000\u03c9\u0000\u03da\u0000\u03eb\u0000\u00bb\u0000\u03fc\u0000\u040d\u0000\u041e\u0000\u042f\u0000\u0440\u0000\u0451\u0000\u0462\u0000\u0473\u0000\u0484\u0000\u0495\u0000\u04a6\u0000\u04b7\u0000\u04c8\u0000\u04d9\u0000\u04ea\u0000\u04fb\u0000\u050c\u0000\u051d\u0000\u052e\u0000\u053f\u0000\u0550\u0000\u0561\u0000\u0330\u0000\u0176\u0000\u0572\u0000\u0583\u0000\u0594\u0000\u05a5\u0000\u05b6\u0000\u05c7\u0000\u05d8\u0000\u05e9\u0000\u05fa\u0000\u00dd\u0000\u01dc\u0000\u060b\u0000\u061c\u0000\u062d\u0000\u063e\u0000\u064f\u0000\u0660\u0000\u0671\u0000\u0682\u0000\u0693\u0000\u06a4\u0000\u06b5\u0000\u06c6\u0000\u06d7\u0000\u06e8\u0000\u06f9\u0000\u070a\u0000\u071b\u0000\u072c\u0000\u073d\u0000\u03b8\u0000\u074e\u0000\u075f\u0000\u0770\u0000\u0781\u0000\u0792\u0000\u07a3\u0000\u07b4\u0000\u07c5\u0000\u07d6\u0000\u07e7\u0000\u07f8\u0000\u0809\u0000\u081a\u0000\u082b\u0000\u083c\u0000\u084d\u0000\u085e\u0000\u086f\u0000\u0880\u0000\u0891\u0000\u08a2\u0000\u08b3\u0000\u08c4\u0000\u08d5\u0000\u08e6\u0000\u08f7\u0000\u0908\u0000\u0919\u0000\u092a\u0000\u093b\u0000\u094c\u0000\u095d\u0000\u096e\u0000\u097f\u0000\u0990\u0000\u09a1\u0000\u09b2\u0000\u09c3\u0000\u09d4\u0000\u09e5\u0000\u09f6\u0000\u0a07\u0000\u0a18\u0000\u0a29\u0000\u0a3a\u0000\u0a4b\u0000\u0a5c\u0000\u0a6d\u0000\u0a7e\u0000\u0a8f\u0000\u0aa0\u0000\u0ab1\u0000\u0ac2\u0000\u0ad3\u0000\u0ae4\u0000\u0af5";
    private static final int[] ZZ_TRANS = KoreanTokenizerImpl.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0002\u0002\u0001\u0003\u0005\u0002\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\u0002\u001a\u0000\u0002\f\u0007\u0000\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0002\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0007\u0001\u0016\u0006\u0000\u0001\u0017\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001\u001b\u0002\u0014\u0001\u0007\u0001\u001c\u0005\u0000\u0001\r\u0001\u001d\u0001\u000f\u0001\u0010\u0002\u0019\u0001\u001a\u0001\u001e\u0001\u0014\u0001\u0015\u0001\u0007\u0001\u001f\f\u0000\u0003 \u0002\u0007\u0005\u0000\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0002\u0011\u0001\u0012\u0001\u0016\u0001!\u0001\"\u0001\u0007\u0001\u0016\f\u0000\u0003#\u0001\u0000\u0001#\u0001\t\u0011\u0000\u0001\n\u0012\u0000\u0001\u0002\u0002\u0000\u0001$\u0005\u0000\u0001%\u0002&\u0001\u0007\u0001'\f\u0000\u0001(\u0001\u0000\u0001(\u0001\u0000\u0001(\f\u0000\u0001)\u0001*\u0001+\u0001\u0000\u0001)\f\u0000\u0001,\u0001\u0000\u0001,\u0001\u0000\u0001,\f\u0000\u0001-\u0001.\u0001-\u0001\u0000\u0001-\f\u0000\u0001/\u00020\u0001\u0000\u0001/\f\u0000\u0001\u0012\u00021\u0001\u0000\u0001\u0012\u0005\u0000\u0001\r\u00012\u0001\u000f\u0001\u0010\u0002\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0007\u0001\u0016\u0006\u0000\u00013\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001\u001b\u0002\u0014\u0001\u0007\u0001\u001c\u0005\u0000\u0001\r\u00013\u0001\u000f\u0001\u0010\u0002\u0019\u0001\u001a\u0001\u001e\u0001\u0014\u0001\u0015\u0001\u0007\u0001\u001f\u0005\u0000\u0001\r\u00012\u0001\u000f\u0001\u0010\u0002\u0011\u0001\u0012\u0001\u0016\u0001!\u0001\"\u0001\u0007\u0001\u0016\u0006\u0000\u0001$\u0005\u0000\u00014\u00025\u0001\u0007\u00016\f\u0000\u0003.\u0001\u0000\u0001.\f\u0000\u00017\u00028\u0001\u0000\u00017\f\u0000\u00019\u0002:\u0001\u0000\u00019\u0006\u0000\u0001;\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001\u001b\u0002\u0014\u0001\u0007\u0001\u001c\u0006\u0000\u0001;\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001\u001c\u0002!\u0001\u0007\u0001\u001c\u0006\u0000\u0001$\u0005\u0000\u0001<\u00015\u0001=\u0001\u0007\u0001>\u0005\u0000\u0001\r\u0001;\u0001\u000f\u0001\u0010\u0002\u0019\u0001\u001a\u0001\u001e\u0001\u0014\u0001\u0015\u0001\u0007\u0001\u001f\u0005\u0000\u0001\r\u0001;\u0001\u000f\u0001\u0010\u0002\u0019\u0001\u001a\u0001\u001f\u0001!\u0001\"\u0001\u0007\u0001\u001f\f\u0000\u0003 \u0001\u0000\u0001 \u0006\u0000\u00013\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001\u001c\u0002!\u0001\u0007\u0001\u001c\u0005\u0000\u0001\r\u00013\u0001\u000f\u0001\u0010\u0002\u0019\u0001\u001a\u0001\u001f\u0001!\u0001\"\u0001\u0007\u0001\u001f\f\u0000\u0003#\u0001\u0000\u0001#\r\u0000\u0002?\b\u0000\u0001@\u0002\u0000\u0003@\u0001%\u0002&\u0001\u0007\u0001'\u0006\u0000\u0001?\u0002\u0000\u0003A\u0001B\u0002&\u0001\u0007\u0001C\u0006\u0000\u0001@\u0002\u0000\u0003@\u0001'\u0002D\u0001\u0007\u0001'\u0005\u0000\u0001\r\u0006\u0000\u0001(\u0001\u0000\u0001(\u0001\u0000\u0001(\u0006\u0000\u0001E\u0001\u0000\u0001\u0018\u0002F\u0001\u0000\u0001G\u0002*\u0001\u0000\u0001G\u0006\u0000\u0001H\u0001\u0000\u0001\u0018\u0002I\u0001J\u0001K\u0002L\u0001\u0007\u0001M\u0006\u0000\u0001N\u0001\u0000\u0001\u0018\u0002I\u0001J\u0001K\u0002L\u0001\u0007\u0001M\u0006\u0000\u0001O\u0002\u0000\u0001O\u0002\u0000\u0001-\u0001.\u0001-\u0001\u0000\u0001-\u0006\u0000\u0001O\u0002\u0000\u0001O\u0002\u0000\u0003.\u0001\u0000\u0001.\u0006\u0000\u0001F\u0001\u0000\u0001\u0018\u0002F\u0001\u0000\u0001/\u00020\u0001\u0000\u0001/\u0006\u0000\u0001I\u0001\u0000\u0001\u0018\u0002I\u0001J\u0001P\u0002Q\u0001\u0007\u0001R\u0006\u0000\u0001J\u0002\u0000\u0003J\u0001S\u0002T\u0001\u0007\u0001U\f\u0000\u0001G\u0002*\u0001\u0000\u0001G\u0006\u0000\u0001V\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u00014\u00025\u0001\u0007\u00016\u0006\u0000\u0001W\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001X\u00025\u0001\u0007\u0001Y\u0006\u0000\u0001V\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u00016\u0002Z\u0001\u0007\u00016\u0006\u0000\u0001\u0011\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u00017\u0002[\u0001\u0007\u0001\\\u0006\u0000\u0001\u0019\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u00018\u0002[\u0001\u0007\u0001]\u0006\u0000\u0001\u0012\u0002\u0000\u0003\u0012\u00019\u0002^\u0001\u0007\u0001_\u0006\u0000\u0001\u001a\u0002\u0000\u0003\u001a\u0001:\u0002^\u0001\u0007\u0001`\f\u0000\u00014\u0002X\u0001\u0000\u00014\u0006\u0000\u0001a\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u00014\u00025\u0001\u0007\u00016\u0006\u0000\u0001b\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001X\u00025\u0001\u0007\u0001Y\u0006\u0000\u0001a\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u00016\u0002Z\u0001\u0007\u00016\f\u0000\u0001@\u0002c\u0001\u0000\u0001@\f\u0000\u0001%\u0002B\u0001\u0000\u0001%\u0006\u0000\u0001A\u0002\u0000\u0003A\u0001B\u0002&\u0001\u0007\u0001C\u0006\u0000\u0001A\u0002\u0000\u0003A\u0001C\u0002D\u0001\u0007\u0001C\u0006\u0000\u0001?\u0002\u0000\u0003A\u0001C\u0002D\u0001\u0007\u0001C\f\u0000\u0001d\u0001e\u0001d\u0001\u0000\u0001d\f\u0000\u0003f\u0001\u0000\u0001f\u0006\u0000\u0001g\u0001\u0000\u0001\u0018\u0002F\u0001\u0000\u0001G\u0002*\u0001\u0000\u0001G\f\u0000\u0003h\u0001\u0000\u0001h\f\u0000\u0003i\u0001\u0000\u0001i\f\u0000\u0003j\u0001\u0000\u0001j\u0006\u0000\u0001k\u0001\u0000\u0001\u0018\u0002l\u0001m\u0001K\u0002L\u0001\u0007\u0001M\u0006\u0000\u0001n\u0001\u0000\u0001\u0018\u0002l\u0001m\u0001K\u0002L\u0001\u0007\u0001M\u0006\u0000\u0001k\u0001\u0000\u0001\u0018\u0002l\u0001m\u0001M\u0002o\u0001\u0007\u0001M\f\u0000\u0001p\u0001h\u0001p\u0001\u0000\u0001p\f\u0000\u0003q\u0001\u0000\u0001q\u0006\u0000\u0001l\u0001\u0000\u0001\u0018\u0002l\u0001m\u0001P\u0002Q\u0001\u0007\u0001R\u0006\u0000\u0001r\u0001\u0000\u0001\u0018\u0002l\u0001m\u0001P\u0002Q\u0001\u0007\u0001R\u0006\u0000\u0001l\u0001\u0000\u0001\u0018\u0002l\u0001m\u0001R\u0002s\u0001\u0007\u0001R\u0006\u0000\u0001m\u0002\u0000\u0003m\u0001S\u0002T\u0001\u0007\u0001U\u0006\u0000\u0001t\u0002\u0000\u0003m\u0001S\u0002T\u0001\u0007\u0001U\u0006\u0000\u0001m\u0002\u0000\u0003m\u0001U\u0002u\u0001\u0007\u0001U\u0006\u0000\u0001v\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001X\u00025\u0001\u0007\u0001Y\u0006\u0000\u0001v\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001Y\u0002Z\u0001\u0007\u0001Y\u0006\u0000\u0001W\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001Y\u0002Z\u0001\u0007\u0001Y\u0006\u0000\u0001w\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u00018\u0002[\u0001\u0007\u0001]\u0006\u0000\u0001\u0011\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u0001\\\u0002x\u0001\u0007\u0001\\\u0006\u0000\u0001\u0019\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001]\u0002x\u0001\u0007\u0001]\u0006\u0000\u0001y\u0002\u0000\u0003\u001a\u0001:\u0002^\u0001\u0007\u0001`\u0006\u0000\u0001\u0012\u0002\u0000\u0003\u0012\u0001_\u0002z\u0001\u0007\u0001_\u0006\u0000\u0001\u001a\u0002\u0000\u0003\u001a\u0001`\u0002z\u0001\u0007\u0001`\u0006\u0000\u0001{\u0002\u0000\u0003{\u0001B\u0002&\u0001\u0007\u0001C\u0006\u0000\u0001E\u0001\u0000\u0001\u0018\u0002F\u0001\u0000\u0003e\u0001\u0000\u0001e\u0006\u0000\u0001g\u0001\u0000\u0001\u0018\u0002F\u0001\u0000\u0003e\u0001\u0000\u0001e\u0006\u0000\u0001F\u0001\u0000\u0001\u0018\u0002F\u0001\u0000\u0003f\u0001\u0000\u0001f\f\u0000\u0003e\u0001\u0000\u0001e\u0006\u0000\u0001V\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u0001h\u0002|\u0001\u0007\u0001}\u0006\u0000\u0001\u0011\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u0001i\u0002~\u0001\u0007\u0001\u007f\u0006\u0000\u0001\u0012\u0002\u0000\u0003\u0012\u0001j\u0002\u0080\u0001\u0007\u0001\u0081\f\u0000\u0001h\u0002\u0082\u0001\u0000\u0001h\f\u0000\u0001i\u0002\u0083\u0001\u0000\u0001i\f\u0000\u0001j\u0002\u0084\u0001\u0000\u0001j\u0006\u0000\u0001$\u0005\u0000\u0001h\u0002|\u0001\u0007\u0001}\u0006\u0000\u0001n\u0001\u0000\u0001\u0018\u0002l\u0001m\u0001M\u0002o\u0001\u0007\u0001M\u0006\u0000\u0001a\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u0001h\u0002|\u0001\u0007\u0001}\u0006\u0000\u0001O\u0002\u0000\u0001O\u0002\u0000\u0003q\u0001\u0000\u0001q\u0006\u0000\u0001$\u0005\u0000\u0001i\u0002~\u0001\u0007\u0001\u007f\u0006\u0000\u0001r\u0001\u0000\u0001\u0018\u0002l\u0001m\u0001R\u0002s\u0001\u0007\u0001R\u0006\u0000\u0001$\u0005\u0000\u0001j\u0002\u0080\u0001\u0007\u0001\u0081\u0006\u0000\u0001t\u0002\u0000\u0003m\u0001U\u0002u\u0001\u0007\u0001U\u0006\u0000\u0001$\u0005\u0000\u00017\u0002[\u0001\u0007\u0001\\\u0006\u0000\u0001w\u0001\u0000\u0001\u0018\u0002\u0019\u0001\u001a\u0001]\u0002x\u0001\u0007\u0001]\u0006\u0000\u0001$\u0005\u0000\u00019\u0002^\u0001\u0007\u0001_\u0006\u0000\u0001y\u0002\u0000\u0003\u001a\u0001`\u0002z\u0001\u0007\u0001`\f\u0000\u0003%\u0001\u0000\u0001%\u0006\u0000\u0001\u0085\u0001\u0000\u0001\u0018\u0002\u0086\u0001\u0087\u0001\u0082\u0002|\u0001\u0007\u0001\u0088\u0006\u0000\u0001V\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u0001}\u0002\u0089\u0001\u0007\u0001}\u0006\u0000\u0001\u008a\u0001\u0000\u0001\u0018\u0002\u0086\u0001\u0087\u0001\u0083\u0002~\u0001\u0007\u0001\u008b\u0006\u0000\u0001\u0011\u0001\u0000\u0001\u0018\u0002\u0011\u0001\u0012\u0001\u007f\u0002\u008c\u0001\u0007\u0001\u007f\u0006\u0000\u0001\u008d\u0002\u0000\u0003\u0087\u0001\u0084\u0002\u0080\u0001\u0007\u0001\u008e\u0006\u0000\u0001\u0012\u0002\u0000\u0003\u0012\u0001\u0081\u0002\u008f\u0001\u0007\u0001\u0081\u0006\u0000\u0001\u0090\u0001\u0000\u0001\u0018\u0002\u0086\u0001\u0087\u0001\u0082\u0002|\u0001\u0007\u0001\u0088\u0006\u0000\u0001\u0086\u0001\u0000\u0001\u0018\u0002\u0086\u0001\u0087\u0001\u0083\u0002~\u0001\u0007\u0001\u008b\u0006\u0000\u0001\u0087\u0002\u0000\u0003\u0087\u0001\u0084\u0002\u0080\u0001\u0007\u0001\u008e\u0006\u0000\u0001$\u0005\u0000\u0001\u0091\u0002L\u0001\u0007\u0001\u0092\f\u0000\u0001\u0093\u0002P\u0001\u0000\u0001\u0093\f\u0000\u0001\u0094\u0002S\u0001\u0000\u0001\u0094\u0006\u0000\u0001\u0090\u0001\u0000\u0001\u0018\u0002\u0086\u0001\u0087\u0001\u0088\u0002\u0089\u0001\u0007\u0001\u0088\u0006\u0000\u0001\u0085\u0001\u0000\u0001\u0018\u0002\u0086\u0001\u0087\u0001\u0088\u0002\u0089\u0001\u0007\u0001\u0088\u0006\u0000\u0001$\u0005\u0000\u0001\u0093\u0002Q\u0001\u0007\u0001\u0095\u0006\u0000\u0001\u0086\u0001\u0000\u0001\u0018\u0002\u0086\u0001\u0087\u0001\u008b\u0002\u008c\u0001\u0007\u0001\u008b\u0006\u0000\u0001\u008a\u0001\u0000\u0001\u0018\u0002\u0086\u0001\u0087\u0001\u008b\u0002\u008c\u0001\u0007\u0001\u008b\u0006\u0000\u0001$\u0005\u0000\u0001\u0094\u0002T\u0001\u0007\u0001\u0096\u0006\u0000\u0001\u0087\u0002\u0000\u0003\u0087\u0001\u008e\u0002\u008f\u0001\u0007\u0001\u008e\u0006\u0000\u0001\u008d\u0002\u0000\u0003\u0087\u0001\u008e\u0002\u008f\u0001\u0007\u0001\u008e\f\u0000\u0001\u0091\u0002K\u0001\u0000\u0001\u0091\u0006\u0000\u0001\u0097\u0001\u0000\u0001\u0018\u0002\u0098\u0001@\u0001\u0091\u0002L\u0001\u0007\u0001\u0092\u0006\u0000\u0001\u0097\u0001\u0000\u0001\u0018\u0002\u0098\u0001@\u0001\u0092\u0002o\u0001\u0007\u0001\u0092\u0006\u0000\u0001\u0098\u0001\u0000\u0001\u0018\u0002\u0098\u0001@\u0001\u0093\u0002Q\u0001\u0007\u0001\u0095\u0006\u0000\u0001@\u0002\u0000\u0003@\u0001\u0094\u0002T\u0001\u0007\u0001\u0096\u0006\u0000\u0001\u0098\u0001\u0000\u0001\u0018\u0002\u0098\u0001@\u0001\u0095\u0002s\u0001\u0007\u0001\u0095\u0006\u0000\u0001@\u0002\u0000\u0003@\u0001\u0096\u0002u\u0001\u0007\u0001\u0096\f\u0000\u0001\u0099\u0002\u009a\u0001\u0000\u0001\u0099\f\u0000\u0001\u009b\u0002\u009c\u0001\u0000\u0001\u009b\u0006\u0000\u0001g\u0001\u0000\u0001\u0018\u0002F\u0001\u0000\u0001\u0099\u0002\u009a\u0001\u0000\u0001\u0099\u0006\u0000\u0001\u009d\u0001\u0000\u0001\u0018\u0002\u009e\u0001{\u0001\u009f\u0002\u00a0\u0001\u0007\u0001\u00a1\u0006\u0000\u0001F\u0001\u0000\u0001\u0018\u0002F\u0001\u0000\u0001\u009b\u0002\u009c\u0001\u0000\u0001\u009b\u0006\u0000\u0001\u009e\u0001\u0000\u0001\u0018\u0002\u009e\u0001{\u0001\u00a2\u0002\u00a3\u0001\u0007\u0001\u00a4\f\u0000\u0003\u00a5\u0001\u0000\u0001\u00a5\f\u0000\u0003\u00a6\u0001\u0000\u0001\u00a6\u0006\u0000\u0001\u00a7\u0001\u0000\u0001\u0018\u0002\u00a8\u0001A\u0001\u009f\u0002\u00a0\u0001\u0007\u0001\u00a1\u0006\u0000\u0001\u00a9\u0001\u0000\u0001\u0018\u0002\u00a8\u0001A\u0001\u009f\u0002\u00a0\u0001\u0007\u0001\u00a1\u0006\u0000\u0001\u00a7\u0001\u0000\u0001\u0018\u0002\u00a8\u0001A\u0001\u00a1\u0002\u00aa\u0001\u0007\u0001\u00a1\u0006\u0000\u0001\u00a8\u0001\u0000\u0001\u0018\u0002\u00a8\u0001A\u0001\u00a2\u0002\u00a3\u0001\u0007\u0001\u00a4\u0006\u0000\u0001\u00ab\u0001\u0000\u0001\u0018\u0002\u00a8\u0001A\u0001\u00a2\u0002\u00a3\u0001\u0007\u0001\u00a4\u0006\u0000\u0001\u00a8\u0001\u0000\u0001\u0018\u0002\u00a8\u0001A\u0001\u00a4\u0002\u00ac\u0001\u0007\u0001\u00a4\u0006\u0000\u0001\u0097\u0001\u0000\u0001\u0018\u0002\u0098\u0001@\u0001\u00a5\u0002\u00a0\u0001\u0007\u0001\u00ad\u0006\u0000\u0001\u0098\u0001\u0000\u0001\u0018\u0002\u0098\u0001@\u0001\u00a6\u0002\u00a3\u0001\u0007\u0001\u00ae\f\u0000\u0001\u00a5\u0002\u009f\u0001\u0000\u0001\u00a5\f\u0000\u0001\u00a6\u0002\u00a2\u0001\u0000\u0001\u00a6\u0006\u0000\u0001$\u0005\u0000\u0001\u00a5\u0002\u00a0\u0001\u0007\u0001\u00ad\u0006\u0000\u0001\u00a9\u0001\u0000\u0001\u0018\u0002\u00a8\u0001A\u0001\u00a1\u0002\u00aa\u0001\u0007\u0001\u00a1\u0006\u0000\u0001$\u0005\u0000\u0001\u00a6\u0002\u00a3\u0001\u0007\u0001\u00ae\u0006\u0000\u0001\u00ab\u0001\u0000\u0001\u0018\u0002\u00a8\u0001A\u0001\u00a4\u0002\u00ac\u0001\u0007\u0001\u00a4\u0006\u0000\u0001\u0097\u0001\u0000\u0001\u0018\u0002\u0098\u0001@\u0001\u00ad\u0002\u00aa\u0001\u0007\u0001\u00ad\u0006\u0000\u0001\u0098\u0001\u0000\u0001\u0018\u0002\u0098\u0001@\u0001\u00ae\u0002\u00ac\u0001\u0007\u0001\u00ae\u0004\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = KoreanTokenizerImpl.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\t\n\u0001\u0006\u0000\u0005\u0001\u0003\u0000\t\u0001\u0003\u0000\u0007\u0001\u0002\u0000\u0002\u0001\u0002\u0000\u0007\u0001\u0001\u0000\u0003\u0001\u0004\u0000\u0003\u0001\u0001\u0000\u0002\u0001\u0002\u0000\u0004\u0001\u0001\u0000\u0013\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0005\u0001\u0002\u0000\u0004\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\n\u0001\u0002\u0000\u0002\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0005\u0001\u0002\u0000\u0003\u0001\u0001\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0002\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0003\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    public static final int ALPHANUM = 0;
    public static final int APOSTROPHE = 1;
    public static final int ACRONYM = 2;
    public static final int COMPANY = 3;
    public static final int EMAIL = 4;
    public static final int HOST = 5;
    public static final int NUM = 6;
    public static final int CJ = 7;
    public static final int ACRONYM_DEP = 8;
    public static final int KOREAN = 9;
    public static final int CHINESE = 10;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<APOSTROPHE>", "<ACRONYM>", "<COMPANY>", "<EMAIL>", "<HOST>", "<NUM>", "<CJ>", "<ACRONYM_DEP>", "<KOREAN>", "<CHINESE>"};

    private static int[] zzUnpackAction() {
        int[] result = new int[174];
        int offset = 0;
        offset = KoreanTokenizerImpl.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[174];
        int offset = 0;
        offset = KoreanTokenizerImpl.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[2822];
        int offset = 0;
        offset = KoreanTokenizerImpl.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[174];
        int offset = 0;
        offset = KoreanTokenizerImpl.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public final int yychar() {
        return this.yychar;
    }

    final void getText(CharTermAttribute t) {
        t.copyBuffer(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    KoreanTokenizerImpl(Reader in) {
        this.zzReader = in;
    }

    KoreanTokenizerImpl(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 156) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public int getNextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block25: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 8: {
                    return 5;
                }
                case 13: {
                    continue block25;
                }
                case 11: {
                    return 8;
                }
                case 14: {
                    continue block25;
                }
                case 10: {
                    return 2;
                }
                case 15: {
                    continue block25;
                }
                case 1: 
                case 16: {
                    continue block25;
                }
                case 6: {
                    return 6;
                }
                case 17: {
                    continue block25;
                }
                case 5: {
                    return 7;
                }
                case 18: {
                    continue block25;
                }
                case 2: {
                    return 0;
                }
                case 19: {
                    continue block25;
                }
                case 9: {
                    return 3;
                }
                case 20: {
                    continue block25;
                }
                case 7: {
                    return 1;
                }
                case 21: {
                    continue block25;
                }
                case 4: {
                    return 10;
                }
                case 22: {
                    continue block25;
                }
                case 3: {
                    return 9;
                }
                case 23: {
                    continue block25;
                }
                case 12: {
                    return 4;
                }
                case 24: {
                    continue block25;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            this.zzScanError(1);
        }
    }
}

