/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.lucene.analysis.kr.utils.StrBuilder;
import org.apache.lucene.analysis.kr.utils.UnhandledException;

public class StringEscapeUtil {
    public static String unescapeJava(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length());
            StringEscapeUtil.unescapeJava(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void unescapeJava(Writer out, String str) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        StrBuilder unicode = new StrBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() == 4) {
                    try {
                        int value = Integer.parseInt(unicode.toString(), 16);
                        out.write((char)value);
                        unicode.setLength(0);
                        inUnicode = false;
                        hadSlash = false;
                    }
                    catch (NumberFormatException nfe) {
                        throw new UnhandledException("Unable to parse unicode value: " + unicode, nfe);
                    }
                }
            } else if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        out.write(92);
                        break;
                    }
                    case '\'': {
                        out.write(39);
                        break;
                    }
                    case '\"': {
                        out.write(34);
                        break;
                    }
                    case 'r': {
                        out.write(13);
                        break;
                    }
                    case 'f': {
                        out.write(12);
                        break;
                    }
                    case 't': {
                        out.write(9);
                        break;
                    }
                    case 'n': {
                        out.write(10);
                        break;
                    }
                    case 'b': {
                        out.write(8);
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        out.write(ch);
                        break;
                    }
                }
            } else if (ch == '\\') {
                hadSlash = true;
            } else {
                out.write(ch);
            }
            ++i;
        }
        if (hadSlash) {
            out.write(92);
        }
    }
}

