/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import gen.core.segmentation.Languagemap;
import gen.core.segmentation.Languagerule;
import gen.core.segmentation.Srx;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.Rule;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class SRX
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2182125877925944613L;
    public static final String CONF_SENTSEG = "segmentation.conf";
    protected static final JAXBContext SRX_JAXB_CONTEXT;
    private static final String DEFAULT_RULES_PATTERN = ".*";
    private boolean segmentSubflows = true;
    private boolean includeStartingTags;
    private boolean includeEndingTags = true;
    private boolean includeIsolatedTags;
    private List<MapRule> mappingRules = new ArrayList<MapRule>();
    public static String INITIAL_VERSION;
    public static String OT160RC8_VERSION;
    public static String OT160RC9_VERSION;
    public static String CURRENT_VERSION;
    private String version;

    private void init() {
        this.mappingRules = new ArrayList<MapRule>();
        this.includeEndingTags = true;
        this.segmentSubflows = true;
        this.initDefaults();
    }

    public SRX clone() {
        SRX result = new SRX();
        result.mappingRules = new ArrayList<MapRule>(this.mappingRules.size());
        for (MapRule rule : this.mappingRules) {
            result.mappingRules.add(rule.clone());
        }
        return result;
    }

    public static void saveTo(SRX srx, File outFile) throws IOException {
        if (srx == null) {
            outFile.delete();
            return;
        }
        try {
            srx.setVersion(CURRENT_VERSION);
            XMLEncoder xmlenc = new XMLEncoder(new FileOutputStream(outFile));
            xmlenc.writeObject(srx);
            xmlenc.close();
        }
        catch (IOException ioe) {
            Log.logErrorRB("CORE_SRX_ERROR_SAVING_SEGMENTATION_CONFIG", new Object[0]);
            Log.log(ioe);
            throw ioe;
        }
    }

    public static SRX loadSRX(File configFile) {
        SRX res;
        if (!configFile.exists()) {
            return null;
        }
        try {
            MyExceptionListener myel = new MyExceptionListener();
            XMLDecoder xmldec = new XMLDecoder(new FileInputStream(configFile), null, myel);
            res = (SRX)xmldec.readObject();
            xmldec.close();
            if (myel.isExceptionOccured()) {
                StringBuilder sb = new StringBuilder();
                for (Exception ex : myel.getExceptionsList()) {
                    sb.append("    ");
                    sb.append(ex);
                    sb.append("\n");
                }
                Log.logErrorRB("CORE_SRX_EXC_LOADING_SEG_RULES", sb.toString());
                res = new SRX();
                res.initDefaults();
                return res;
            }
            if (CURRENT_VERSION.compareTo(res.getVersion()) > 0) {
                SRX defaults = new SRX();
                defaults.initDefaults();
                res = SRX.merge(res, defaults);
            }
        }
        catch (Exception e) {
            if (!(e instanceof FileNotFoundException)) {
                Log.log(e);
            }
            res = new SRX();
            res.initDefaults();
        }
        return res;
    }

    public static boolean projectConfigFileExists(String configDir) {
        File configFile = new File(configDir + CONF_SENTSEG);
        return configFile.exists();
    }

    private static SRX merge(SRX current, SRX defaults) {
        current = SRX.upgrade(current, defaults);
        int defaultMapRulesN = defaults.getMappingRules().size();
        for (int i = 0; i < defaultMapRulesN; ++i) {
            MapRule dmaprule = defaults.getMappingRules().get(i);
            String dcode = dmaprule.getLanguageCode();
            boolean found = false;
            int currentMapRulesN = current.getMappingRules().size();
            MapRule cmaprule = null;
            for (int j = 0; j < currentMapRulesN; ++j) {
                cmaprule = current.getMappingRules().get(j);
                String ccode = cmaprule.getLanguageCode();
                if (!dcode.equals(ccode)) continue;
                found = true;
                break;
            }
            if (found) {
                List<Rule> crules = cmaprule.getRules();
                List<Rule> drules = dmaprule.getRules();
                for (Rule drule : drules) {
                    int currentRulesN;
                    if (crules.contains(drule)) continue;
                    if (drule.isBreakRule()) {
                        crules.add(drule);
                        continue;
                    }
                    int firstBreakRuleN = currentRulesN = crules.size();
                    for (int k = 0; k < currentRulesN; ++k) {
                        Rule crule = crules.get(k);
                        if (!crule.isBreakRule()) continue;
                        firstBreakRuleN = k;
                        break;
                    }
                    crules.add(firstBreakRuleN, drule);
                }
                continue;
            }
            int englishN = currentMapRulesN;
            for (int j = 0; j < currentMapRulesN; ++j) {
                cmaprule = current.getMappingRules().get(j);
                String cpattern = cmaprule.getPattern();
                if (!DEFAULT_RULES_PATTERN.equals(cpattern)) continue;
                englishN = j;
                break;
            }
            current.getMappingRules().add(englishN, dmaprule);
        }
        return current;
    }

    private static SRX upgrade(SRX current, SRX defaults) {
        if (OT160RC9_VERSION.equals(CURRENT_VERSION)) {
            String DEF = "Default (English)";
            for (int i = 0; i < current.getMappingRules().size(); ++i) {
                MapRule maprule = current.getMappingRules().get(i);
                if (!DEF.equals(maprule.getLanguageCode())) continue;
                maprule.setLanguage("Default");
                maprule.getRules().removeAll(SRX.getRulesForLanguage(defaults, "English"));
                maprule.getRules().removeAll(SRX.getRulesForLanguage(defaults, "Text"));
                maprule.getRules().removeAll(SRX.getRulesForLanguage(defaults, "HTML"));
            }
        }
        return current;
    }

    private static List<Rule> getRulesForLanguage(SRX source, String langName) {
        for (MapRule mr : source.getMappingRules()) {
            if (!langName.equals(mr.getLanguageCode())) continue;
            return mr.getRules();
        }
        return null;
    }

    private void initDefaults() {
        try {
            ArrayList<MapRule> newMap = new ArrayList<MapRule>();
            URL rulesUrl = this.getClass().getResource("defaultRules.srx");
            Srx data = (Srx)SRX_JAXB_CONTEXT.createUnmarshaller().unmarshal(rulesUrl);
            for (Languagerule rules : data.getBody().getLanguagerules().getLanguagerule()) {
                String lang = rules.getLanguagerulename();
                String pattern = DEFAULT_RULES_PATTERN;
                for (Languagemap lm : data.getBody().getMaprules().getLanguagemap()) {
                    if (!lm.getLanguagerulename().equals(rules.getLanguagerulename())) continue;
                    pattern = lm.getLanguagepattern();
                    break;
                }
                ArrayList<Rule> rulesList = new ArrayList<Rule>(rules.getRule().size());
                for (gen.core.segmentation.Rule r : rules.getRule()) {
                    boolean isBreak = "yes".equalsIgnoreCase(r.getBreak());
                    rulesList.add(new Rule(isBreak, r.getBeforebreak().getContent(), r.getAfterbreak().getContent()));
                }
                newMap.add(new MapRule(lang, pattern, rulesList));
            }
            this.getMappingRules().addAll(newMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static SRX getDefault() {
        SRX srx = new SRX();
        srx.init();
        return srx;
    }

    public List<Rule> lookupRulesForLanguage(Language srclang) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (int i = 0; i < this.getMappingRules().size(); ++i) {
            MapRule maprule = this.getMappingRules().get(i);
            if (!maprule.getCompiledPattern().matcher(srclang.getLanguage()).matches()) continue;
            rules.addAll(maprule.getRules());
        }
        return rules;
    }

    public boolean isSegmentSubflows() {
        return this.segmentSubflows;
    }

    public void setSegmentSubflows(boolean segmentSubflows) {
        this.segmentSubflows = segmentSubflows;
    }

    public boolean isIncludeStartingTags() {
        return this.includeStartingTags;
    }

    public void setIncludeStartingTags(boolean includeStartingTags) {
        this.includeStartingTags = includeStartingTags;
    }

    public boolean isIncludeEndingTags() {
        return this.includeEndingTags;
    }

    public void setIncludeEndingTags(boolean includeEndingTags) {
        this.includeEndingTags = includeEndingTags;
    }

    public boolean isIncludeIsolatedTags() {
        return this.includeIsolatedTags;
    }

    public void setIncludeIsolatedTags(boolean includeIsolatedTags) {
        this.includeIsolatedTags = includeIsolatedTags;
    }

    public List<MapRule> getMappingRules() {
        return this.mappingRules;
    }

    public void setMappingRules(List<MapRule> rules) {
        this.mappingRules = rules;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    static {
        try {
            SRX_JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{Srx.class});
        }
        catch (LinkageError ex) {
            throw new ExceptionInInitializerError(OStrings.getString("STARTUP_JAXB_LINKAGE_ERROR"));
        }
        catch (JAXBException ex) {
            if (ex.getMessage() != null) {
                throw new ExceptionInInitializerError(ex.getMessage());
            }
            if (ex.getCause() != null) {
                throw new ExceptionInInitializerError(ex.getCause().getClass().getName() + ": " + ex.getCause().getMessage());
            }
            throw new ExceptionInInitializerError(((Object)((Object)ex)).getClass().getName());
        }
        INITIAL_VERSION = "0.2";
        OT160RC8_VERSION = "0.2.1";
        CURRENT_VERSION = OT160RC9_VERSION = "0.2.2";
    }

    static class MyExceptionListener
    implements ExceptionListener {
        private List<Exception> exceptionsList = new ArrayList<Exception>();
        private boolean exceptionOccured = false;

        MyExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            this.exceptionOccured = true;
            this.exceptionsList.add(e);
        }

        public boolean isExceptionOccured() {
            return this.exceptionOccured;
        }

        public List<Exception> getExceptionsList() {
            return this.exceptionsList;
        }
    }
}

