/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.visitors.NodeVisitor;
import org.omegat.core.Core;
import org.omegat.filters2.html2.HTMLFilter2;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.StringUtil;

public class FilterVisitor
extends NodeVisitor {
    protected HTMLFilter2 filter;
    private BufferedWriter writer;
    private HTMLOptions options;
    boolean recurse = true;
    boolean text = false;
    boolean preformatting = false;
    List<Node> befors;
    List<Node> translatable;
    List<Node> afters;
    List<Tag> s_tags;
    List<Integer> s_tag_numbers;
    List<String> s_shortcuts;
    int s_nshortcuts;
    boolean firstcall = true;
    private static final Object[][] ENTITIES = new Object[][]{{"quot", 34}, {"amp", 38}, {"lt", 60}, {"gt", 62}, {"OElig", 338}, {"oelig", 339}, {"Scaron", 352}, {"scaron", 353}, {"Yuml", 376}, {"circ", 710}, {"tilde", 732}, {"ensp", 8194}, {"emsp", 8195}, {"thinsp", 8201}, {"zwnj", 8204}, {"zwj", 8205}, {"lrm", 8206}, {"rlm", 8207}, {"ndash", 8211}, {"mdash", 8212}, {"lsquo", 8216}, {"rsquo", 8217}, {"sbquo", 8218}, {"ldquo", 8220}, {"rdquo", 8221}, {"bdquo", 8222}, {"dagger", 8224}, {"Dagger", 8225}, {"permil", 8240}, {"lsaquo", 8249}, {"rsaquo", 8250}, {"euro", 8364}, {"nbsp", 160}, {"iexcl", 161}, {"cent", 162}, {"pound", 163}, {"curren", 164}, {"yen", 165}, {"brvbar", 166}, {"sect", 167}, {"uml", 168}, {"copy", 169}, {"ordf", 170}, {"laquo", 171}, {"not", 172}, {"shy", 173}, {"reg", 174}, {"macr", 175}, {"deg", 176}, {"plusmn", 177}, {"sup2", 178}, {"sup3", 179}, {"acute", 180}, {"micro", 181}, {"para", 182}, {"middot", 183}, {"cedil", 184}, {"sup1", 185}, {"ordm", 186}, {"raquo", 187}, {"frac14", 188}, {"frac12", 189}, {"frac34", 190}, {"iquest", 191}, {"Agrave", 192}, {"Aacute", 193}, {"Acirc", 194}, {"Atilde", 195}, {"Auml", 196}, {"Aring", 197}, {"AElig", 198}, {"Ccedil", 199}, {"Egrave", 200}, {"Eacute", 201}, {"Ecirc", 202}, {"Euml", 203}, {"Igrave", 204}, {"Iacute", 205}, {"Icirc", 206}, {"Iuml", 207}, {"ETH", 208}, {"Ntilde", 209}, {"Ograve", 210}, {"Oacute", 211}, {"Ocirc", 212}, {"Otilde", 213}, {"Ouml", 214}, {"times", 215}, {"Oslash", 216}, {"Ugrave", 217}, {"Uacute", 218}, {"Ucirc", 219}, {"Uuml", 220}, {"Yacute", 221}, {"THORN", 222}, {"szlig", 223}, {"agrave", 224}, {"aacute", 225}, {"acirc", 226}, {"atilde", 227}, {"auml", 228}, {"aring", 229}, {"aelig", 230}, {"ccedil", 231}, {"egrave", 232}, {"eacute", 233}, {"ecirc", 234}, {"euml", 235}, {"igrave", 236}, {"iacute", 237}, {"icirc", 238}, {"iuml", 239}, {"eth", 240}, {"ntilde", 241}, {"ograve", 242}, {"oacute", 243}, {"ocirc", 244}, {"otilde", 245}, {"ouml", 246}, {"divide", 247}, {"oslash", 248}, {"ugrave", 249}, {"uacute", 250}, {"ucirc", 251}, {"uuml", 252}, {"yacute", 253}, {"thorn", 254}, {"yuml", 255}, {"fnof", 402}, {"Alpha", 913}, {"Beta", 914}, {"Gamma", 915}, {"Delta", 916}, {"Epsilon", 917}, {"Zeta", 918}, {"Eta", 919}, {"Theta", 920}, {"Iota", 921}, {"Kappa", 922}, {"Lambda", 923}, {"Mu", 924}, {"Nu", 925}, {"Xi", 926}, {"Omicron", 927}, {"Pi", 928}, {"Rho", 929}, {"Sigma", 931}, {"Tau", 932}, {"Upsilon", 933}, {"Phi", 934}, {"Chi", 935}, {"Psi", 936}, {"Omega", 937}, {"alpha", 945}, {"beta", 946}, {"gamma", 947}, {"delta", 948}, {"epsilon", 949}, {"zeta", 950}, {"eta", 951}, {"theta", 952}, {"iota", 953}, {"kappa", 954}, {"lambda", 955}, {"mu", 956}, {"nu", 957}, {"xi", 958}, {"omicron", 959}, {"pi", 960}, {"rho", 961}, {"sigmaf", 962}, {"sigma", 963}, {"tau", 964}, {"upsilon", 965}, {"phi", 966}, {"chi", 967}, {"psi", 968}, {"omega", 969}, {"thetasym", 977}, {"upsih", 978}, {"piv", 982}, {"bull", 8226}, {"hellip", 8230}, {"prime", 8242}, {"Prime", 8243}, {"oline", 8254}, {"frasl", 8260}, {"weierp", 8472}, {"image", 8465}, {"real", 8476}, {"trade", 8482}, {"alefsym", 8501}, {"larr", 8592}, {"uarr", 8593}, {"rarr", 8594}, {"darr", 8595}, {"harr", 8596}, {"crarr", 8629}, {"lArr", 8656}, {"uArr", 8657}, {"rArr", 8658}, {"dArr", 8659}, {"hArr", 8660}, {"forall", 8704}, {"part", 8706}, {"exist", 8707}, {"empty", 8709}, {"nabla", 8711}, {"isin", 8712}, {"notin", 8713}, {"ni", 8715}, {"prod", 8719}, {"sum", 8722}, {"minus", 8722}, {"lowast", 8727}, {"radic", 8730}, {"prop", 8733}, {"infin", 8734}, {"ang", 8736}, {"and", 8869}, {"or", 8870}, {"cap", 8745}, {"cup", 8746}, {"int", 8747}, {"there4", 8756}, {"sim", 8764}, {"cong", 8773}, {"asymp", 8773}, {"ne", 8800}, {"equiv", 8801}, {"le", 8804}, {"ge", 8805}, {"sub", 8834}, {"sup", 8835}, {"nsub", 8836}, {"sube", 8838}, {"supe", 8839}, {"oplus", 8853}, {"otimes", 8855}, {"perp", 8869}, {"sdot", 8901}, {"lceil", 8968}, {"rceil", 8969}, {"lfloor", 8970}, {"rfloor", 8971}, {"lang", 9001}, {"rang", 9002}, {"loz", 9674}, {"spades", 9824}, {"clubs", 9827}, {"hearts", 9829}, {"diams", 9830}};

    public FilterVisitor(HTMLFilter2 htmlfilter, BufferedWriter bufwriter, HTMLOptions options) {
        this.filter = htmlfilter;
        this.options = options != null ? options : new HTMLOptions(new TreeMap<String, String>());
        this.writer = bufwriter;
    }

    @Override
    public boolean shouldRecurseSelf() {
        return this.recurse;
    }

    @Override
    public boolean shouldRecurseChildren() {
        return this.recurse;
    }

    @Override
    public void visitTag(Tag tag) {
        Iterator i;
        Vector tagAttributes;
        boolean intactTag = this.isIntactTag(tag);
        if (!intactTag) {
            tagAttributes = tag.getAttributesEx();
            i = tagAttributes.iterator();
            while (i.hasNext() && !intactTag) {
                Attribute attribute = (Attribute)i.next();
                String name = attribute.getName();
                String value = attribute.getValue();
                if (name == null || value == null) continue;
                intactTag = this.filter.checkIgnoreTags(name, value);
            }
        }
        if (intactTag) {
            if (this.text) {
                this.endup();
            } else {
                this.flushbefors();
            }
            this.writeout(tag.toHtml());
            if (tag.getEndTag() != null) {
                this.recurse = false;
            }
        } else {
            if (this.isParagraphTag(tag) && this.text) {
                this.endup();
            }
            if (this.isPreformattingTag(tag) || Core.getFilterMaster().getConfig().isPreserveSpaces()) {
                this.preformatting = true;
            }
            this.maybeTranslateAttribute(tag, "abbr");
            this.maybeTranslateAttribute(tag, "alt");
            if (this.options.getTranslateHref()) {
                this.maybeTranslateAttribute(tag, "href");
            }
            if (this.options.getTranslateHreflang()) {
                this.maybeTranslateAttribute(tag, "hreflang");
            }
            if (this.options.getTranslateLang()) {
                this.maybeTranslateAttribute(tag, "lang");
                this.maybeTranslateAttribute(tag, "xml:lang");
            }
            this.maybeTranslateAttribute(tag, "label");
            if ("IMG".equals(tag.getTagName()) && this.options.getTranslateSrc()) {
                this.maybeTranslateAttribute(tag, "src");
            }
            this.maybeTranslateAttribute(tag, "summary");
            this.maybeTranslateAttribute(tag, "title");
            if ("INPUT".equals(tag.getTagName())) {
                if (this.options.getTranslateValue() || this.options.getTranslateButtonValue() && ("submit".equalsIgnoreCase(tag.getAttribute("type")) || "button".equalsIgnoreCase(tag.getAttribute("type")) || "reset".equalsIgnoreCase(tag.getAttribute("type")))) {
                    this.maybeTranslateAttribute(tag, "value");
                }
                this.maybeTranslateAttribute(tag, "placeholder");
            }
            if ("META".equals(tag.getTagName())) {
                tagAttributes = tag.getAttributesEx();
                i = tagAttributes.iterator();
                boolean doSkipMetaTag = false;
                while (i.hasNext() && !doSkipMetaTag) {
                    Attribute attribute = (Attribute)i.next();
                    String name = attribute.getName();
                    String value = attribute.getValue();
                    if (name == null || value == null) continue;
                    doSkipMetaTag = this.filter.checkDoSkipMetaTag(name, value);
                }
                if (!doSkipMetaTag) {
                    this.maybeTranslateAttribute(tag, "content");
                }
            }
            this.queuePrefix(tag);
        }
    }

    protected void maybeTranslateAttribute(Tag tag, String key) {
        String attr = tag.getAttribute(key);
        if (attr != null) {
            String comment = OStrings.getString("HTMLFILTER_TAG") + " " + tag.getTagName() + " " + OStrings.getString("HTMLFILTER_ATTRIBUTE") + " " + key;
            String trans = this.filter.privateProcessEntry(this.entitiesToChars(attr), comment);
            tag.setAttribute(key, this.charsToEntities(trans));
        }
    }

    @Override
    public void visitStringNode(Text string) {
        this.recurse = true;
        String trimmedtext = this.entitiesToChars(string.getText()).replace('\u00a0', ' ').trim();
        if (!trimmedtext.isEmpty()) {
            if (this.firstcall && PatternConsts.XML_HEADER.matcher(trimmedtext).matches()) {
                this.writeout(string.toHtml());
                return;
            }
            this.text = true;
            this.firstcall = false;
        }
        if (this.text) {
            this.queueTranslatable(string);
        } else {
            this.queuePrefix(string);
        }
    }

    @Override
    public void visitRemarkNode(Remark remark) {
        this.recurse = true;
        if (this.text) {
            this.endup();
        }
        if (!this.options.getRemoveComments()) {
            this.writeout(remark.toHtml());
        }
    }

    @Override
    public void visitEndTag(Tag tag) {
        this.recurse = true;
        if (this.isParagraphTag(tag) && this.text) {
            this.endup();
        }
        if (this.isPreformattingTag(tag)) {
            this.preformatting = false;
        }
        this.queuePrefix(tag);
    }

    @Override
    public void beginParsing() {
        this.cleanup();
    }

    @Override
    public void finishedParsing() {
        if (this.text) {
            this.endup();
        } else {
            this.flushbefors();
        }
    }

    private boolean isParagraphTag(Tag tag) {
        String tagname = tag.getTagName();
        return tagname.equals("ADDRESS") || tagname.equals("BLOCKQUOTE") || tagname.equals("BODY") || tagname.equals("CENTER") || tagname.equals("DIV") || tagname.equals("H1") || tagname.equals("H2") || tagname.equals("H3") || tagname.equals("H4") || tagname.equals("H5") || tagname.equals("H6") || tagname.equals("HTML") || tagname.equals("HEAD") || tagname.equals("TITLE") || tagname.equals("TABLE") || tagname.equals("TR") || tagname.equals("TD") || tagname.equals("TH") || tagname.equals("P") || tagname.equals("PRE") || tagname.equals("OL") || tagname.equals("UL") || tagname.equals("LI") || tagname.equals("DL") || tagname.equals("DT") || tagname.equals("DD") || tagname.equals("FORM") || tagname.equals("TEXTAREA") || tagname.equals("FIELDSET") || tagname.equals("LEGEND") || tagname.equals("LABEL") || tagname.equals("SELECT") || tagname.equals("OPTION") || tagname.equals("HR") || tagname.equals("BR") && this.options.getParagraphOnBr();
    }

    private boolean isIntactTag(Tag tag) {
        String tagname = tag.getTagName();
        return tagname.equals("!DOCTYPE") || tagname.equals("STYLE") || tagname.equals("SCRIPT") || tagname.equals("OBJECT") || tagname.equals("EMBED") || tagname.equals("META") && "content-type".equalsIgnoreCase(tag.getAttribute("http-equiv"));
    }

    private boolean isPreformattingTag(Tag tag) {
        String tagname = tag.getTagName();
        return tagname.equals("PRE") || tagname.equals("TEXTAREA");
    }

    private void writeout(String something) {
        try {
            this.writer.write(something);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    protected void endup() {
        String translation;
        int i;
        String uncompressed;
        Node node;
        int i2;
        ArrayList<Node> all = new ArrayList<Node>();
        all.addAll(this.befors);
        all.addAll(this.translatable);
        int firstgoodlimit = this.befors.size();
        int firstgood = 0;
        while (firstgood < firstgoodlimit) {
            Node good_node = (Node)all.get(firstgood);
            if (!(good_node instanceof Tag)) {
                ++firstgood;
                continue;
            }
            Tag good = (Tag)good_node;
            int recursion = 1;
            boolean found = false;
            for (i2 = firstgood + 1; i2 < all.size(); ++i2) {
                Tag cand;
                Node cand_node = (Node)all.get(i2);
                if (!(cand_node instanceof Tag) || !(cand = (Tag)cand_node).getTagName().equals(good.getTagName())) continue;
                if (!cand.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                if (i2 < firstgoodlimit) break;
                found = true;
                break;
            }
            if (found) break;
            ++firstgood;
        }
        int lastgoodlimit = all.size() - 1;
        all.addAll(this.afters);
        int lastgood = all.size() - 1;
        while (lastgood > lastgoodlimit) {
            Node good_node = (Node)all.get(lastgood);
            if (!(good_node instanceof Tag)) {
                --lastgood;
                continue;
            }
            Tag good = (Tag)good_node;
            int recursion = 1;
            boolean found = false;
            for (int i3 = lastgood - 1; i3 >= firstgoodlimit; --i3) {
                Tag cand;
                Node cand_node = (Node)all.get(i3);
                if (!(cand_node instanceof Tag) || !(cand = (Tag)cand_node).getTagName().equals(good.getTagName())) continue;
                if (cand.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                if (i3 > lastgoodlimit) break;
                found = true;
                break;
            }
            if (found) break;
            --lastgood;
        }
        boolean changed = true;
        block4: while (changed) {
            Node node2;
            int i4;
            boolean removeSpacesAround;
            changed = false;
            boolean removeTags = Core.getFilterMaster().getConfig().isRemoveTags();
            if (!removeTags) {
                for (i2 = 0; i2 < firstgood; ++i2) {
                    node = (Node)all.get(i2);
                    if (!(node instanceof Tag)) continue;
                    firstgood = i2;
                    changed = true;
                    break;
                }
                for (i2 = all.size() - 1; i2 > lastgood; --i2) {
                    node = (Node)all.get(i2);
                    if (!(node instanceof Tag)) continue;
                    lastgood = i2;
                    changed = true;
                    break;
                }
            }
            if (removeSpacesAround = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg()) continue;
            for (i4 = 0; i4 < firstgood; ++i4) {
                node2 = (Node)all.get(i4);
                if (!(node2 instanceof TextNode)) continue;
                firstgood = i4;
                changed = true;
                break;
            }
            for (i4 = all.size() - 1; i4 > lastgood; --i4) {
                node2 = (Node)all.get(i4);
                if (!(node2 instanceof TextNode)) continue;
                lastgood = i4;
                changed = true;
                continue block4;
            }
        }
        for (int i5 = 0; i5 < firstgood; ++i5) {
            Node node3 = (Node)all.get(i5);
            if (node3 instanceof Tag) {
                this.writeout("<" + node3.getText() + ">");
                continue;
            }
            this.writeout(this.compressWhitespace(node3.getText()));
        }
        StringBuilder paragraph = new StringBuilder();
        for (int i6 = firstgood; i6 <= lastgood; ++i6) {
            node = (Node)all.get(i6);
            if (node instanceof Tag) {
                this.shortcut((Tag)node, paragraph);
                continue;
            }
            paragraph.append(this.entitiesToChars(node.toHtml()));
        }
        String compressed = uncompressed = paragraph.toString();
        String spacePrefix = "";
        String spacePostfix = "";
        int size = uncompressed.length();
        if (!this.preformatting) {
            int cp;
            for (i = 0; i < size; i += Character.charCount(cp)) {
                cp = uncompressed.codePointAt(i);
                if (Character.isWhitespace(cp)) continue;
                spacePrefix = i == 0 ? "" : uncompressed.substring(0, this.options.getCompressWhitespace() ? Math.min(i, uncompressed.offsetByCodePoints(i, 1)) : i);
                break;
            }
            for (i = size; i > 0; i -= Character.charCount(cp)) {
                cp = uncompressed.codePointBefore(i);
                if (Character.isWhitespace(cp)) continue;
                spacePostfix = i == size ? "" : uncompressed.substring(i, this.options.getCompressWhitespace() ? Math.min(uncompressed.offsetByCodePoints(i, 1), size) : size);
                break;
            }
            compressed = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg() ? StringUtil.compressSpaces(uncompressed) : uncompressed;
        }
        if (compressed.equals(translation = this.filter.privateProcessEntry(compressed, null)) && !this.options.getCompressWhitespace()) {
            translation = uncompressed;
        }
        translation = this.charsToEntities(translation);
        translation = this.unshorcutize(translation);
        this.writeout(spacePrefix);
        this.writeout(translation);
        this.writeout(spacePostfix);
        for (i = lastgood + 1; i < all.size(); ++i) {
            Node node4 = (Node)all.get(i);
            if (node4 instanceof Tag) {
                this.writeout("<" + node4.getText() + ">");
                continue;
            }
            this.writeout(this.compressWhitespace(node4.getText()));
        }
        this.cleanup();
    }

    private void cleanup() {
        this.text = false;
        this.recurse = true;
        this.befors = new ArrayList<Node>();
        this.translatable = new ArrayList<Node>();
        this.afters = new ArrayList<Node>();
        this.s_tags = new ArrayList<Tag>();
        this.s_tag_numbers = new ArrayList<Integer>();
        this.s_shortcuts = new ArrayList<String>();
        this.s_nshortcuts = 0;
    }

    private void shortcut(Tag tag, StringBuilder paragraph) {
        StringBuilder result = new StringBuilder();
        result.append('<');
        int n = -1;
        if (tag.isEndTag()) {
            result.append('/');
            int recursion = 1;
            for (int i = this.s_tags.size() - 1; i >= 0; --i) {
                Tag othertag = this.s_tags.get(i);
                if (!othertag.getTagName().equals(tag.getTagName())) continue;
                if (othertag.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                n = this.s_tag_numbers.get(i);
                break;
            }
            if (n < 0) {
                n = this.s_nshortcuts++;
            }
        } else {
            n = this.s_nshortcuts++;
        }
        if ("BR".equals(tag.getTagName())) {
            result.append("br");
        } else {
            result.appendCodePoint(Character.toLowerCase(tag.getTagName().codePointAt(0)));
        }
        result.append(n);
        if (tag.isEmptyXmlTag()) {
            result.append('/');
        }
        result.append('>');
        String shortcut = result.toString();
        this.s_tags.add(tag);
        this.s_tag_numbers.add(n);
        this.s_shortcuts.add(shortcut);
        paragraph.append(shortcut);
    }

    private String unshorcutize(String str) {
        block2: for (int i = 0; i < this.s_shortcuts.size(); ++i) {
            String shortcut = this.s_shortcuts.get(i);
            int pos = -1;
            while ((pos = str.indexOf(shortcut, pos + 1)) >= 0) {
                Tag tag = this.s_tags.get(i);
                try {
                    str = str.substring(0, pos) + "<" + tag.getText() + ">" + str.substring(pos + shortcut.length());
                }
                catch (StringIndexOutOfBoundsException sioobe) {
                    continue block2;
                }
            }
        }
        return str;
    }

    private void queueTranslatable(Text text) {
        if (!text.toHtml().trim().isEmpty()) {
            this.translatable.addAll(this.afters);
            this.afters.clear();
            this.translatable.add(text);
        } else {
            this.afters.add(text);
        }
    }

    private void queueTranslatable(Tag tag) {
        this.afters.add(tag);
    }

    protected void queuePrefix(Tag tag) {
        if (this.text) {
            this.queueTranslatable(tag);
        } else if (this.isParagraphTag(tag)) {
            this.flushbefors();
            this.writeout("<" + tag.getText() + ">");
        } else {
            this.befors.add(tag);
        }
    }

    private void queuePrefix(Text text) {
        this.befors.add(text);
    }

    private void flushbefors() {
        for (Node node : this.befors) {
            if (node instanceof Tag) {
                this.writeout("<" + node.getText() + ">");
                continue;
            }
            this.writeout(this.compressWhitespace(node.getText()));
        }
        this.befors.clear();
    }

    private String compressWhitespace(String input) {
        if (this.options.getCompressWhitespace()) {
            Matcher whitespaceMatch = PatternConsts.SPACE_TAB.matcher(input);
            return whitespaceMatch.replaceAll(" ");
        }
        return input;
    }

    protected String entitiesToChars(String str) {
        int cp;
        int strlen = str.length();
        StringBuilder res = new StringBuilder(strlen);
        block7: for (int i = 0; i < strlen; i += Character.charCount(cp)) {
            cp = str.codePointAt(i);
            switch (cp) {
                case 38: {
                    if (str.codePointCount(i, strlen) < 2) {
                        res.appendCodePoint(cp);
                        continue block7;
                    }
                    int cp1 = str.codePointAt(str.offsetByCodePoints(i, 1));
                    if (cp1 == 35) {
                        int decStart;
                        int decEnd;
                        int decCp;
                        String s_entity;
                        int cp2 = str.codePointAt(str.offsetByCodePoints(i, 2));
                        if (cp2 == 120 || cp2 == 88) {
                            int hexStart;
                            int hexEnd;
                            int hexCp;
                            for (hexEnd = hexStart = str.offsetByCodePoints(i, 3); hexEnd < strlen && this.isHexDigit(hexCp = str.codePointAt(hexEnd)); hexEnd += Character.charCount(hexCp)) {
                            }
                            s_entity = str.substring(hexStart, hexEnd);
                            try {
                                int n_entity = Integer.parseInt(s_entity, 16);
                                if (n_entity > 0 && n_entity <= 0x10FFFF) {
                                    res.appendCodePoint(n_entity);
                                    if (hexEnd < strlen && str.codePointAt(hexEnd) == 59) {
                                        i = hexEnd;
                                        continue block7;
                                    }
                                    i = str.offsetByCodePoints(hexEnd, -1);
                                    continue block7;
                                }
                                res.appendCodePoint(cp);
                            }
                            catch (NumberFormatException nfe) {
                                res.appendCodePoint(cp);
                            }
                            continue block7;
                        }
                        for (decEnd = decStart = str.offsetByCodePoints(i, 2); decEnd < strlen && this.isDecimalDigit(decCp = str.codePointAt(decEnd)); decEnd += Character.charCount(decCp)) {
                        }
                        s_entity = str.substring(decStart, decEnd);
                        try {
                            int n_entity = Integer.parseInt(s_entity, 10);
                            if (n_entity > 0 && n_entity <= 0x10FFFF) {
                                res.appendCodePoint(n_entity);
                                if (decEnd < strlen && str.codePointAt(decEnd) == 59) {
                                    i = decEnd;
                                    continue block7;
                                }
                                i = str.offsetByCodePoints(decEnd, -1);
                                continue block7;
                            }
                            res.appendCodePoint(cp);
                        }
                        catch (NumberFormatException nfe) {
                            res.appendCodePoint(cp);
                        }
                        continue block7;
                    }
                    if (this.isLatinLetter(cp1)) {
                        int entStart;
                        int entEnd;
                        int entCp;
                        for (entEnd = entStart = str.offsetByCodePoints(i, 1); entEnd < strlen && (this.isLatinLetter(entCp = str.codePointAt(entEnd)) || this.isDecimalDigit(entCp)); entEnd += Character.charCount(entCp)) {
                        }
                        String s_entity = str.substring(entStart, entEnd);
                        int n_entity = this.lookupEntity(s_entity);
                        if (n_entity > 0 && n_entity <= 65535) {
                            res.append((char)n_entity);
                            if (entEnd < strlen && str.codePointAt(entEnd) == 59) {
                                i = entEnd;
                                continue block7;
                            }
                            i = str.offsetByCodePoints(entEnd, -1);
                            continue block7;
                        }
                        res.appendCodePoint(cp);
                        continue block7;
                    }
                    res.appendCodePoint(cp);
                    continue block7;
                }
                default: {
                    res.appendCodePoint(cp);
                }
            }
        }
        return res.toString();
    }

    private boolean isLatinLetter(int ch) {
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90;
    }

    private boolean isDecimalDigit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    private boolean isHexDigit(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    private int lookupEntity(String entity) {
        for (int i = 0; i < ENTITIES.length; ++i) {
            Object[] ONENT = ENTITIES[i];
            if (!entity.equals(ONENT[0])) continue;
            return (Integer)ONENT[1];
        }
        return -1;
    }

    protected String charsToEntities(String str) {
        String contents;
        block16: {
            int cp;
            int strlen = str.length();
            StringBuilder res = new StringBuilder(strlen * 5);
            block6: for (int i = 0; i < strlen; i += Character.charCount(cp)) {
                cp = str.codePointAt(i);
                switch (cp) {
                    case 160: {
                        res.append("&nbsp;");
                        continue block6;
                    }
                    case 38: {
                        res.append("&amp;");
                        continue block6;
                    }
                    case 62: {
                        if (i > 0 && str.codePointBefore(i) == 63) {
                            res.append(">");
                            continue block6;
                        }
                        res.append("&gt;");
                        continue block6;
                    }
                    case 60: {
                        int qMarkPos = str.indexOf(63, i);
                        if (qMarkPos == str.offsetByCodePoints(i, 1)) {
                            res.append("<");
                            continue block6;
                        }
                        int gtpos = str.indexOf(62, i);
                        if (gtpos >= 0) {
                            String maybeShortcut = str.substring(i, str.offsetByCodePoints(gtpos, 1));
                            boolean foundShortcut = false;
                            for (String currShortcut : this.s_shortcuts) {
                                if (!maybeShortcut.equals(currShortcut)) continue;
                                foundShortcut = true;
                                break;
                            }
                            if (foundShortcut) {
                                res.append(maybeShortcut);
                                i = gtpos;
                                continue block6;
                            }
                            res.append("&lt;");
                            continue block6;
                        }
                        res.append("&lt;");
                        continue block6;
                    }
                    default: {
                        res.appendCodePoint(cp);
                    }
                }
            }
            contents = res.toString();
            String encoding = this.filter.getTargetEncoding();
            if (encoding == null) break block16;
            CharsetEncoder charsetEncoder = Charset.forName(encoding).newEncoder();
            int i = 0;
            while (true) {
                if (i < contents.length()) {
                    int cp2 = contents.codePointAt(i);
                    String substring = contents.substring(i, i + Character.charCount(cp2));
                    if (!charsetEncoder.canEncode(substring)) {
                        String replacement = "&#" + cp2 + ';';
                        contents = contents.replaceAll(Pattern.quote(substring), replacement);
                    } else {
                        i += substring.length();
                        continue;
                    }
                }
                if (i == contents.length()) break;
            }
        }
        return contents;
    }
}

