/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.ModificationInfoManager;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OConsts;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIThreadsUtil;

public class SegmentBuilder {
    public static final String SEGMENT_MARK_ATTRIBUTE = "SEGMENT_MARK_ATTRIBUTE";
    public static final String SEGMENT_SPELL_CHECK = "SEGMENT_SPELL_CHECK";
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0000");
    static AtomicLong globalVersions = new AtomicLong();
    final SourceTextEntry ste;
    final int segmentNumberInProject;
    private volatile long displayVersion;
    private String sourceText;
    private String translationText;
    private boolean active;
    private boolean transExist;
    private boolean noteExist;
    private boolean defaultTranslation;
    private final Document3 doc;
    private final EditorController controller;
    private final EditorSettings settings;
    protected int activeTranslationBeginOffset;
    protected int activeTranslationEndOffset;
    protected Position beginPosP1;
    protected Position endPosM1;
    protected Position posSourceBeg;
    protected int posSourceLength;
    protected Position posTranslationBeg;
    protected int posTranslationLength;
    protected int offset;
    protected MarkerController.MarkInfo[][] marks;
    protected final boolean hasRTL;

    public SegmentBuilder(EditorController controller, Document3 doc, EditorSettings settings, SourceTextEntry ste, int segmentNumberInProject, boolean hasRTL) {
        this.controller = controller;
        this.doc = doc;
        this.settings = settings;
        this.ste = ste;
        this.segmentNumberInProject = segmentNumberInProject;
        this.hasRTL = hasRTL;
    }

    public boolean isDefaultTranslation() {
        return this.defaultTranslation;
    }

    public void setDefaultTranslation(boolean defaultTranslation) {
        this.defaultTranslation = defaultTranslation;
    }

    public void createSegmentElement(boolean isActive, TMXEntry trans) {
        this.createSegmentElement(isActive, this.doc.getLength(), trans);
    }

    public void prependSegmentElement(boolean isActive, TMXEntry trans) {
        this.createSegmentElement(isActive, 0, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSegmentElement(boolean isActive, int initialOffset, TMXEntry trans) {
        UIThreadsUtil.mustBeSwingThread();
        this.displayVersion = globalVersions.incrementAndGet();
        this.active = isActive;
        this.doc.trustedChangesInProgress = true;
        StaticUIUtils.setCaretUpdateEnabled(this.controller.editor, false);
        try {
            try {
                int endOffset;
                int beginOffset;
                if (this.beginPosP1 != null && this.endPosM1 != null) {
                    beginOffset = this.beginPosP1.getOffset() - 1;
                    endOffset = this.endPosM1.getOffset() + 1;
                    this.doc.remove(beginOffset, endOffset - beginOffset);
                    this.offset = beginOffset;
                } else {
                    this.offset = initialOffset;
                }
                this.defaultTranslation = trans.defaultTranslation;
                if (!Core.getProject().getProjectProperties().isSupportDefaultTranslations()) {
                    this.defaultTranslation = false;
                }
                this.transExist = trans.isTranslated();
                this.noteExist = trans.hasNote();
                beginOffset = this.offset;
                if (isActive) {
                    this.createActiveSegmentElement(trans);
                } else {
                    this.createInactiveSegmentElement(trans);
                }
                endOffset = this.offset;
                this.beginPosP1 = this.doc.createPosition(beginOffset + 1);
                this.endPosM1 = this.doc.createPosition(endOffset - 1);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.doc.trustedChangesInProgress = false;
            StaticUIUtils.setCaretUpdateEnabled(this.controller.editor, true);
        }
    }

    public boolean hasBeenCreated() {
        return this.beginPosP1 != null && this.endPosM1 != null;
    }

    public void addSegmentSeparator() {
        this.addSegmentSeparator(this.doc.getLength());
    }

    public void prependSegmentSeparator() {
        this.addSegmentSeparator(0);
    }

    public void addSegmentSeparator(int index) {
        this.doc.trustedChangesInProgress = true;
        StaticUIUtils.setCaretUpdateEnabled(this.controller.editor, false);
        try {
            try {
                this.doc.insertString(index, "\n", null);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.doc.trustedChangesInProgress = false;
            StaticUIUtils.setCaretUpdateEnabled(this.controller.editor, true);
        }
    }

    private void createActiveSegmentElement(TMXEntry trans) throws BadLocationException {
        try {
            if (EditorSettings.DISPLAY_MODIFICATION_INFO_ALL.equals(this.settings.getDisplayModificationInfo()) || EditorSettings.DISPLAY_MODIFICATION_INFO_SELECTED.equals(this.settings.getDisplayModificationInfo())) {
                this.addModificationInfoPart(trans);
            }
            int prevOffset = this.offset;
            this.sourceText = this.ste.getSrcText();
            this.addInactiveSegPart(true, this.sourceText);
            Map<Language, ProjectTMX> otherLanguageTMs = Core.getProject().getOtherTargetLanguageTMs();
            for (Map.Entry<Language, ProjectTMX> entry : otherLanguageTMs.entrySet()) {
                TMXEntry altTrans = entry.getValue().getDefaultTranslation(this.sourceText);
                if (altTrans == null || !altTrans.isTranslated()) continue;
                Language language = entry.getKey();
                this.addOtherLanguagePart(altTrans.translation, language);
            }
            this.posSourceBeg = this.doc.createPosition(prevOffset + (this.hasRTL ? 1 : 0));
            this.posSourceLength = this.sourceText.length();
            if (trans.isTranslated()) {
                this.translationText = trans.translation;
            } else {
                boolean insertSource;
                boolean bl = insertSource = !Preferences.isPreference("wf_noSourceText");
                if (this.controller.entriesFilter != null && this.controller.entriesFilter.isSourceAsEmptyTranslation()) {
                    insertSource = true;
                }
                if (insertSource) {
                    String srcText = this.ste.getSrcText();
                    if (Preferences.isPreference("glossary_replace_on_insert")) {
                        srcText = EditorUtils.replaceGlossaryEntries(srcText);
                    }
                    this.translationText = srcText;
                } else {
                    this.translationText = "";
                }
            }
            this.addActiveSegPart(this.translationText);
            this.posTranslationBeg = null;
            this.doc.activeTranslationBeginM1 = this.doc.createPosition(this.activeTranslationBeginOffset - 1);
            this.doc.activeTranslationEndP1 = this.doc.createPosition(this.activeTranslationEndOffset + 1);
        }
        catch (OutOfMemoryError oome) {
            this.doc.remove(0, this.doc.getLength());
            System.gc();
            long memory = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
            Log.logErrorRB("OUT_OF_MEMORY", memory);
            Log.log(oome);
            Core.getMainWindow().showErrorDialogRB("TF_ERROR", "OUT_OF_MEMORY", memory);
            System.exit(0);
        }
    }

    private void createInactiveSegmentElement(TMXEntry trans) throws BadLocationException {
        int prevOffset;
        if (EditorSettings.DISPLAY_MODIFICATION_INFO_ALL.equals(this.settings.getDisplayModificationInfo())) {
            this.addModificationInfoPart(trans);
        }
        this.sourceText = null;
        this.translationText = null;
        if (this.settings.isDisplaySegmentSources()) {
            this.sourceText = this.ste.getSrcText();
        }
        if (trans.isTranslated()) {
            this.translationText = trans.translation;
            if (StringUtil.isEmpty(this.translationText)) {
                this.translationText = OStrings.getString("EMPTY_TRANSLATION");
            }
        } else if (this.sourceText == null) {
            this.sourceText = this.ste.getSrcText();
        }
        if (this.sourceText != null) {
            prevOffset = this.offset;
            this.addInactiveSegPart(true, this.sourceText);
            this.posSourceBeg = this.doc.createPosition(prevOffset + (this.hasRTL ? 1 : 0));
            this.posSourceLength = this.sourceText.length();
        } else {
            this.posSourceBeg = null;
        }
        if (this.translationText != null) {
            prevOffset = this.offset;
            this.addInactiveSegPart(false, this.translationText);
            this.posTranslationBeg = this.doc.createPosition(prevOffset + (this.hasRTL ? 1 : 0));
            this.posTranslationLength = this.translationText.length();
        } else {
            this.posTranslationBeg = null;
        }
    }

    public SourceTextEntry getSourceTextEntry() {
        return this.ste;
    }

    public long getDisplayVersion() {
        return this.displayVersion;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public String getTranslationText() {
        return this.translationText;
    }

    public int getStartSourcePosition() {
        if (this.posSourceBeg != null) {
            return this.posSourceBeg.getOffset();
        }
        return -1;
    }

    public int getStartTranslationPosition() {
        if (this.posTranslationBeg != null) {
            return this.posTranslationBeg.getOffset();
        }
        return -1;
    }

    public int getStartPosition() {
        return this.beginPosP1.getOffset() - 1;
    }

    public int getEndPosition() {
        return this.endPosM1.getOffset() + 1;
    }

    private void setAlignment(int begin, int end, boolean isRTL) {
        boolean rtl = false;
        switch (this.controller.currentOrientation) {
            case ALL_LTR: {
                rtl = false;
                break;
            }
            case ALL_RTL: {
                rtl = true;
                break;
            }
            case DIFFER: {
                rtl = isRTL;
            }
        }
        this.doc.setAlignment(begin, end, rtl);
    }

    public boolean isInsideSegment(int location) {
        return this.beginPosP1.getOffset() - 1 <= location && location < this.endPosM1.getOffset() + 1;
    }

    private void addInactiveSegPart(boolean isSource, String text) throws BadLocationException {
        int prevOffset = this.offset;
        boolean rtl = isSource ? this.controller.sourceLangIsRTL : this.controller.targetLangIsRTL;
        this.insertDirectionEmbedding(rtl);
        this.insertTextWithTags(text, isSource);
        this.insertDirectionEndEmbedding();
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
    }

    private void addOtherLanguagePart(String text, Language language) throws BadLocationException {
        int prevOffset = this.offset;
        boolean rtl = EditorUtils.isRTL(language.getLanguageCode());
        this.insertDirectionEmbedding(false);
        AttributeSet normal = this.attrs(true, false, false, false);
        this.insert(language.getLanguage() + ": ", normal);
        this.insertDirectionEndEmbedding();
        this.insertDirectionEmbedding(rtl);
        AttributeSet attrs = this.settings.getOtherLanguageTranslationAttributeSet();
        this.insert(text, attrs);
        this.insertDirectionEndEmbedding();
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
    }

    private void addModificationInfoPart(TMXEntry trans) throws BadLocationException {
        String text;
        if (!trans.isTranslated()) {
            return;
        }
        if (Preferences.isPreference("view_option_template_active")) {
            text = ModificationInfoManager.apply(trans);
        } else {
            String template;
            String author;
            String string = author = trans.changer == null ? OStrings.getString("TF_CUR_SEGMENT_UNKNOWN_AUTHOR") : trans.changer;
            if (trans.changeDate != 0L) {
                template = OStrings.getString("TF_CUR_SEGMENT_AUTHOR_DATE");
                Date changeDate = new Date(trans.changeDate);
                String changeDateString = DateFormat.getDateInstance().format(changeDate);
                String changeTimeString = DateFormat.getTimeInstance().format(changeDate);
                Object[] args = new Object[]{author, changeDateString, changeTimeString};
                text = StringUtil.format(template, args);
            } else {
                template = OStrings.getString("TF_CUR_SEGMENT_AUTHOR");
                Object[] args = new Object[]{author};
                text = StringUtil.format(template, args);
            }
        }
        int prevOffset = this.offset;
        boolean rtl = EditorUtils.localeIsRTL();
        this.insertDirectionEmbedding(rtl);
        AttributeSet attrs = this.settings.getModificationInfoAttributeSet();
        this.insert(text, attrs);
        this.insertDirectionEndEmbedding();
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
    }

    private void addActiveSegPart(String text) throws BadLocationException {
        int prevOffset = this.offset;
        boolean rtl = this.controller.targetLangIsRTL;
        this.insertDirectionEmbedding(rtl);
        this.activeTranslationBeginOffset = this.offset;
        this.insertTextWithTags(text, false);
        this.activeTranslationEndOffset = this.offset;
        this.insertDirectionEndEmbedding();
        this.insertDirectionMarker(rtl);
        this.insertDirectionEmbedding(EditorUtils.localeIsRTL());
        AttributeSet attrSegmentMark = this.settings.getSegmentMarkerAttributeSet();
        this.insert(this.createSegmentMarkText(), attrSegmentMark);
        this.insertDirectionEndEmbedding();
        this.insertDirectionMarker(rtl);
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
    }

    void createInputAttributes(Element element, MutableAttributeSet set) {
        set.addAttributes(this.attrs(false, false, false, false));
    }

    private void insert(String text, AttributeSet attrs) throws BadLocationException {
        this.doc.insertString(this.offset, text, attrs);
        this.offset += text.length();
    }

    private String createSegmentMarkText() {
        String text = OConsts.segmentMarkerString;
        if (text.contains("0000")) {
            String replacement = NUMBER_FORMAT.format(this.segmentNumberInProject);
            if (Preferences.isPreference("mark_non_unique_segments") && this.ste.getDuplicate() != SourceTextEntry.DUPLICATE.NONE) {
                replacement = StringUtil.format(OStrings.getString("SW_FILE_AND_NR_OF_MORE"), replacement, this.ste.getNumberOfDuplicates());
            }
            text = text.replace("0000", replacement);
        }
        text = text.trim().replace(' ', '\u00a0');
        return text;
    }

    void onActiveEntryChanged() {
        this.translationText = this.doc.extractTranslation();
        this.displayVersion = globalVersions.incrementAndGet();
    }

    public AttributeSet attrs(boolean isSource, boolean isPlaceholder, boolean isRemoveText, boolean isNBSP) {
        return this.settings.getAttributeSet(isSource, isPlaceholder, isRemoveText, this.ste.getDuplicate(), this.active, this.transExist, this.noteExist, isNBSP);
    }

    private void insertTextWithTags(String text, boolean isSource) throws BadLocationException {
        AttributeSet normal = this.attrs(isSource, false, false, false);
        this.insert(text, normal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTextAttributes() {
        this.doc.trustedChangesInProgress = true;
        try {
            int tBeg;
            AttributeSet attrs;
            if (this.posSourceBeg != null) {
                int sBeg = this.posSourceBeg.getOffset();
                int sLen = this.posSourceLength;
                attrs = this.attrs(true, false, false, false);
                this.doc.setCharacterAttributes(sBeg, sLen, attrs, true);
            }
            if (this.active) {
                tBeg = this.doc.getTranslationStart();
                int tEnd = this.doc.getTranslationEnd();
                attrs = this.attrs(false, false, false, false);
                this.doc.setCharacterAttributes(tBeg, tEnd - tBeg, attrs, true);
            } else if (this.posTranslationBeg != null) {
                tBeg = this.posTranslationBeg.getOffset();
                int tLen = this.posTranslationLength;
                attrs = this.attrs(false, false, false, false);
                this.doc.setCharacterAttributes(tBeg, tLen, attrs, true);
            }
        }
        finally {
            this.doc.trustedChangesInProgress = false;
        }
    }

    private void insertDirectionEmbedding(boolean isRTL) throws BadLocationException {
        if (this.hasRTL) {
            this.insert(isRTL ? "\u202b" : "\u202a", null);
        }
    }

    private void insertDirectionEndEmbedding() throws BadLocationException {
        if (this.hasRTL) {
            this.insert("\u202c", null);
        }
    }

    private void insertDirectionMarker(boolean isRTL) throws BadLocationException {
        if (this.hasRTL) {
            this.insert(isRTL ? "\u200f" : "\u200e", null);
        }
    }
}

