/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.tagvalidation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.core.tagvalidation.TagRepair;
import org.omegat.core.tagvalidation.TagValidation;
import org.omegat.filters2.po.PoFilter;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.tagvalidation.ITagValidation;
import org.omegat.gui.tagvalidation.TagValidationFrame;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.TagUtil;

public class TagValidationTool
implements ITagValidation,
IProjectEventListener {
    private TagValidationFrame m_tagWin;
    private MainWindow mainWindow;
    private List<String> srcTags = new ArrayList<String>(32);
    private List<String> locTags = new ArrayList<String>(32);
    private HashSet<String> printfSourceSet = new HashSet();
    private HashSet<String> printfTargetSet = new HashSet();

    public TagValidationTool(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        CoreEvents.registerProjectChangeListener(this);
    }

    public TagValidationTool() {
        CoreEvents.registerProjectChangeListener(this);
    }

    @Override
    public synchronized void displayTagValidationErrors(List<ErrorReport> suspects, String message) {
        if (this.mainWindow != null) {
            this.showTagResultsInGui(suspects, message);
        } else {
            this.showTagResultsInConsole(suspects);
        }
    }

    private void showTagResultsInGui(List<ErrorReport> suspects, String message) {
        if (suspects != null && !suspects.isEmpty()) {
            if (this.m_tagWin == null) {
                this.m_tagWin = new TagValidationFrame(this.mainWindow);
                this.m_tagWin.setFont(Core.getMainWindow().getApplicationFont());
            } else {
                this.m_tagWin.dispose();
            }
            this.m_tagWin.setVisible(true);
            this.m_tagWin.setMessage(message);
            this.m_tagWin.displayErrorList(suspects);
        } else {
            if (this.m_tagWin != null) {
                this.m_tagWin.dispose();
            }
            JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("TF_NOTICE_OK_TAGS"), OStrings.getString("TF_NOTICE_TITLE_TAGS"), 1);
        }
    }

    private void showTagResultsInConsole(List<ErrorReport> suspects) {
        if (suspects != null && !suspects.isEmpty()) {
            for (ErrorReport report : suspects) {
                System.out.println(report.entryNum);
                System.out.println(report.source);
                System.out.println(report.translation);
                for (Map.Entry<ErrorReport.TagError, List<TagUtil.Tag>> e : report.inverseReport().entrySet()) {
                    System.out.print("  ");
                    System.out.print(ErrorReport.localizedTagError(e.getKey()));
                    System.out.print(": ");
                    for (TagUtil.Tag tag : e.getValue()) {
                        System.out.print(tag);
                        System.out.print(" ");
                    }
                    System.out.println();
                }
            }
        }
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case CLOSE: {
                if (this.m_tagWin == null) break;
                this.m_tagWin.dispose();
                break;
            }
        }
    }

    @Override
    public synchronized List<ErrorReport> listInvalidTags() {
        return this.listInvalidTags(".*");
    }

    @Override
    public synchronized List<ErrorReport> listInvalidTags(String sourcePattern) {
        Pattern FILE_PATTERN = Pattern.compile(sourcePattern);
        ArrayList<ErrorReport> suspects = new ArrayList<ErrorReport>(16);
        for (IProject.FileInfo fi : Core.getProject().getProjectFiles()) {
            Matcher fileMatch = FILE_PATTERN.matcher(fi.filePath);
            if (!fileMatch.matches()) continue;
            for (SourceTextEntry ste : fi.entries) {
                ErrorReport err = this.checkEntry(fi, ste);
                if (err == null) continue;
                suspects.add(err);
            }
        }
        return suspects.isEmpty() ? null : suspects;
    }

    @Override
    public synchronized boolean checkInvalidTags(SourceTextEntry ste) {
        for (IProject.FileInfo fi : Core.getProject().getProjectFiles()) {
            for (SourceTextEntry s : fi.entries) {
                if (s != ste) continue;
                ErrorReport err = this.checkEntry(fi, ste);
                return err == null;
            }
        }
        throw new RuntimeException("Invalid SourceTextEntry storage for tag validation");
    }

    private ErrorReport checkEntry(IProject.FileInfo fi, SourceTextEntry ste) {
        this.srcTags.clear();
        this.locTags.clear();
        this.printfSourceSet.clear();
        this.printfTargetSet.clear();
        String s = ste.getSrcText();
        TMXEntry te = Core.getProject().getTranslationInfo(ste);
        if (!te.isTranslated() || s.isEmpty()) {
            return null;
        }
        ErrorReport report = new ErrorReport(ste, te.translation);
        if (Preferences.isPreference("tagValidation_elaborateCheck")) {
            TagValidation.inspectPrintfVariables(false, report);
        } else if (Preferences.isPreference("tagValidation_simpleCheck")) {
            TagValidation.inspectPrintfVariables(true, report);
        }
        if (fi.filterClass.equals(PoFilter.class)) {
            TagValidation.inspectPOWhitespace(report);
        }
        TagValidation.inspectOmegaTTags(ste, report);
        if (Preferences.isPreference("tagValidation_javaMessageFormatSimplePatternCheck")) {
            TagValidation.inspectJavaMessageFormat(report);
        }
        TagValidation.inspectRemovePattern(report);
        return report.isEmpty() ? null : report;
    }

    public static String fixErrors(ErrorReport report) {
        if (report.srcErrors.containsValue((Object)ErrorReport.TagError.UNSPECIFIED) || report.transErrors.containsValue((Object)ErrorReport.TagError.UNSPECIFIED)) {
            return null;
        }
        TreeMap<TagUtil.Tag, ErrorReport.TagError> sortedErrors = new TreeMap<TagUtil.Tag, ErrorReport.TagError>(new Comparator<TagUtil.Tag>(){

            @Override
            public int compare(TagUtil.Tag o1, TagUtil.Tag o2) {
                return o1.pos < o2.pos ? -1 : (o1.pos > o2.pos ? 1 : 0);
            }
        });
        sortedErrors.putAll(report.srcErrors);
        sortedErrors.putAll(report.transErrors);
        StringBuilder sb = new StringBuilder(report.translation);
        for (Map.Entry e : sortedErrors.entrySet()) {
            TagRepair.fixTag(report.ste, (TagUtil.Tag)e.getKey(), (ErrorReport.TagError)((Object)e.getValue()), sb, report.source);
        }
        return sb.toString();
    }
}

