/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.omegat.core.Core;
import org.omegat.tokenizer.BaseTokenizer;
import org.omegat.tokenizer.Tokenizer;

@Tokenizer(languages={"en"}, isDefault=true)
public class LuceneEnglishTokenizer
extends BaseTokenizer {
    public static final Set<String> STOP_WORDS = new HashSet<String>();

    public static void loadPlugins() {
        Core.registerTokenizerClass(LuceneEnglishTokenizer.class);
    }

    public static void unloadPlugins() {
    }

    @Override
    protected TokenStream getTokenStream(String strOrig, boolean stemsAllowed, boolean stopWordsAllowed) {
        if (stemsAllowed) {
            return new EnglishAnalyzer(this.getBehavior(), stopWordsAllowed ? STOP_WORDS : Collections.emptySet()).tokenStream("", new StringReader(strOrig));
        }
        return new StandardTokenizer(this.getBehavior(), (Reader)new StringReader(strOrig));
    }

    static {
        try {
            InputStream in = LuceneEnglishTokenizer.class.getResourceAsStream("StopList_en.txt");
            try {
                String s;
                BufferedReader rd = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                while ((s = rd.readLine()) != null) {
                    if ((s = s.trim()).isEmpty() || s.startsWith("#")) continue;
                    STOP_WORDS.add(s);
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError("Error load stopwords in SnowballEnglishTokenizer: " + ex.getMessage());
        }
    }
}

