/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.util.SVNLogType;

public class FSReplayPathHandler
implements ISVNCommitPathHandler {
    private FSRoot myRoot;
    private FSRoot myCompareRoot;
    private Map myChangedPaths;
    private String myBasePath;
    private long myLowRevision;
    private LinkedList myCopies;
    private FSFS myOwner;
    private SVNDeltaGenerator myDeltaGenerator;
    private SVNDeltaCombiner myDeltaCombiner;

    public FSReplayPathHandler(FSFS owner, FSRoot root, FSRoot compareRoot, Map changedPaths, String basePath, long lowRevision) {
        this.myRoot = root;
        this.myCompareRoot = compareRoot;
        this.myChangedPaths = changedPaths;
        this.myBasePath = basePath;
        this.myLowRevision = lowRevision;
        this.myCopies = new LinkedList();
        this.myOwner = owner;
        this.myDeltaGenerator = new SVNDeltaGenerator();
        this.myDeltaCombiner = new SVNDeltaCombiner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleCommitPath(String path, ISVNEditor editor) throws SVNException {
        boolean closeFile;
        boolean closeDir;
        String absPath;
        block45: {
            String string = absPath = !path.startsWith("/") ? "/" + path : path;
            while (this.myCopies.size() > 0) {
                CopyInfo info = (CopyInfo)this.myCopies.getLast();
                if (SVNPathUtil.isAncestor(info.myPath, path)) break;
                this.myCopies.removeLast();
            }
            boolean isAdd = false;
            boolean isDelete = false;
            FSPathChange change = (FSPathChange)this.myChangedPaths.get(path);
            if (change == null) {
                return false;
            }
            if (change.getChangeKind() == FSPathChangeKind.FS_PATH_CHANGE_ADD) {
                isAdd = true;
            } else if (change.getChangeKind() == FSPathChangeKind.FS_PATH_CHANGE_DELETE) {
                isDelete = true;
            } else if (change.getChangeKind() == FSPathChangeKind.FS_PATH_CHANGE_REPLACE) {
                isAdd = true;
                isDelete = true;
            }
            closeDir = false;
            if (isDelete) {
                editor.deleteEntry(path, -1L);
            }
            SVNNodeKind kind = null;
            if ((!isDelete || isAdd) && (kind = this.myRoot.checkNodeKind(absPath)) != SVNNodeKind.DIR && kind != SVNNodeKind.FILE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Filesystem path ''{0}'' is neither a file nor a directory", (Object)path);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            String copyFromPath = null;
            String realCopyFromPath = null;
            FSRoot srcRoot = this.myCompareRoot;
            String srcPath = srcRoot != null ? absPath : null;
            closeFile = false;
            if (isAdd) {
                CopyInfo info;
                String relCopyFromPath;
                FSRevisionRoot copyFromRoot = null;
                FSRevisionNode copyfromNode = this.myRoot.getRevisionNode(absPath);
                copyFromPath = copyfromNode.getCopyFromPath();
                long copyFromRevision = copyfromNode.getCopyFromRevision();
                if (copyFromPath != null && FSRepository.isValidRevision(copyFromRevision)) {
                    copyFromRoot = this.myOwner.createRevisionRoot(copyFromRevision);
                }
                realCopyFromPath = copyFromPath;
                if (!(copyFromPath == null || SVNPathUtil.isWithinBasePath(this.myBasePath, relCopyFromPath = copyFromPath.substring(1)) && this.myLowRevision <= copyFromRevision)) {
                    copyFromPath = null;
                    copyFromRevision = -1L;
                }
                if (kind == SVNNodeKind.DIR) {
                    if (realCopyFromPath != null && copyFromPath == null) {
                        this.addSubdirectory(copyFromRoot, this.myRoot, editor, realCopyFromPath, path);
                    } else {
                        editor.addDir(path, copyFromPath, copyFromRevision);
                    }
                    closeDir = true;
                } else {
                    editor.addFile(path, copyFromPath, copyFromRevision);
                    closeFile = true;
                }
                if (copyFromPath != null) {
                    if (kind == SVNNodeKind.DIR) {
                        info = new CopyInfo(path, copyFromPath, copyFromRevision);
                        this.myCopies.addLast(info);
                    }
                    srcRoot = copyFromRoot;
                    srcPath = copyFromPath;
                } else {
                    if (kind == SVNNodeKind.DIR && this.myCopies.size() > 0) {
                        info = new CopyInfo(path, null, -1L);
                        this.myCopies.addLast(info);
                    }
                    srcRoot = null;
                    srcPath = null;
                }
            } else if (!isDelete) {
                if (kind == SVNNodeKind.DIR) {
                    if ("".equals(path)) {
                        editor.openRoot(-1L);
                    } else {
                        editor.openDir(path, -1L);
                    }
                    closeDir = true;
                } else {
                    editor.openFile(path, -1L);
                    closeFile = true;
                }
                if (this.myCopies.size() > 0) {
                    CopyInfo info = (CopyInfo)this.myCopies.getLast();
                    if (info.myCopyFromPath != null) {
                        srcRoot = this.myOwner.createRevisionRoot(info.myCopyFromRevision);
                        srcPath = SVNPathUtil.append(info.myCopyFromPath, SVNPathUtil.getPathAsChild(info.myPath, path));
                    } else {
                        srcRoot = null;
                        srcPath = null;
                    }
                }
            }
            if (!isDelete || isAdd) {
                FSRevisionNode node;
                if (change.arePropertiesModified()) {
                    if (this.myCompareRoot != null) {
                        SVNProperties oldProps = null;
                        if (srcRoot != null) {
                            FSRevisionNode srcNode = srcRoot.getRevisionNode(srcPath);
                            oldProps = srcNode.getProperties(this.myOwner);
                        }
                        node = this.myRoot.getRevisionNode(absPath);
                        SVNProperties newProps = node.getProperties(this.myOwner);
                        SVNProperties propDiff = FSRepositoryUtil.getPropsDiffs(oldProps, newProps);
                        for (String propName : propDiff.nameSet()) {
                            SVNPropertyValue propValue = propDiff.getSVNPropertyValue(propName);
                            if (kind == SVNNodeKind.DIR) {
                                editor.changeDirProperty(propName, propValue);
                                continue;
                            }
                            if (kind != SVNNodeKind.FILE) continue;
                            editor.changeFileProperty(path, propName, propValue);
                        }
                    } else if (kind == SVNNodeKind.DIR) {
                        editor.changeDirProperty("", null);
                    } else if (kind == SVNNodeKind.FILE) {
                        editor.changeFileProperty(path, "", null);
                    }
                }
                if (kind == SVNNodeKind.FILE && (change.isTextModified() || realCopyFromPath != null && copyFromPath == null)) {
                    String checksum = null;
                    if (this.myCompareRoot != null && srcRoot != null && srcPath != null) {
                        node = srcRoot.getRevisionNode(srcPath);
                        checksum = node.getFileMD5Checksum();
                    }
                    editor.applyTextDelta(path, checksum);
                    if (this.myCompareRoot != null) {
                        InputStream sourceStream = null;
                        InputStream targetStream = null;
                        try {
                            sourceStream = srcRoot != null && srcPath != null ? srcRoot.getFileStreamForPath(this.myDeltaCombiner, srcPath) : SVNFileUtil.DUMMY_IN;
                            targetStream = this.myRoot.getFileStreamForPath(this.myDeltaCombiner, absPath);
                            this.myDeltaGenerator.sendDelta(path, sourceStream, 0L, targetStream, editor, false);
                            Object var22_24 = null;
                        }
                        catch (Throwable throwable) {
                            Object var22_25 = null;
                            SVNFileUtil.closeFile(sourceStream);
                            SVNFileUtil.closeFile(targetStream);
                            throw throwable;
                        }
                        SVNFileUtil.closeFile(sourceStream);
                        SVNFileUtil.closeFile(targetStream);
                        {
                            break block45;
                        }
                    }
                    editor.textDeltaEnd(path);
                }
            }
        }
        if (closeFile) {
            FSRevisionNode node = this.myRoot.getRevisionNode(absPath);
            editor.closeFile(path, node.getFileMD5Checksum());
        }
        return closeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubdirectory(FSRoot srcRoot, FSRoot tgtRoot, ISVNEditor editor, String srcPath, String path) throws SVNException {
        editor.addDir(path, null, -1L);
        FSRevisionNode node = srcRoot.getRevisionNode(srcPath);
        SVNProperties props = node.getProperties(this.myOwner);
        for (String propName : props.nameSet()) {
            SVNPropertyValue propValue = props.getSVNPropertyValue(propName);
            editor.changeDirProperty(propName, propValue);
        }
        Map entries = node.getDirEntries(this.myOwner);
        for (String entryName : entries.keySet()) {
            Object var19_18;
            FSEntry entry = (FSEntry)entries.get(entryName);
            String newPath = SVNPathUtil.append(path, entry.getName());
            if (entry.getType() == SVNNodeKind.DIR) {
                this.addSubdirectory(srcRoot, tgtRoot, editor, SVNPathUtil.append(srcPath, entry.getName()), newPath);
                editor.closeDir();
                continue;
            }
            if (entry.getType() != SVNNodeKind.FILE) continue;
            editor.addFile(SVNPathUtil.append(path, entry.getName()), null, -1L);
            String newSrcPath = SVNPathUtil.append(srcPath, entry.getName());
            FSRevisionNode srcNode = srcRoot.getRevisionNode(newSrcPath);
            props = srcNode.getProperties(this.myOwner);
            for (String propName : props.nameSet()) {
                SVNPropertyValue propValue = props.getSVNPropertyValue(propName);
                editor.changeFileProperty(newPath, propName, propValue);
            }
            editor.applyTextDelta(newPath, null);
            InputStream targetStream = null;
            try {
                targetStream = srcRoot.getFileStreamForPath(this.myDeltaCombiner, newSrcPath);
                this.myDeltaGenerator.sendDelta(newPath, SVNFileUtil.DUMMY_IN, 0L, targetStream, editor, false);
                var19_18 = null;
            }
            catch (Throwable throwable) {
                var19_18 = null;
                SVNFileUtil.closeFile(targetStream);
                throw throwable;
            }
            SVNFileUtil.closeFile(targetStream);
            String checksum = srcNode.getFileMD5Checksum();
            editor.closeFile(newPath, checksum);
        }
    }

    private class CopyInfo {
        String myCopyFromPath;
        long myCopyFromRevision;
        String myPath;

        public CopyInfo(String path, String copyFromPath, long copyFromRevision) {
            this.myPath = path;
            this.myCopyFromPath = copyFromPath;
            this.myCopyFromRevision = copyFromRevision;
        }
    }
}

