/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.AutoHideBorderLayout;
import com.vlsolutions.swing.docking.AutoHideButton;
import com.vlsolutions.swing.docking.AutoHideExpandPanel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class AutoHideButtonPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BORDERZONE = "borderzone";
    public static final String uiClassID = "AutoHideButtonPanelUI";
    private int border;
    private ButtonHighlighter buttonHighlighter = new ButtonHighlighter();
    private AutoHideExpandPanel expandPanel;

    public AutoHideButtonPanel(AutoHideExpandPanel expandPanel, int border) {
        this.border = border;
        this.expandPanel = expandPanel;
        boolean isHorizontal = border == 0 || border == 2;
        this.setLayout(new AutoHideBorderLayout(isHorizontal));
        this.firePropertyChange(PROPERTY_BORDERZONE, -1, border);
    }

    public int getVisibleButtonCount() {
        Component[] comps = this.getComponents();
        int count = 0;
        int i = 0;
        while (i < comps.length) {
            if (comps[i].isVisible()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getBorderZone() {
        return this.border;
    }

    public void add(AutoHideButton btn) {
        this.add((Component)btn);
        btn.addMouseListener(this.buttonHighlighter);
        btn.addMouseListener(this.expandPanel.getControler());
    }

    public void remove(AutoHideButton btn) {
        super.remove(btn);
        btn.removeMouseListener(this.buttonHighlighter);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    private class ButtonHighlighter
    extends MouseAdapter {
        private ButtonHighlighter() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AutoHideButton btn = (AutoHideButton)e.getSource();
            if (!btn.isSelected()) {
                btn.setHighlighted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AutoHideButton btn = (AutoHideButton)e.getSource();
            if (!btn.isSelected()) {
                btn.setHighlighted(false);
            }
        }
    }
}

