/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.omegat.core.Core;

public abstract class Cyclotis {
    protected String name = "";
    protected String providerName = "Silvestris Cyclotis";
    private PrintStream logDest = System.err;
    private String logList;
    private ScriptEngine scriptEngine = null;

    public Cyclotis(Properties propList) {
        if (propList.getProperty("provider.name") != null) {
            this.providerName = propList.getProperty("provider.name");
        }
        this.name = propList.getProperty("name");
        if (propList.getProperty("log.file") != null) {
            try {
                String fileName = propList.getProperty("log.file");
                if (fileName.equals(null)) {
                    this.logDest = null;
                } else {
                    if (!fileName.startsWith("/")) {
                        fileName = Core.getProject().getProjectProperties().getProjectRoot() + File.separator + fileName;
                    }
                    this.logDest = new PrintStream(new FileOutputStream(fileName));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (propList.getProperty("text.get.script") != null || propList.getProperty("text.put.script") != null) {
            ScriptEngineManager manager = new ScriptEngineManager(Cyclotis.class.getClassLoader());
            this.scriptEngine = manager.getEngineByName("javascript");
            String script = propList.getProperty("text.get.script");
            if (script != null) {
                try {
                    this.scriptEngine.eval("function pre(text) { " + script + " }");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.scriptEngine.eval("function pre(text) { return text; }");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            script = propList.getProperty("text.put.script");
            if (script != null) {
                try {
                    this.scriptEngine.eval("function post(text) { " + script + " }");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.scriptEngine.eval("function post(text) { return text; }");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.logList = propList.getProperty("log.list");
        if (this.logList == null) {
            this.logList = "";
        }
    }

    protected String reformatText(String text, boolean input) {
        if (this.scriptEngine == null) {
            return text;
        }
        String function = input ? "pre" : "post";
        try {
            Invocable inv = (Invocable)((Object)this.scriptEngine);
            Object eval = inv.invokeFunction(function, text);
            this.logMessage("javascript", function + "(" + text + ") evaluated as " + eval);
            if (eval == null) {
                return text;
            }
            return eval.toString();
        }
        catch (Exception e) {
            this.logMessage("javascript", function + "(" + text + ") not evaluated : " + e);
            return text;
        }
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getMemoryName() {
        return this.name;
    }

    public void logMessage(String condition, String message) {
        if (this.logDest == null) {
            return;
        }
        if (!this.logList.contains(condition)) {
            return;
        }
        message = System.currentTimeMillis() + " - " + message;
        if (this.logDest == System.err) {
            message = "[" + this.name + "] " + message;
        }
        this.logDest.println(message);
    }
}

