/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.omegat.util.Log;
import org.omegat.util.WikiGet;
import org.silvestrislab.cyclotis.omegat.Cyclotis;
import org.silvestrislab.cyclotis.omegat.http.FormatFactory;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;

public abstract class HttpCyclotis<T>
extends Cyclotis {
    private static final Pattern PATTERN_KEY_VAL = Pattern.compile("^;\\s+([\\w\\-]+):\\s+(.+)\\r?\\n");
    public static final int COL_SRC = 0;
    public static final int COL_TRA = 1;
    protected String urlFind;
    protected String urlSave;
    private Map<String, String> headers = null;
    public SimpleDateFormat PSQL_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    public HttpCyclotis(Properties propList) {
        super(propList);
        if (propList.getProperty("dateFormat") != null) {
            String[] dateFormat = propList.getProperty("dateFormat").split(":");
            this.PSQL_DATE = new SimpleDateFormat(dateFormat[1], new Locale(dateFormat[0]));
        }
        for (String propName : propList.stringPropertyNames()) {
            if (propName.startsWith("header.")) {
                if (this.headers == null) {
                    this.headers = new HashMap<String, String>();
                }
                this.headers.put(propName.substring(7), propList.getProperty(propName));
                continue;
            }
            if (propName.equals("http.auth.user")) {
                try {
                    if (this.headers == null) {
                        this.headers = new HashMap<String, String>();
                    }
                    String code = propList.getProperty("http.auth.user") + ":" + propList.getProperty("http.auth.password");
                    this.headers.put("Authorization", "Basic " + DatatypeConverter.printBase64Binary((byte[])code.getBytes("UTF-8")));
                }
                catch (Exception code) {}
                continue;
            }
            if (!propName.startsWith("http.proxy")) continue;
            System.setProperty(propName, propList.getProperty(propName));
        }
        try {
            String url = propList.getProperty("url");
            Log.log((String)("Parsing Contents from " + url));
            String response = WikiGet.get((String)url, null, this.headers);
            url = url.substring(0, url.lastIndexOf("/"));
            StringTokenizer tokLines = new StringTokenizer(response, "\n");
            while (tokLines.hasMoreTokens()) {
                String line = tokLines.nextToken();
                Matcher match = PATTERN_KEY_VAL.matcher(line);
                if (!match.find()) continue;
                propList.setProperty(match.group(1), match.group(2));
                this.logMessage("config-details", "Read property '" + match.group(1) + "' as '" + match.group(2) + "'");
            }
            System.err.println("Connection to " + this.name + " as " + url + " OK.");
        }
        catch (Exception e) {
            Log.log((String)e.getMessage());
            e.printStackTrace();
        }
        this.urlFind = propList.getProperty("url.find");
        this.urlSave = propList.getProperty("url.save");
        if (this.urlFind == null) {
            this.urlFind = propList.getProperty("find-url");
        }
        this.urlFind = this.urlFind.replace(":fmt", "line").replace("(", "").replace(")?", "");
        if (this.urlSave == null) {
            this.urlSave = propList.getProperty("save-url");
        }
        this.urlSave = this.urlSave.replace(":fmt", "line").replace("(", "").replace(")?", "");
        this.logMessage("config", "URL for find : " + this.urlFind);
        this.logMessage("config", "URL for save : " + this.urlSave);
        this.logMessage("", "Connection to " + this.name + " as " + this.urlFind + " OK.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> httpGet(String command, String lineFormat, String query) throws Exception {
        String url = this.urlFind.replace(":cmd", command) + (this.urlFind.contains("?") ? (char)'&' : '?') + "cols=" + lineFormat + "&query=" + URLEncoder.encode(query, "UTF-8");
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            conn.setRequestMethod("GET");
            if (this.headers != null) {
                for (Map.Entry<String, String> en : this.headers.entrySet()) {
                    conn.setRequestProperty(en.getKey(), en.getValue());
                }
            }
            conn.setDoOutput(true);
            if (conn.getResponseCode() != 200) {
                throw new WikiGet.ResponseError(conn);
            }
            String contentType = conn.getHeaderField("Content-Type");
            int cp = contentType != null ? contentType.indexOf("charset=") : -1;
            String charset = cp >= 0 ? contentType.substring(cp + 8) : "ISO8859-1";
            ByteArrayOutputStream res = new ByteArrayOutputStream();
            InputStream in = conn.getInputStream();
            HttpOutputFormat fmt = new FormatFactory().createFormat(contentType);
            List theList = fmt.readFromGet(this, in, charset);
            this.logMessage("search", "returned " + theList.size() + " entries");
            List list = theList;
            return list;
        }
        finally {
            conn.disconnect();
        }
    }

    public abstract T analyzeLine(String[] var1);

    public void registerTranslation(T entryContents) throws Exception {
        String line;
        URL httpUrl = new URL(this.urlSave);
        HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("charset", "utf-8");
        String args = this.encodeArgs(entryContents);
        connection.setRequestProperty("Content-Length", "" + args.getBytes("UTF-8").length);
        connection.setUseCaches(false);
        OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
        wr.write(args);
        wr.flush();
        wr.close();
        BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = rd.readLine()) != null) {
            if (!line.startsWith(";")) continue;
            int index = line.indexOf("ERROR");
            if (index > 0) {
                Log.log((String)line.substring(index + 6));
                throw new Exception(this.getProviderName() + " / " + this.getMemoryName() + ": " + line.substring(index + 6));
            }
            index = line.indexOf("FAIL");
            if (index <= 0) continue;
            Log.log((String)line.substring(index + 5));
            throw new Exception(this.getProviderName() + " / " + this.getMemoryName() + ": " + line.substring(index + 5));
        }
        connection.disconnect();
    }

    protected abstract String encodeArgs(T var1) throws Exception;

    public static String encodeArg(String name, String value) throws UnsupportedEncodingException {
        return name + "=" + URLEncoder.encode(value, "UTF-8");
    }
}

