/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.bitext;

import java.io.IOException;
import java.util.Iterator;
import org.languagetool.bitext.StringPair;
import org.languagetool.bitext.TabBitextReader;

public class WordFastTMReader
extends TabBitextReader {
    public WordFastTMReader(String filename, String encoding) throws IOException {
        super(filename, encoding);
        if (this.nextLine != null) {
            this.nextLine = this.in.readLine();
            this.nextPair = this.tab2StringPair(this.nextLine);
        }
    }

    @Override
    public final StringPair tab2StringPair(String line) {
        if (line == null) {
            return null;
        }
        String[] fields = line.split("\t");
        this.sentencePos = fields[4].length() + 1;
        return new StringPair(fields[4], fields[6]);
    }

    @Override
    public Iterator<StringPair> iterator() {
        return new TabReader();
    }

    class TabReader
    implements Iterator<StringPair> {
        TabReader() {
        }

        @Override
        public boolean hasNext() {
            return WordFastTMReader.this.nextLine != null;
        }

        @Override
        public StringPair next() {
            try {
                StringPair result = WordFastTMReader.this.nextPair;
                if (WordFastTMReader.this.nextLine != null) {
                    WordFastTMReader.this.nextLine = WordFastTMReader.this.in.readLine();
                    WordFastTMReader.this.nextPair = WordFastTMReader.this.tab2StringPair(WordFastTMReader.this.nextLine);
                    if (WordFastTMReader.this.nextLine == null) {
                        WordFastTMReader.this.in.close();
                    }
                }
                return result;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

