/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public abstract class AbstractCompoundRule
extends Rule {
    private static final int MAX_TERMS = 5;
    private final Set<String> incorrectCompounds = new HashSet<String>();
    private final Set<String> noDashSuggestion = new HashSet<String>();
    private final Set<String> onlyDashSuggestion = new HashSet<String>();
    private final String withHyphenMessage;
    private final String withoutHyphenMessage;
    private final String withOrWithoutHyphenMessage;
    private String shortDesc;
    private boolean hyphenIgnored = true;

    public AbstractCompoundRule(ResourceBundle messages, String fileName, String withHyphenMessage, String withoutHyphenMessage, String withOrWithoutHyphenMessage) throws IOException {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.loadCompoundFile(JLanguageTool.getDataBroker().getFromResourceDirAsStream(fileName), "UTF-8");
        this.withHyphenMessage = withHyphenMessage;
        this.withoutHyphenMessage = withoutHyphenMessage;
        this.withOrWithoutHyphenMessage = withOrWithoutHyphenMessage;
        this.setLocQualityIssueType("misspelling");
    }

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    public void setShort(String shortDescription) {
        this.shortDesc = shortDescription;
    }

    public boolean isHyphenIgnored() {
        return this.hyphenIgnored;
    }

    public void setHyphenIgnored(boolean ignoreHyphen) {
        this.hyphenIgnored = ignoreHyphen;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        RuleMatch prevRuleMatch = null;
        ArrayBlockingQueue<AnalyzedTokenReadings> prevTokens = new ArrayBlockingQueue<AnalyzedTokenReadings>(5);
        for (int i = 0; i < tokens.length + 5 - 1; ++i) {
            AnalyzedTokenReadings token = i >= tokens.length ? new AnalyzedTokenReadings(new AnalyzedToken("", "", null), ((AnalyzedTokenReadings)prevTokens.peek()).getStartPos()) : tokens[i];
            if (i == 0) {
                this.addToQueue(token, prevTokens);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            int j = 0;
            AnalyzedTokenReadings firstMatchToken = null;
            ArrayList<String> stringsToCheck = new ArrayList<String>();
            ArrayList<String> origStringsToCheck = new ArrayList<String>();
            HashMap<String, AnalyzedTokenReadings> stringToToken = new HashMap<String, AnalyzedTokenReadings>();
            for (AnalyzedTokenReadings atr : prevTokens) {
                if (j == 0) {
                    firstMatchToken = atr;
                }
                sb.append(' ');
                sb.append(atr.getToken());
                if (j >= 1) {
                    String stringToCheck = this.normalize(sb.toString());
                    stringsToCheck.add(stringToCheck);
                    origStringsToCheck.add(sb.toString().trim());
                    if (!stringToToken.containsKey(stringToCheck)) {
                        stringToToken.put(stringToCheck, atr);
                    }
                }
                ++j;
            }
            for (int k = stringsToCheck.size() - 1; k >= 0; --k) {
                String[] parts;
                String stringToCheck = (String)stringsToCheck.get(k);
                String origStringToCheck = (String)origStringsToCheck.get(k);
                if (!this.incorrectCompounds.contains(stringToCheck)) continue;
                AnalyzedTokenReadings atr = (AnalyzedTokenReadings)stringToToken.get(stringToCheck);
                String msg = null;
                ArrayList<String> replacement = new ArrayList<String>();
                if (!this.noDashSuggestion.contains(stringToCheck)) {
                    replacement.add(origStringToCheck.replace(' ', '-'));
                    msg = this.withHyphenMessage;
                }
                if (!this.hasAllUppercaseParts(origStringToCheck) && !this.onlyDashSuggestion.contains(stringToCheck)) {
                    replacement.add(this.mergeCompound(origStringToCheck));
                    msg = this.withoutHyphenMessage;
                }
                if ((parts = stringToCheck.split(" ")).length > 0 && parts[0].length() == 1) {
                    replacement.clear();
                    replacement.add(origStringToCheck.replace(' ', '-'));
                    msg = this.withHyphenMessage;
                } else if (replacement.isEmpty() || replacement.size() == 2) {
                    msg = this.withOrWithoutHyphenMessage;
                }
                RuleMatch ruleMatch = new RuleMatch(this, firstMatchToken.getStartPos(), atr.getStartPos() + atr.getToken().length(), msg, this.shortDesc);
                if (prevRuleMatch != null && prevRuleMatch.getFromPos() == ruleMatch.getFromPos()) {
                    prevRuleMatch = ruleMatch;
                    break;
                }
                prevRuleMatch = ruleMatch;
                ruleMatch.setSuggestedReplacements(replacement);
                ruleMatches.add(ruleMatch);
                break;
            }
            this.addToQueue(token, prevTokens);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private String normalize(String inStr) {
        String str = inStr.trim().toLowerCase();
        if (str.indexOf(45) != -1 && str.indexOf(32) != -1) {
            str = this.isHyphenIgnored() ? str.replace('-', ' ') : str.replace(" - ", " ");
        }
        return str;
    }

    private boolean hasAllUppercaseParts(String str) {
        String[] parts;
        for (String part : parts = str.split(" ")) {
            if (!this.isHyphenIgnored() && "-".equals(part) || !StringTools.isAllUppercase(part)) continue;
            return true;
        }
        return false;
    }

    private int countParts(String str) {
        return str.split(" ").length;
    }

    private String mergeCompound(String str) {
        String[] stringParts = str.split(" ");
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < stringParts.length; ++k) {
            if (!this.isHyphenIgnored() && "-".equals(stringParts[k])) continue;
            if (k == 0) {
                sb.append(stringParts[k]);
                continue;
            }
            sb.append(stringParts[k].toLowerCase());
        }
        return sb.toString();
    }

    private void addToQueue(AnalyzedTokenReadings token, Queue<AnalyzedTokenReadings> prevTokens) {
        boolean inserted = prevTokens.offer(token);
        if (!inserted) {
            prevTokens.poll();
            prevTokens.offer(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCompoundFile(InputStream file, String encoding) throws IOException {
        Scanner scanner = new Scanner(file, encoding);
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.length() < 1 || line.charAt(0) == '#') continue;
                String[] parts = (line = line.replace('-', ' ')).split(" ");
                if (parts.length > 5) {
                    throw new IOException("Too many compound parts: " + line + ", maximum allowed: " + 5);
                }
                if (parts.length == 1) {
                    throw new IOException("Not a compound: " + line);
                }
                if (line.endsWith("+")) {
                    line = this.removeLastCharacter(line);
                    this.noDashSuggestion.add(line.toLowerCase());
                } else if (line.endsWith("*")) {
                    line = this.removeLastCharacter(line);
                    this.onlyDashSuggestion.add(line.toLowerCase());
                }
                this.incorrectCompounds.add(line.toLowerCase());
            }
        }
        finally {
            scanner.close();
        }
    }

    private String removeLastCharacter(String str) {
        return str.substring(0, str.length() - 1);
    }

    @Override
    public void reset() {
    }
}

