/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class CommaWhitespaceRule
extends Rule {
    public CommaWhitespaceRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_misc")));
        this.setLocQualityIssueType("typographical");
    }

    @Override
    public final String getId() {
        return "COMMA_PARENTHESIS_WHITESPACE";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_comma_whitespace");
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokens();
        String prevToken = "";
        String prevPrevToken = "";
        boolean prevWhite = false;
        int prevLen = 0;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            boolean isWhitespace = tokens[i].isWhitespace() || StringTools.isNonBreakingWhitespace(token) || tokens[i].isFieldCode();
            String msg = null;
            int fixLen = 0;
            String suggestionText = null;
            if (isWhitespace && CommaWhitespaceRule.isLeftBracket(prevToken)) {
                msg = this.messages.getString("no_space_after");
                suggestionText = prevToken;
                fixLen = 1;
            } else if (!isWhitespace && prevToken.equals(",") && CommaWhitespaceRule.isNotQuoteOrHyphen(token) && CommaWhitespaceRule.containsNoNumber(prevPrevToken) && CommaWhitespaceRule.containsNoNumber(token) && !",".equals(prevPrevToken)) {
                msg = this.messages.getString("missing_space_after_comma");
                suggestionText = ", ";
            } else if (prevWhite) {
                if (CommaWhitespaceRule.isRightBracket(token)) {
                    msg = this.messages.getString("no_space_before");
                    suggestionText = token;
                    fixLen = 1;
                } else if (token.equals(",")) {
                    msg = this.messages.getString("space_after_comma");
                    suggestionText = ",";
                    fixLen = 1;
                    if (i + 1 < tokens.length && ",".equals(tokens[i + 1].getToken())) {
                        msg = null;
                    }
                } else if (token.equals(".")) {
                    msg = this.messages.getString("no_space_before_dot");
                    suggestionText = ".";
                    fixLen = 1;
                    if (i + 1 < tokens.length && CommaWhitespaceRule.isNumberOrDot(tokens[i + 1].getToken())) {
                        msg = null;
                    }
                }
            }
            if (msg != null) {
                int fromPos = tokens[i - 1].getStartPos();
                int toPos = tokens[i - 1].getStartPos() + fixLen + prevLen;
                RuleMatch ruleMatch = new RuleMatch(this, fromPos, toPos, msg);
                ruleMatch.setSuggestedReplacement(suggestionText);
                ruleMatches.add(ruleMatch);
            }
            prevPrevToken = prevToken;
            prevToken = token;
            prevWhite = isWhitespace && !tokens[i].isFieldCode();
            prevLen = tokens[i].getToken().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    static boolean isNotQuoteOrHyphen(String str) {
        if (str.length() == 1) {
            char c = str.charAt(0);
            return c != '\'' && c != '-' && c != '\u201d' && c != '\u2019' && c != '\"' && c != '\u201c' && c != ',';
        }
        return CommaWhitespaceRule.containsNoNumber(str);
    }

    static boolean isNumberOrDot(String str) {
        char c = str.charAt(0);
        return c == '.' || Character.isDigit(c);
    }

    static boolean isLeftBracket(String str) {
        if (str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        return c == '(' || c == '[' || c == '{';
    }

    static boolean isRightBracket(String str) {
        if (str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        return c == ')' || c == ']' || c == '}';
    }

    static boolean containsNoNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
    }
}

