/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffSource;

public class SvnCopyAsChangedDiffCallback
implements ISvnDiffCallback2 {
    private final ISvnDiffCallback2 delegate;

    public SvnCopyAsChangedDiffCallback(ISvnDiffCallback2 delegate) {
        this.delegate = delegate;
    }

    public void fileOpened(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, SvnDiffSource copyFromSource, boolean createDirBaton, Object dirBaton) throws SVNException {
        if (leftSource == null && copyFromSource != null) {
            assert (rightSource != null);
            leftSource = copyFromSource;
            copyFromSource = null;
        }
        this.delegate.fileOpened(result, relPath, leftSource, rightSource, copyFromSource, createDirBaton, dirBaton);
    }

    public void fileChanged(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, File leftFile, File rightFile, SVNProperties leftProps, SVNProperties rightProps, boolean fileModified, SVNProperties propChanges) throws SVNException {
        this.delegate.fileChanged(result, relPath, leftSource, rightSource, leftFile, rightFile, leftProps, rightProps, fileModified, propChanges);
    }

    public void fileAdded(SvnDiffCallbackResult result, File relPath, SvnDiffSource copyFromSource, SvnDiffSource rightSource, File copyFromFile, File rightFile, SVNProperties copyFromProps, SVNProperties rightProps) throws SVNException {
        if (copyFromSource != null) {
            SVNProperties propChanges = rightProps.compareTo(copyFromProps);
            boolean same = copyFromFile != null && rightFile != null ? SVNFileUtil.compareFiles(copyFromFile, rightFile, null) : false;
            this.delegate.fileChanged(result, relPath, copyFromSource, rightSource, copyFromFile, rightFile, copyFromProps, rightProps, !same, propChanges);
        } else {
            this.delegate.fileAdded(result, relPath, copyFromSource, rightSource, copyFromFile, rightFile, copyFromProps, rightProps);
        }
    }

    public void fileDeleted(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, File leftFile, SVNProperties leftProps) throws SVNException {
        this.delegate.fileDeleted(result, relPath, leftSource, leftFile, leftProps);
    }

    public void fileClosed(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource) throws SVNException {
        this.delegate.fileClosed(result, relPath, leftSource, rightSource);
    }

    public void dirOpened(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, SvnDiffSource copyFromSource, Object dirBaton) throws SVNException {
        if (leftSource == null && copyFromSource != null) {
            assert (rightSource != null);
            leftSource = copyFromSource;
            copyFromSource = null;
        }
        this.delegate.dirOpened(result, relPath, leftSource, rightSource, copyFromSource, dirBaton);
    }

    public void dirChanged(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, SVNProperties leftProps, SVNProperties rightProps, SVNProperties propChanges, Object dirBaton) throws SVNException {
        this.delegate.dirChanged(result, relPath, leftSource, rightSource, leftProps, rightProps, propChanges, dirBaton);
    }

    public void dirDeleted(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SVNProperties leftProps, Object dirBaton) throws SVNException {
        this.delegate.dirDeleted(result, relPath, leftSource, leftProps, dirBaton);
    }

    public void dirAdded(SvnDiffCallbackResult result, File relPath, SvnDiffSource copyFromSource, SvnDiffSource rightSource, SVNProperties copyFromProps, SVNProperties rightProps, Object dirBaton) throws SVNException {
        if (copyFromSource != null) {
            SVNProperties propChanges = rightProps.compareTo(copyFromProps);
            this.delegate.dirChanged(result, relPath, copyFromSource, rightSource, copyFromProps, rightProps, propChanges, dirBaton);
        } else {
            this.delegate.dirAdded(result, relPath, copyFromSource, rightSource, copyFromProps, rightProps, dirBaton);
        }
    }

    public void dirClosed(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, Object dirBaton) throws SVNException {
        this.delegate.dirClosed(result, relPath, leftSource, rightSource, dirBaton);
    }

    public void nodeAbsent(SvnDiffCallbackResult result, File relPath, Object dirBaton) throws SVNException {
        this.delegate.nodeAbsent(result, relPath, dirBaton);
    }
}

