/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.event;

import org.dts.spell.ErrorInfo;
import org.dts.spell.event.SpellCheckAdapter;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;

public class FindSpellCheckErrorListener
extends SpellCheckAdapter {
    private ErrorInfo errorInfo;

    public void beginChecking(SpellCheckEvent event) {
        this.errorInfo = null;
    }

    public void spellingError(SpellCheckEvent event) {
        this.createError(ErrorInfo.getSpellingErrorInfo(event), event);
    }

    public void badCaseError(SpellCheckEvent event) {
        this.createError(ErrorInfo.getBadCaseErrorInfo(event), event);
    }

    public void repeatWordError(SpellCheckEvent event) {
        this.createError(ErrorInfo.getRepeatWordErrorInfo(event), event);
    }

    public Word getInvalidWord() {
        if (null != this.errorInfo) {
            return this.errorInfo.getBadWord();
        }
        return null;
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public boolean hasError() {
        return this.errorInfo != null;
    }

    private void createError(ErrorInfo info, SpellCheckEvent event) {
        this.errorInfo = info;
        event.cancel();
    }
}

