/*
 * Decompiled with CFR 0.152.
 */
package org.omegat;

import java.util.Locale;

public class CLIParameters {
    public static final String HELP_SHORT = "-h";
    public static final String HELP = "--help";
    public static final String MODE = "mode";
    public static final String CONFIG_FILE = "config-file";
    public static final String RESOURCE_BUNDLE = "resource-bundle";
    public static final String CONFIG_DIR = "config-dir";
    public static final String DISABLE_PROJECT_LOCKING = "disable-project-locking";
    public static final String DISABLE_LOCATION_SAVE = "disable-location-save";
    public static final String NO_TEAM = "no-team";
    public static final String TOKENIZER_SOURCE = "ITokenizer";
    public static final String TOKENIZER_TARGET = "ITokenizerTarget";
    public static final String TOKENIZER_BEHAVIOR_SOURCE = "ITokenizerBehavior";
    public static final String TOKENIZER_BEHAVIOR_TARGET = "ITokenizerTargetBehavior";
    public static final String ALTERNATE_FILENAME_FROM = "alternate-filename-from";
    public static final String ALTERNATE_FILENAME_TO = "alternate-filename-to";
    public static final String QUIET = "quiet";
    public static final String SCRIPT = "script";
    public static final String TAG_VALIDATION = "tag-validation";
    public static final String SOURCE_PATTERN = "source-pattern";
    public static final String PSEUDOTRANSLATETMX = "pseudotranslatetmx";
    public static final String PSEUDOTRANSLATETYPE = "pseudotranslatetype";
    public static final String ALIGNDIR = "alignDir";

    private static String normalize(String s) {
        return s.toUpperCase(Locale.ENGLISH).replace('-', '_');
    }

    public static enum TAG_VALIDATION_MODE {
        IGNORE,
        WARN,
        ABORT;


        public static TAG_VALIDATION_MODE parse(String s) {
            try {
                return TAG_VALIDATION_MODE.valueOf(CLIParameters.normalize(s));
            }
            catch (Exception ex) {
                return IGNORE;
            }
        }
    }

    public static enum PSEUDO_TRANSLATE_TYPE {
        EQUAL,
        EMPTY;


        public static PSEUDO_TRANSLATE_TYPE parse(String s) {
            try {
                return PSEUDO_TRANSLATE_TYPE.valueOf(CLIParameters.normalize(s));
            }
            catch (Exception ex) {
                return EQUAL;
            }
        }
    }

    static enum RUN_MODE {
        GUI,
        CONSOLE_TRANSLATE,
        CONSOLE_CREATEPSEUDOTRANSLATETMX,
        CONSOLE_ALIGN,
        CONSOLE_INDEXTMX;


        public static RUN_MODE parse(String s) {
            try {
                return RUN_MODE.valueOf(CLIParameters.normalize(s));
            }
            catch (Exception ex) {
                return GUI;
            }
        }
    }
}

