/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;

public class LingvoDSL
implements IDictionaryFactory {
    protected static final String CHARSET = "UTF-16";
    protected static final Pattern RE_SKIP = Pattern.compile("\\[.+?\\]");
    protected static final String[] EMPTY_RESULT = new String[0];

    @Override
    public boolean isSupportedFile(File file) {
        return file.getPath().endsWith(".dsl");
    }

    @Override
    public IDictionary loadDict(File file) throws Exception {
        return new LingvoDSLDict(LingvoDSL.loadData(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadData(File file) throws Exception {
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET));
        try {
            String s;
            HashMap<String, String> result = new HashMap<String, String>();
            StringBuilder word = new StringBuilder();
            StringBuilder trans = new StringBuilder();
            while ((s = rd.readLine()) != null) {
                if (s.isEmpty() || s.codePointAt(0) == 35) continue;
                if (Character.isWhitespace((s = RE_SKIP.matcher(s).replaceAll("")).codePointAt(0))) {
                    trans.append(s.trim()).append('\n');
                    continue;
                }
                if (word.length() > 0) {
                    result.put(word.toString(), trans.toString());
                    word.setLength(0);
                    trans.setLength(0);
                }
                word.append(s);
            }
            if (word.length() > 0) {
                result.put(word.toString(), trans.toString());
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            rd.close();
        }
    }

    static class LingvoDSLDict
    implements IDictionary {
        protected final Map<String, String> data;

        private LingvoDSLDict(Map<String, String> data) throws Exception {
            this.data = data;
        }

        @Override
        public List<DictionaryEntry> readArticles(String word) throws Exception {
            String article = this.data.get(word);
            if (article == null) {
                return Collections.emptyList();
            }
            DictionaryEntry entry = new DictionaryEntry(word, article);
            ArrayList<DictionaryEntry> result = new ArrayList<DictionaryEntry>();
            result.add(entry);
            return result;
        }
    }
}

