/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.JCheckBoxMenuItem;
import org.omegat.core.Core;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public abstract class BaseTranslate
implements IMachineTranslation,
ActionListener {
    protected final JCheckBoxMenuItem menuItem;
    protected boolean enabled;
    private final Map<String, String> cache = Collections.synchronizedMap(new HashMap());

    public BaseTranslate() {
        this.menuItem = new JCheckBoxMenuItem();
        Mnemonics.setLocalizedText(this.menuItem, this.getName());
        this.menuItem.addActionListener(this);
        this.enabled = Preferences.isPreference(this.getPreferenceName());
        this.menuItem.setState(this.enabled);
        Core.getMainWindow().getMainMenu().getMachineTranslationMenu().add(this.menuItem);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.enabled = this.menuItem.isSelected();
        Preferences.setPreference(this.getPreferenceName(), this.enabled);
    }

    @Override
    public String getTranslation(Language sLang, Language tLang, String text) throws Exception {
        if (this.enabled) {
            return this.translate(sLang, tLang, text);
        }
        return null;
    }

    @Override
    public String getCachedTranslation(Language sLang, Language tLang, String text) {
        if (this.enabled) {
            return this.getFromCache(sLang, tLang, text);
        }
        return null;
    }

    protected abstract String getPreferenceName();

    protected abstract String translate(Language var1, Language var2, String var3) throws Exception;

    protected String cleanSpacesAroundTags(String machineText, String sourceText) {
        String replacement;
        String searchTag;
        Matcher tag = PatternConsts.OMEGAT_TAG_SPACE.matcher(machineText);
        while (tag.find()) {
            searchTag = tag.group();
            if (sourceText.indexOf(searchTag) != -1) continue;
            replacement = searchTag.substring(0, searchTag.length() - 1);
            machineText = machineText.replace(searchTag, replacement);
        }
        tag = PatternConsts.SPACE_OMEGAT_TAG.matcher(machineText);
        while (tag.find()) {
            searchTag = tag.group();
            if (sourceText.indexOf(searchTag) != -1) continue;
            replacement = searchTag.substring(1, searchTag.length());
            machineText = machineText.replace(searchTag, replacement);
        }
        return machineText;
    }

    protected String getFromCache(Language sLang, Language tLang, String text) {
        return this.cache.get(sLang + "/" + tLang + "/" + text);
    }

    protected String putToCache(Language sLang, Language tLang, String text, String result) {
        return this.cache.put(sLang + "/" + tLang + "/" + text, result);
    }
}

