/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.util.Language;

public class TextFileMemory
implements IBrowsableMemory,
IWritableExternalMemory {
    private File file;
    private List<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>();
    private boolean write;
    private static DateFormat WF_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd~hhmmss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextFileMemory(ProjectProperties props, File file, boolean extTmxLevel2, boolean useSlash) throws IOException {
        this.file = file;
        this.write = file.getPath().contains("write");
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
        BufferedReader in = new BufferedReader(reader);
        try {
            in.mark(1);
            int ch = in.read();
            if (ch != 65279) {
                in.reset();
            }
            String s = in.readLine();
            while (s != null) {
                String[] tokens;
                if (!s.startsWith("%") && (tokens = s.split("\t")).length >= 3 && tokens[0].length() != 0) {
                    PrepareTMXEntry entry = new PrepareTMXEntry();
                    entry.source = tokens[4].replace("&'9;", "\t");
                    entry.translation = tokens[6].replace("&'9;", "\t");
                    entry.creator = tokens[1];
                    try {
                        entry.creationDate = WF_DATE_FORMAT.parse(tokens[0]).getTime();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    entry.changeDate = Long.parseLong(tokens[2]);
                    this.entries.add(entry);
                }
                s = in.readLine();
            }
        }
        finally {
            in.close();
        }
    }

    public TextFileMemory(Properties prop) throws IOException {
        this(Core.getProject().getProjectProperties(), new File(prop.getProperty("file")), false, false);
        if (prop.getProperty("write") != null) {
            this.write = prop.getProperty("write").equalsIgnoreCase("true");
        }
    }

    @Override
    public String getMemoryName() {
        return this.file.getPath();
    }

    @Override
    public String getProviderName() {
        return this.file.getPath().substring(this.file.getPath().lastIndexOf(46) + 1) + " file";
    }

    @Override
    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) {
        return this.entries;
    }

    @Override
    public List<PrepareTMXEntry> getEntries() {
        return this.entries;
    }

    @Override
    public boolean isWriteMode() {
        return this.write;
    }

    @Override
    public boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        return true;
    }

    @Override
    public void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception {
        String encoding = "UTF-8";
        if (!this.file.exists()) {
            File parentFile = this.file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            this.file.createNewFile();
        } else if (TextFileMemory.isUTF16LE(this.file)) {
            encoding = "UTF-16LE";
        }
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), encoding);
        ((Writer)wr).append(WF_DATE_FORMAT.format(entryContents.creationDate)).append('\t');
        ((Writer)wr).append(entryContents.creator).append('\t');
        long version = 0L;
        for (PrepareTMXEntry pe : this.entries) {
            if (!pe.source.equals(entryContents.source) || version >= pe.changeDate) continue;
            version = pe.changeDate + 1L;
        }
        ((Writer)wr).append(Long.toString(version)).append('\t');
        ((Writer)wr).append(sLang.toString()).append('\t').append(entryContents.source).append('\t');
        ((Writer)wr).append(tLang.toString()).append('\t').append(entryContents.translation);
        ((Writer)wr).append(System.getProperty("line.separator"));
        ((Writer)wr).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUTF16LE(File file) throws IOException {
        FileInputStream stream = null;
        boolean ret = false;
        try {
            stream = new FileInputStream(file);
            byte[] bytes = new byte[2];
            if (stream.read(bytes, 0, 2) == 2 && bytes[0] == -1 && bytes[1] == -2) {
                ret = true;
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return ret;
    }
}

