/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.comments;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.gui.comments.ICommentProvider;
import org.omegat.gui.comments.IComments;
import org.omegat.gui.common.EntryInfoPane;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.gui.JTextPaneLinkifier;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIThreadsUtil;

public class CommentsTextArea
extends EntryInfoPane<SourceTextEntry>
implements IEntryEventListener,
IComments {
    private static final String EXPLANATION = OStrings.getString("GUI_COMMENTSWINDOW_explanation");
    private final List<ProviderStorage> providers = new ArrayList<ProviderStorage>();
    static final ICommentProvider ENTRY_COMMENT_PROVIDER = new ICommentProvider(){

        @Override
        public String getComment(SourceTextEntry newEntry) {
            StringBuilder text = new StringBuilder(1024);
            if (newEntry.getKey().id != null) {
                text.append(OStrings.getString("GUI_COMMENTSWINDOW_FIELD_ID"));
                text.append(' ');
                text.append(newEntry.getKey().id);
                text.append('\n');
            }
            if (newEntry.getKey().path != null) {
                text.append(OStrings.getString("GUI_COMMENTSWINDOW_FIELD_Path"));
                text.append(' ');
                text.append(newEntry.getKey().path);
                text.append('\n');
            }
            if (newEntry.getSourceTranslation() != null) {
                text.append(OStrings.getString("GUI_COMMENTSWINDOW_FIELD_Translation"));
                text.append(' ');
                text.append(newEntry.getSourceTranslation());
                text.append('\n');
            }
            if (newEntry.getComment() != null) {
                text.append(OStrings.getString("GUI_COMMENTSWINDOW_FIELD_Comment"));
                text.append('\n');
                text.append(newEntry.getComment());
                text.append('\n');
            }
            return text.toString();
        }
    };

    public CommentsTextArea(MainWindow mw) {
        super(true);
        String title = OStrings.getString("GUI_COMMENTSWINDOW_SUBWINDOWTITLE_Comments");
        mw.addDockable(new DockableScrollPane("COMMENTS", title, this, true));
        this.setEditable(false);
        StaticUIUtils.makeCaretAlwaysVisible(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        this.addCommentProvider(ENTRY_COMMENT_PROVIDER, 0);
        CoreEvents.registerEntryEventListener(this);
        JTextPaneLinkifier.linkify(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        ArrayList<ProviderStorage> list;
        UIThreadsUtil.mustBeSwingThread();
        List<ProviderStorage> list2 = this.providers;
        synchronized (list2) {
            list = new ArrayList<ProviderStorage>(this.providers);
        }
        StringBuilder text = new StringBuilder(1024);
        for (ProviderStorage ps : list) {
            String c = ps.provider.getComment(newEntry);
            if (c == null) continue;
            text.append(c);
        }
        this.setText(text.toString());
        this.setCaretPosition(0);
    }

    @Override
    public void onNewFile(String activeFileName) {
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommentProvider(ICommentProvider provider, int priority) {
        ProviderStorage s = new ProviderStorage();
        s.provider = provider;
        s.priority = priority;
        List<ProviderStorage> list = this.providers;
        synchronized (list) {
            this.providers.add(s);
            Collections.sort(this.providers, new Comparator<ProviderStorage>(){

                @Override
                public int compare(ProviderStorage o1, ProviderStorage o2) {
                    return o1.priority < o2.priority ? -1 : (o1.priority > o2.priority ? 1 : 0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCommentProvider(ICommentProvider provider) {
        List<ProviderStorage> list = this.providers;
        synchronized (list) {
            for (int i = 0; i < this.providers.size(); ++i) {
                if (this.providers.get((int)i).provider != provider) continue;
                this.providers.remove(i);
                break;
            }
        }
    }

    static class ProviderStorage {
        ICommentProvider provider;
        int priority;

        ProviderStorage() {
        }
    }
}

