/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class WorkflowOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JCheckBox allowTagEditing;
    private JCheckBox allowTranslationEqualToSource;
    private JButton cancelButton;
    private JCheckBox cbSaveAutoStatus;
    private JCheckBox convertNumbers;
    private JRadioButton defaultRadio;
    private JTextArea descriptionTextArea;
    private JCheckBox exportCurrentSegment;
    private JLabel initialSegCountLabel;
    private JSpinner initialSegCountSpinner;
    private JCheckBox insertFuzzyCheckBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton leaveEmptyRadio;
    private JButton okButton;
    private ButtonGroup ourButtonGroup;
    private JLabel prefixLabel;
    private JTextField prefixText;
    private JLabel similarityLabel;
    private JSpinner similaritySpinner;
    private JCheckBox stopOnAlternativeTranslation;
    private JCheckBox tagValidateOnLeave;
    private int returnStatus = 0;

    public WorkflowOptionsDialog(Frame parent) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.leaveEmptyRadio.setSelected(Preferences.isPreference("wf_noSourceText"));
        this.insertFuzzyCheckBox.setSelected(Preferences.isPreference("wf_insertBestMatch"));
        this.similarityLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.similaritySpinner.setValue(Preferences.getPreferenceDefault("wf_minimalSimilarity", 80));
        this.similaritySpinner.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.prefixLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        if (!Preferences.existsPreference("wf_explanatoryText")) {
            this.prefixText.setText(OStrings.getString("WF_DEFAULT_PREFIX"));
        } else {
            this.prefixText.setText(Preferences.getPreferenceDefaultAllowEmptyString("wf_explanatoryText"));
        }
        this.prefixText.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.allowTranslationEqualToSource.setSelected(Preferences.isPreference("wf_allowTransEqualToSrc"));
        this.exportCurrentSegment.setSelected(Preferences.isPreference("wf_exportCurrentSegment"));
        this.stopOnAlternativeTranslation.setSelected(Preferences.isPreference("wf_stopOnAlternativeTranslation"));
        this.convertNumbers.setSelected(Preferences.isPreference("wf_convertNumbers"));
        this.allowTagEditing.setSelected(Preferences.isPreference("allowTagEditing"));
        this.tagValidateOnLeave.setSelected(Preferences.isPreference("tagValidateOnLeave"));
        this.cbSaveAutoStatus.setSelected(Preferences.isPreference("save_auto_status"));
        this.initialSegCountSpinner.setValue(Preferences.getPreferenceDefault("editor_initial_segment_load_count", 2000));
        DockingUI.displayCentered(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.ourButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.descriptionTextArea = new JTextArea();
        this.defaultRadio = new JRadioButton();
        this.leaveEmptyRadio = new JRadioButton();
        this.insertFuzzyCheckBox = new JCheckBox();
        this.similarityLabel = new JLabel();
        this.similaritySpinner = new JSpinner();
        this.prefixLabel = new JLabel();
        this.prefixText = new JTextField();
        this.convertNumbers = new JCheckBox();
        this.allowTranslationEqualToSource = new JCheckBox();
        this.exportCurrentSegment = new JCheckBox();
        this.stopOnAlternativeTranslation = new JCheckBox();
        this.allowTagEditing = new JCheckBox();
        this.tagValidateOnLeave = new JCheckBox();
        this.cbSaveAutoStatus = new JCheckBox();
        this.initialSegCountLabel = new JLabel();
        this.initialSegCountSpinner = new JSpinner();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(OStrings.getString("GUI_TITLE_Workflow_Options"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WorkflowOptionsDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel1.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(new JLabel().getFont());
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(OStrings.getString("GUI_WORKFLOW_DESCRIPTION"));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.jPanel1.add((Component)this.descriptionTextArea, gridBagConstraints);
        this.ourButtonGroup.add(this.defaultRadio);
        this.defaultRadio.setSelected(true);
        Mnemonics.setLocalizedText(this.defaultRadio, OStrings.getString("WF_OPTION_INSERT_SOURCE"));
        this.defaultRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkflowOptionsDialog.this.radiosActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.jPanel1.add((Component)this.defaultRadio, gridBagConstraints);
        this.ourButtonGroup.add(this.leaveEmptyRadio);
        Mnemonics.setLocalizedText(this.leaveEmptyRadio, OStrings.getString("WF_OPTION_INSERT_NOTHTHING"));
        this.leaveEmptyRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.leaveEmptyRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkflowOptionsDialog.this.radiosActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.leaveEmptyRadio, gridBagConstraints);
        Mnemonics.setLocalizedText(this.insertFuzzyCheckBox, OStrings.getString("WF_OPTION_INSERT_FUZZY_MATCH"));
        this.insertFuzzyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkflowOptionsDialog.this.radiosActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.jPanel1.add((Component)this.insertFuzzyCheckBox, gridBagConstraints);
        this.similarityLabel.setLabelFor(this.similaritySpinner);
        Mnemonics.setLocalizedText(this.similarityLabel, OStrings.getString("GUI_WORKFLOW_OPTION_Minimal_Similarity"));
        this.similarityLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.jPanel1.add((Component)this.similarityLabel, gridBagConstraints);
        this.similaritySpinner.setEnabled(false);
        this.similaritySpinner.setValue(90);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.similaritySpinner, gridBagConstraints);
        this.prefixLabel.setLabelFor(this.prefixText);
        Mnemonics.setLocalizedText(this.prefixLabel, OStrings.getString("WF_OPTION_INSERT_FUZZY_PREFIX"));
        this.prefixLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.jPanel1.add((Component)this.prefixLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.prefixText, gridBagConstraints);
        Mnemonics.setLocalizedText(this.convertNumbers, OStrings.getString("WF_OPTION_CONVERT_NUMBERS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.jPanel1.add((Component)this.convertNumbers, gridBagConstraints);
        Mnemonics.setLocalizedText(this.allowTranslationEqualToSource, OStrings.getString("WF_OPTION_ALLOW_TRANS_EQ_TO_SRC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.allowTranslationEqualToSource, gridBagConstraints);
        Mnemonics.setLocalizedText(this.exportCurrentSegment, OStrings.getString("WF_OPTION_EXPORT__CURRENT_SEGMENT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.exportCurrentSegment, gridBagConstraints);
        Mnemonics.setLocalizedText(this.stopOnAlternativeTranslation, OStrings.getString("WF_OPTION_GOTO_NEXT_UNTRANSLATED"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.stopOnAlternativeTranslation, gridBagConstraints);
        Mnemonics.setLocalizedText(this.allowTagEditing, OStrings.getString("WF_TAG_EDITING"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.allowTagEditing, gridBagConstraints);
        Mnemonics.setLocalizedText(this.tagValidateOnLeave, OStrings.getString("WG_TAG_VALIDATE_ON_LEAVE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.tagValidateOnLeave, gridBagConstraints);
        Mnemonics.setLocalizedText(this.cbSaveAutoStatus, OStrings.getString("WG_SAVE_AUTO_STATUS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.cbSaveAutoStatus, gridBagConstraints);
        this.initialSegCountLabel.setLabelFor(this.initialSegCountSpinner);
        Mnemonics.setLocalizedText(this.initialSegCountLabel, OStrings.getString("WG_INITIAL_SEGMENT_LOAD_COUNT"));
        this.initialSegCountLabel.setToolTipText(OStrings.getString("WG_INITIAL_SEGMENT_LOAD_COUNT_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel1.add((Component)this.initialSegCountLabel, gridBagConstraints);
        this.initialSegCountSpinner.setToolTipText(OStrings.getString("WG_INITIAL_SEGMENT_LOAD_COUNT_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 13;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.initialSegCountSpinner, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkflowOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkflowOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.cancelButton);
        this.jPanel2.add((Component)this.jPanel3, "East");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void radiosActionPerformed(ActionEvent evt) {
        this.similarityLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.similaritySpinner.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.prefixLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.prefixText.setEnabled(this.insertFuzzyCheckBox.isSelected());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("wf_noSourceText", this.leaveEmptyRadio.isSelected());
        Preferences.setPreference("wf_insertBestMatch", this.insertFuzzyCheckBox.isSelected());
        if (this.insertFuzzyCheckBox.isSelected()) {
            int val = Math.max(0, Math.min(100, (Integer)this.similaritySpinner.getValue()));
            Preferences.setPreference("wf_minimalSimilarity", val);
            Preferences.setPreference("wf_explanatoryText", this.prefixText.getText());
        }
        Preferences.setPreference("wf_allowTransEqualToSrc", this.allowTranslationEqualToSource.isSelected());
        Preferences.setPreference("wf_exportCurrentSegment", this.exportCurrentSegment.isSelected());
        Preferences.setPreference("wf_stopOnAlternativeTranslation", this.stopOnAlternativeTranslation.isSelected());
        Preferences.setPreference("wf_convertNumbers", this.convertNumbers.isSelected());
        Preferences.setPreference("allowTagEditing", this.allowTagEditing.isSelected());
        Preferences.setPreference("tagValidateOnLeave", this.tagValidateOnLeave.isSelected());
        Preferences.setPreference("save_auto_status", this.cbSaveAutoStatus.isSelected());
        int segCount = Math.max(0, (Integer)this.initialSegCountSpinner.getValue());
        Preferences.setPreference("editor_initial_segment_load_count", segCount);
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

