/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.io.File;
import java.io.IOException;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.editor.EditorController;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.UIThreadsUtil;

public class SegmentExportImport {
    static final int WAIT_TIME = 100;
    private final EditorController controller;
    private volatile long exportLastModified = Long.MAX_VALUE;
    private final File importFile;
    public static final String SELECTION_EXPORT = "selection.txt";
    public static final String TARGET_EXPORT = "target.txt";
    public static final String SOURCE_EXPORT = "source.txt";

    public SegmentExportImport(EditorController controller) {
        this.controller = controller;
        this.importFile = new File(StaticUtils.getScriptDir(), "import.txt");
        new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (SegmentExportImport.this.importFile.lastModified() >= SegmentExportImport.this.exportLastModified) {
                            SegmentExportImport.this.importText();
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }.start();
    }

    private static File getFile(String name) {
        return new File(StaticUtils.getScriptDir(), name);
    }

    public synchronized void exportCurrentSegment(SourceTextEntry ste) {
        this.importFile.delete();
        if (ste == null) {
            this.exportLastModified = Long.MAX_VALUE;
            return;
        }
        String s1 = ste.getSrcText();
        TMXEntry te = Core.getProject().getTranslationInfo(ste);
        String s2 = te.isTranslated() ? te.translation : "";
        File sourceFile = SegmentExportImport.getFile(SOURCE_EXPORT);
        File targetFile = SegmentExportImport.getFile(TARGET_EXPORT);
        try {
            SegmentExportImport.writeFile(sourceFile, s1);
            SegmentExportImport.writeFile(targetFile, s2);
            this.exportLastModified = sourceFile.lastModified();
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    private static void writeFile(File file, String content) throws IOException {
        content = content.replaceAll("\n", System.getProperty("line.separator"));
        file.delete();
        FileUtil.writeTextFile(file, content);
    }

    public static synchronized void exportCurrentSelection(String selection) {
        try {
            SegmentExportImport.writeFile(SegmentExportImport.getFile(SELECTION_EXPORT), selection);
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    synchronized void importText() {
        if (this.importFile.lastModified() < this.exportLastModified) {
            return;
        }
        this.exportLastModified = this.importFile.lastModified() + 1L;
        try {
            final String text = FileUtil.readTextFile(this.importFile).replace(System.getProperty("line.separator"), "\n");
            UIThreadsUtil.executeInSwingThread(new Runnable(){

                @Override
                public void run() {
                    SegmentExportImport.this.controller.replaceEditText(text);
                }
            });
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    public static synchronized void flushExportedSegments() {
        File sourceFile = SegmentExportImport.getFile(SOURCE_EXPORT);
        File targetFile = SegmentExportImport.getFile(TARGET_EXPORT);
        try {
            SegmentExportImport.writeFile(sourceFile, "");
            SegmentExportImport.writeFile(targetFile, "");
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }
}

