/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filters2;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class InstanceEditor
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private String sourceFilenameMask;
    private String sourceEncoding;
    private String targetEncoding;
    private String targetFilenamePattern;
    private int returnStatus = 0;
    private JButton addOrUpdateButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JTextArea hintTextArea;
    private JButton insertButton;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JComboBox sourceEncodingField;
    private JTextField sourceFilenameMaskField;
    private JComboBox substitute;
    private JComboBox targetEncodingField;
    private JTextField targetFilenamePatternField;
    private JPanel tfnpPanel;

    private void init2(boolean sourceEncodingVariable, boolean targetEncodingVariable, String hint) {
        this.getRootPane().setDefaultButton(this.addOrUpdateButton);
        this.sourceEncodingField.setEnabled(sourceEncodingVariable);
        this.targetEncodingField.setEnabled(targetEncodingVariable);
        ((TitledBorder)this.tfnpPanel.getBorder()).setTitle(OStrings.getString("INSTANCEEDITOR_Target_Filename_Pattern"));
        this.sourceFilenameMaskField.setText("*.*");
        this.targetFilenamePatternField.setText("${filename}");
        this.hintTextArea.setText(hint);
        this.hintTextArea.setVisible(!StringUtil.isEmpty(hint));
        StaticUIUtils.setEscapeClosable(this);
        this.pack();
        DockingUI.displayCentered(this);
    }

    public InstanceEditor(Dialog parent, boolean sourceEncodingVariable, boolean targetEncodingVariable, String hint) {
        super(parent, true);
        this.initComponents();
        this.init2(sourceEncodingVariable, targetEncodingVariable, hint);
        this.setTitle(OStrings.getString("INSTANCEEDITOR_TITLE_ADD"));
        Mnemonics.setLocalizedText(this.addOrUpdateButton, OStrings.getString("BUTTON_OK"));
    }

    public InstanceEditor(Dialog parent, boolean sourceEncodingVariable, boolean targetEncodingVariable, String hint, String sourceFilenameMask, String sourceEncoding, String targetEncoding, String targetFilenamePattern) {
        super(parent, true);
        this.initComponents();
        this.init2(sourceEncodingVariable, targetEncodingVariable, hint);
        this.setTitle(OStrings.getString("INSTANCEEDITOR_TITLE_UPDATE"));
        Mnemonics.setLocalizedText(this.addOrUpdateButton, OStrings.getString("BUTTON_OK"));
        this.sourceFilenameMaskField.setText(sourceFilenameMask);
        this.sourceEncodingField.setSelectedItem(sourceEncoding);
        this.targetEncodingField.setSelectedItem(targetEncoding);
        this.targetFilenamePatternField.setText(targetFilenamePattern);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public String getSourceFilenameMask() {
        return this.sourceFilenameMask;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    public String getTargetFilenamePattern() {
        return this.targetFilenamePattern;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.addOrUpdateButton = new JButton();
        this.cancelButton = new JButton();
        this.hintTextArea = new JTextArea();
        this.tfnpPanel = new JPanel();
        this.insertButton = new JButton();
        this.substitute = new JComboBox();
        this.jLabel4 = new JLabel();
        this.targetFilenamePatternField = new JTextField();
        this.jLabel2 = new JLabel();
        this.sourceFilenameMaskField = new JTextField();
        this.jLabel3 = new JLabel();
        this.sourceEncodingField = new JComboBox();
        this.jLabel6 = new JLabel();
        this.targetEncodingField = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("INSTANCEEDITOR_TITLE_ADD"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText(this.addOrUpdateButton, OStrings.getString("BUTTON_ADD"));
        this.addOrUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceEditor.this.addOrUpdateButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.addOrUpdateButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.hintTextArea.setEditable(false);
        this.hintTextArea.setFont(new JLabel().getFont());
        this.hintTextArea.setLineWrap(true);
        this.hintTextArea.setWrapStyleWord(true);
        this.hintTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.hintTextArea, gridBagConstraints);
        this.tfnpPanel.setBorder(BorderFactory.createTitledBorder("Target Filename Pattern"));
        this.tfnpPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText(this.insertButton, OStrings.getString("BUTTON_INSERT"));
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceEditor.this.insertButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tfnpPanel.add((Component)this.insertButton, gridBagConstraints);
        this.substitute.setModel(new DefaultComboBoxModel<String>(AbstractFilter.TARGET_FILENAME_PATTERNS));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tfnpPanel.add((Component)this.substitute, gridBagConstraints);
        Mnemonics.setLocalizedText(this.jLabel4, OStrings.getString("INSTANCEEDITOR_Substituted_Variable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tfnpPanel.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tfnpPanel.add((Component)this.targetFilenamePatternField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.tfnpPanel, gridBagConstraints);
        Mnemonics.setLocalizedText(this.jLabel2, OStrings.getString("INSTANCEEDITOR_SOURCE_MASK"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.sourceFilenameMaskField, gridBagConstraints);
        Mnemonics.setLocalizedText(this.jLabel3, OStrings.getString("INSTANCEEDITOR_SOURCE_ENCODING"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.sourceEncodingField.setModel(new DefaultComboBoxModel<Object>(FilterMaster.getSupportedEncodings().toArray()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.sourceEncodingField, gridBagConstraints);
        Mnemonics.setLocalizedText(this.jLabel6, OStrings.getString("INSTANCEEDITOR_Target_Encoding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.targetEncodingField.setModel(new DefaultComboBoxModel<Object>(FilterMaster.getSupportedEncodings().toArray()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.targetEncodingField, gridBagConstraints);
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        int caret = this.targetFilenamePatternField.getCaretPosition();
        String oldtext = this.targetFilenamePatternField.getText();
        String newtext = oldtext.substring(0, caret) + this.substitute.getSelectedItem().toString() + oldtext.substring(caret);
        this.targetFilenamePatternField.setText(newtext);
        this.targetFilenamePatternField.setCaretPosition(caret + this.substitute.getSelectedItem().toString().length());
        this.targetFilenamePatternField.requestFocus();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void addOrUpdateButtonActionPerformed(ActionEvent evt) {
        this.sourceFilenameMask = this.sourceFilenameMaskField.getText();
        this.sourceEncoding = this.sourceEncodingField.getSelectedItem().toString();
        this.targetEncoding = this.targetEncodingField.getSelectedItem().toString();
        this.targetFilenamePattern = this.targetFilenamePatternField.getText();
        this.doClose(1);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

