/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import org.omegat.core.Core;
import org.omegat.gui.search.SearchWindowController;
import org.omegat.gui.search.SearchWindowForm;
import org.omegat.gui.shortcuts.PropertiesShortcuts;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.openide.awt.Mnemonics;

public class SearchWindowMenu
extends JMenuBar {
    private final SearchWindowForm form;
    private final SearchWindowController controller;

    public SearchWindowMenu(SearchWindowForm form, SearchWindowController controller) {
        this.form = form;
        this.controller = controller;
        this.init();
    }

    private void init() {
        JMenu fileMenu = this.add(new JMenu());
        Mnemonics.setLocalizedText(fileMenu, OStrings.getString("SW_FILE_MENU"));
        JMenuItem item = fileMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText(item, OStrings.getString("SW_FILE_MENU_SELECT_SEARCH_FIELD"));
        item.setActionCommand("editFindInProjectMenuItem");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selection = ((SearchWindowMenu)SearchWindowMenu.this).form.m_viewer.getSelectedText();
                JComboBox field = ((SearchWindowMenu)SearchWindowMenu.this).form.m_searchField;
                if (!StringUtil.isEmpty(selection)) {
                    JTextField editor = (JTextField)field.getEditor().getEditorComponent();
                    editor.setText(selection);
                }
                field.requestFocus();
                field.getEditor().selectAll();
            }
        });
        item = fileMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText(item, OStrings.getString("SW_FILE_MENU_CLOSE"));
        item.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchWindowMenu.this.controller.doCancel();
            }
        });
        JMenu editMenu = this.add(new JMenu());
        Mnemonics.setLocalizedText(editMenu, OStrings.getString("SW_EDIT_MENU"));
        item = editMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText(item, OStrings.getString("TF_MENU_EDIT_SOURCE_INSERT"));
        item.setActionCommand("editInsertSourceMenuItem");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox currentBox = ((SearchWindowMenu)SearchWindowMenu.this).form.m_searchField;
                if (((SearchWindowMenu)SearchWindowMenu.this).form.m_replaceField.hasFocus()) {
                    currentBox = ((SearchWindowMenu)SearchWindowMenu.this).form.m_replaceField;
                }
                JTextField editor = (JTextField)currentBox.getEditor().getEditorComponent();
                int offset = editor.getCaretPosition();
                String source = Core.getEditor().getCurrentEntry().getSrcText();
                try {
                    editor.getDocument().insertString(offset, source, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        item = editMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText(item, OStrings.getString("TF_MENU_EDIT_SOURCE_OVERWRITE"));
        item.setActionCommand("editOverwriteSourceMenuItem");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox currentBox = ((SearchWindowMenu)SearchWindowMenu.this).form.m_searchField;
                if (((SearchWindowMenu)SearchWindowMenu.this).form.m_replaceField.hasFocus()) {
                    currentBox = ((SearchWindowMenu)SearchWindowMenu.this).form.m_replaceField;
                }
                JTextField editor = (JTextField)currentBox.getEditor().getEditorComponent();
                editor.setText(Core.getEditor().getCurrentEntry().getSrcText());
            }
        });
        editMenu.addSeparator();
        item = editMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText(item, OStrings.getString("TF_MENU_EDIT_CREATE_GLOSSARY_ENTRY"));
        item.setActionCommand("editCreateGlossaryEntryMenuItem");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Core.getGlossary().showCreateGlossaryEntryDialog(SearchWindowMenu.this.form);
            }
        });
        PropertiesShortcuts.MainMenuShortcuts.bindKeyStrokes(this);
    }
}

