/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.HunspellDictionary;
import org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.omegat.tokenizer.BaseTokenizer;
import org.omegat.tokenizer.Tokenizer;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.Preferences;

@Tokenizer(languages={"discoverAtRuntime"})
public class HunspellTokenizer
extends BaseTokenizer {
    private static Map<Language, File> AFFIX_FILES;
    private static Map<Language, File> DICTIONARY_FILES;
    private HunspellDictionary dict;

    private HunspellDictionary getDict() {
        if (this.dict != null) {
            return this.dict;
        }
        if (AFFIX_FILES == null || DICTIONARY_FILES == null) {
            HunspellTokenizer.populateInstalledDicts();
        }
        Language language = this.getLanguage();
        File affixFile = AFFIX_FILES.get(language);
        File dictionaryFile = DICTIONARY_FILES.get(language);
        if (affixFile == null || dictionaryFile == null || !affixFile.exists() || !dictionaryFile.exists()) {
            Log.logErrorRB("HUNSPELL_TOKENIZER_DICT_NOT_INSTALLED", language.getLocale());
        }
        try {
            this.dict = new HunspellDictionary(new FileInputStream(affixFile), new FileInputStream(dictionaryFile), this.getBehavior());
            return this.dict;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected TokenStream getTokenStream(String strOrig, boolean stemsAllowed, boolean stopWordsAllowed) {
        if (stemsAllowed) {
            HunspellDictionary dictionary = this.getDict();
            if (dictionary == null) {
                return new StandardTokenizer(this.getBehavior(), (Reader)new StringReader(strOrig));
            }
            return new HunspellStemFilter(new StandardTokenizer(this.getBehavior(), (Reader)new StringReader(strOrig)), dictionary);
        }
        return new StandardTokenizer(this.getBehavior(), (Reader)new StringReader(strOrig));
    }

    @Override
    public String[] getSupportedLanguages() {
        HunspellTokenizer.populateInstalledDicts();
        Set<Language> commonLangs = AFFIX_FILES.keySet();
        commonLangs.retainAll(DICTIONARY_FILES.keySet());
        return HunspellTokenizer.langsToStrings(commonLangs);
    }

    private static void populateInstalledDicts() {
        AFFIX_FILES = new HashMap<Language, File>();
        DICTIONARY_FILES = new HashMap<Language, File>();
        String dictionaryDirPath = Preferences.getPreference("spellcheker_dir");
        if (dictionaryDirPath.isEmpty()) {
            return;
        }
        File dictionaryDir = new File(dictionaryDirPath);
        if (!dictionaryDir.isDirectory()) {
            return;
        }
        for (File file : dictionaryDir.listFiles()) {
            Language lang;
            String name = file.getName();
            if (name.endsWith(".aff")) {
                lang = new Language(name.substring(0, name.lastIndexOf(".aff")));
                AFFIX_FILES.put(lang, file);
                AFFIX_FILES.put(new Language(lang.getLanguageCode()), file);
                continue;
            }
            if (!name.endsWith(".dic")) continue;
            lang = new Language(name.substring(0, name.lastIndexOf(".dic")));
            DICTIONARY_FILES.put(lang, file);
            DICTIONARY_FILES.put(new Language(lang.getLanguageCode()), file);
        }
    }

    private static String[] langsToStrings(Set<Language> langs) {
        ArrayList<String> result = new ArrayList<String>();
        for (Language lang : langs) {
            result.add(lang.getLanguage().toLowerCase());
            result.add(lang.getLanguageCode().toLowerCase());
        }
        return result.toArray(new String[result.size()]);
    }
}

