/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public abstract class VarExpansion<Param> {
    public static final String VAR_SOURCE_TEXT = "${sourceText}";
    public static final String VAR_TARGET_TEXT = "${targetText}";
    public static final String VAR_PROJECT_SOURCE_LANG = "${projectSourceLang}";
    public static final String VAR_PROJECT_SOURCE_LANG_CODE = "${projectSourceLangCode}";
    public static final String VAR_PROJECT_TARGET_LANG = "${projectTargetLang}";
    public static final String VAR_PROJECT_TARGET_LANG_CODE = "${projectTargetLangCode}";
    public static final String VAR_FILE_NAME = "${fileName}";
    public static final String VAR_FILE_NAME_ONLY = "${fileNameOnly}";
    public static final String VAR_FILE_EXTENSION = "${fileExtension}";
    public static final String VAR_FILE_PATH = "${filePath}";
    public static final String VAR_FILE_SHORT_PATH = "${fileShortPath}";
    public static final Pattern patternBundleEntry = Pattern.compile("#\\{([\\w\\.]+?)\\}(\\[.+?\\])*");
    protected String template;

    public VarExpansion(String template) {
        template = VarExpansion.expandBundleEntries(template);
        if (Core.getProject().isProjectLoaded()) {
            ProjectProperties prop = Core.getProject().getProjectProperties();
            template = template.replace(VAR_PROJECT_TARGET_LANG, prop.getTargetLanguage().getLanguage());
            template = template.replace(VAR_PROJECT_TARGET_LANG_CODE, prop.getTargetLanguage().getLanguageCode());
            template = template.replace(VAR_PROJECT_SOURCE_LANG, prop.getSourceLanguage().getLanguage());
            template = template.replace(VAR_PROJECT_SOURCE_LANG_CODE, prop.getSourceLanguage().getLanguageCode());
        }
        this.template = template;
    }

    protected static String expandBundleEntries(String localTemplate) {
        Matcher matcher;
        while ((matcher = patternBundleEntry.matcher(localTemplate)).find()) {
            String original = matcher.group();
            String translation = OStrings.getString(matcher.group(1));
            if (!StringUtil.isEmpty(matcher.group(2))) {
                String vars = matcher.group(2);
                ArrayList<String> values = new ArrayList<String>();
                matcher = Pattern.compile("\\[(.+?)\\]").matcher(vars);
                while (matcher.find()) {
                    values.add(matcher.group(1));
                }
                translation = MessageFormat.format(translation, values.toArray());
            }
            localTemplate = localTemplate.replace(original, translation);
        }
        return localTemplate;
    }

    public String expandFileNames(String localTemplate, String[] filePaths, String baseDir) {
        String numHint;
        if (localTemplate == null) {
            localTemplate = this.template;
        }
        String filePath = filePaths[0];
        if (filePaths.length > 1) {
            numHint = filePath.equals("") ? OStrings.getString("MATCHES_THIS_PROJECT") : "";
            numHint = numHint + " " + StringUtil.format(OStrings.getString("MATCHES_MULTI_FILE_HINT"), filePaths.length - 1);
        } else {
            numHint = "";
        }
        localTemplate = localTemplate.replace(VAR_FILE_PATH, filePath + numHint);
        if (filePath.startsWith(baseDir)) {
            filePath = filePath.substring(baseDir.length());
        }
        localTemplate = localTemplate.replace(VAR_FILE_SHORT_PATH, filePath + numHint);
        if (filePath.contains(File.separator)) {
            filePath = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        }
        localTemplate = localTemplate.replace(VAR_FILE_NAME, filePath + numHint);
        if (filePath.contains(".")) {
            String[] splitName = filePath.split("\\.");
            StringBuilder nameOnlyBuf = new StringBuilder(splitName[0]);
            StringBuilder extensionBuf = new StringBuilder(splitName[splitName.length - 1]);
            localTemplate = localTemplate.replace(VAR_FILE_NAME_ONLY, nameOnlyBuf.toString());
            localTemplate = localTemplate.replace(VAR_FILE_EXTENSION, extensionBuf.toString());
            for (int i = 0; i < splitName.length; ++i) {
                localTemplate = localTemplate.replaceAll("\\$\\{fileNameOnly-" + i + "\\}", nameOnlyBuf.toString());
                localTemplate = localTemplate.replaceAll("\\$\\{fileExtension-" + i + "\\}", extensionBuf.toString());
                if (i + 1 >= splitName.length) continue;
                nameOnlyBuf.append(".").append(splitName[i + 1]);
                extensionBuf.insert(0, splitName[splitName.length - i - 2] + '.');
            }
        }
        localTemplate = localTemplate.replaceAll("\\$\\{fileNameOnly(-\\d+)?\\}", filePath);
        localTemplate = localTemplate.replaceAll("\\$\\{fileExtension(-\\d+)?\\}", "");
        return localTemplate;
    }

    public String expandFileName(String localTemplate, String filePath, String baseDir) {
        return this.expandFileNames(localTemplate, new String[]{filePath}, baseDir);
    }

    public abstract String expandVariables(Param var1);
}

