/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.omegat.util.xml.XMLAttribute;

public class XMLBlock {
    private String m_text;
    private String m_shortcut;
    private boolean m_isClose;
    private boolean m_isComment;
    private boolean m_isStandalone;
    private boolean m_isTag;
    private boolean m_hasText;
    private char m_typeChar;
    private List<XMLAttribute> m_attrList;
    private int shortcutNumber;

    public XMLBlock() {
        this.reset();
    }

    private void reset() {
        this.m_text = "";
        this.m_isClose = false;
        this.m_isStandalone = false;
        this.m_isComment = false;
        this.m_isTag = false;
        this.m_typeChar = '\u0000';
        this.m_hasText = false;
        this.m_shortcut = "";
        if (this.m_attrList != null) {
            this.m_attrList.clear();
        }
    }

    public void setAttribute(String attribute, String value) {
        XMLAttribute attr = new XMLAttribute(attribute, value);
        this.setAttribute(attr);
    }

    private void setAttribute(XMLAttribute attr) {
        if (this.m_attrList == null) {
            this.m_attrList = new ArrayList<XMLAttribute>(8);
        }
        this.m_attrList.add(attr);
    }

    public void setText(String text) {
        this.setTag(false);
        this.m_text = text;
        this.m_hasText = false;
        if (text.codePointCount(0, text.length()) == 1) {
            int cp = text.codePointAt(0);
            if (cp != 9 && cp != 10 && cp != 13 && cp != 32) {
                this.m_hasText = true;
            }
        } else {
            this.m_hasText = true;
        }
    }

    public void setTypeChar(char c) {
        this.m_typeChar = c;
    }

    public void setShortcut(String shortcut) {
        this.m_shortcut = shortcut;
    }

    public String getShortcut() {
        if (this.m_shortcut != null && !this.m_shortcut.equals("")) {
            if (this.m_isClose) {
                return "/" + this.m_shortcut;
            }
            if (this.m_isComment) {
                return "!comment";
            }
        }
        return this.m_shortcut;
    }

    public void setCloseFlag() {
        this.m_isClose = true;
        this.m_isStandalone = false;
    }

    public void setStandaloneFlag() {
        this.m_isStandalone = true;
        this.m_isClose = false;
    }

    public void setComment() {
        this.m_isTag = true;
        this.setTypeChar('!');
        this.m_isComment = true;
        this.m_isClose = false;
        this.m_isStandalone = false;
    }

    public void setTagName(String name) {
        this.setTag(true);
        this.m_text = name;
    }

    private void setTag(boolean isTag) {
        this.m_isTag = isTag;
    }

    public boolean hasText() {
        return this.m_hasText;
    }

    public boolean isTag() {
        return this.m_isTag;
    }

    public boolean isStandalone() {
        return this.m_isStandalone;
    }

    public boolean isClose() {
        return this.m_isClose;
    }

    public boolean isComment() {
        return this.m_isComment;
    }

    public String getText() {
        if (this.m_typeChar == '?') {
            String tag = "<?" + this.m_text;
            if (this.m_attrList != null) {
                for (XMLAttribute attr : this.m_attrList) {
                    tag = tag + " " + attr.name + "=\"" + attr.value + "\"";
                }
            }
            tag = tag + "?>";
            return tag;
        }
        if (this.m_typeChar == '!') {
            String tag = "<!";
            if (this.m_text.equals("CDATA")) {
                tag = tag + "[";
                tag = tag + this.m_text;
                tag = tag + "[";
            } else if (this.m_text.equals("]]")) {
                tag = "]]>";
            } else if (this.m_isComment) {
                tag = tag + "-- ";
                tag = tag + this.m_text;
                tag = tag + " -->";
            } else {
                tag = tag + this.m_text + " ";
                if (this.m_attrList != null && !this.m_attrList.isEmpty()) {
                    tag = tag + this.m_attrList.get((int)0).name;
                }
                tag = tag + '>';
            }
            return tag;
        }
        if (this.isTag()) {
            String tag = "<";
            if (this.m_isClose) {
                tag = tag + '/';
            }
            tag = tag + this.m_text;
            if (this.m_attrList != null) {
                for (XMLAttribute attr : this.m_attrList) {
                    tag = tag + " " + attr.name + "=\"" + attr.value + "\"";
                }
            }
            if (this.m_isStandalone) {
                tag = tag + " /";
            }
            tag = tag + '>';
            return tag;
        }
        return this.m_text;
    }

    public String getTagName() {
        if (this.isTag()) {
            return this.m_text;
        }
        return "";
    }

    public int numAttributes() {
        if (this.m_attrList == null) {
            return 0;
        }
        return this.m_attrList.size();
    }

    public XMLAttribute getAttribute(int n) {
        if (n < 0 || !this.isTag() || this.m_attrList == null || n > this.m_attrList.size()) {
            return null;
        }
        return this.m_attrList.get(n);
    }

    public String getAttribute(String name) {
        if (!this.isTag() || this.m_attrList == null) {
            return null;
        }
        XMLAttribute attr = null;
        for (int i = 0; i < this.m_attrList.size(); ++i) {
            attr = this.m_attrList.get(i);
            if (attr.name.equals(name)) break;
            attr = null;
        }
        if (attr == null) {
            return null;
        }
        return attr.value;
    }

    public String toString() {
        return this.getText();
    }

    public int getShortcutNumber() {
        return this.shortcutNumber;
    }

    public void setShortcutNumber(int shortcutNumber) {
        this.shortcutNumber = shortcutNumber;
    }
}

