/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.glos;

import java.net.URLDecoder;
import java.util.List;
import java.util.Properties;
import org.omegat.core.glossaries.IWritableGlossary;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Language;
import org.silvestrislab.cyclotis.omegat.HttpCyclotis;

public class HttpGlossary
extends HttpCyclotis<GlossaryEntry>
implements IWritableGlossary {
    protected static final String LINE_FORMAT = "otn";

    public HttpGlossary(Properties propList) {
        super(propList);
    }

    @Override
    public final GlossaryEntry analyzeLine(String[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            try {
                cols[i] = URLDecoder.decode(cols[i], "UTF-8");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new GlossaryEntry(cols[0], cols[1], cols[2], false);
    }

    public void addEntry(Language sLang, Language tLang, GlossaryEntry entry) throws Exception {
        this.registerTranslation(entry);
    }

    @Override
    protected String encodeArgs(GlossaryEntry entry) {
        StringBuffer args = new StringBuffer();
        args.append("src=").append(this.reformatText(entry.getSrcText(), false));
        args.append("tra=").append(this.reformatText(entry.getCommentText(), false));
        args.append("note").append(entry.getCommentText());
        return args.toString();
    }

    public List<GlossaryEntry> search(Language sLang, Language tLang, String srcText) throws Exception {
        return this.httpGet("glosSrc", "otn&langSrc=" + sLang.getLanguageCode(), srcText);
    }
}

