/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.external.ProjectMemory;
import org.silvestrislab.cyclotis.omegat.HttpCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.proj.ctx.StringContextMode;

public class HttpProjectMemory
extends HttpCyclotisTMX<ProjectMemory.ContextTMXEntry>
implements ProjectMemory.IExternalProjectMemory {
    public static final int COL_CONTEXT = 8;
    private StringContextMode contextMode;
    private long timeStampDiff;

    public HttpProjectMemory(Properties propList) {
        super(propList);
        this.contextMode = StringContextMode.forProperties(propList, 1);
        System.out.println("Context mode  is " + this.contextMode);
        try {
            String serverTime = propList.getProperty("server-time");
            if (serverTime.contains(";")) {
                serverTime = serverTime.substring(0, serverTime.indexOf(59));
            }
            this.timeStampDiff = Long.parseLong(serverTime) - System.currentTimeMillis();
            this.logMessage("", "Server to client timestamp difference: " + this.timeStampDiff);
        }
        catch (Exception e) {
            this.logMessage("", "Cannot find server timestamp : " + e.getMessage());
        }
    }

    @Override
    public ProjectMemory.ContextTMXEntry analyzeLine(String[] cols) {
        ProjectMemory.ContextTMXEntry entry = new ProjectMemory.ContextTMXEntry();
        this.fillEntry(entry, cols);
        this.contextMode.fillEntry(entry, cols[8]);
        try {
            entry.linked = TMXEntry.ExternalLinked.valueOf((String)entry.getPropValue("externalLinked"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry;
    }

    public List<ProjectMemory.ContextTMXEntry> findChanges(long timeStamp) throws Exception {
        return this.httpGet("all", "$otadcupni", new Timestamp(timeStamp).toString());
    }

    @Override
    protected String encodeArgs(ProjectMemory.ContextTMXEntry entry) throws Exception {
        StringBuffer buf = new StringBuffer(super.encodeArgs(entry));
        buf.append("&context=").append((String)this.contextMode.toDatabase(entry.entryNum, entry.isDefault));
        return buf.toString();
    }

    public void removeTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        String line;
        StringBuffer urlString = new StringBuffer(this.urlSave);
        urlString.append("?context=").append((String)this.contextMode.toDatabase(entry.entryNum, entry.isDefault));
        if (!this.contextMode.isUnique()) {
            urlString.append("&src=").append(URLEncoder.encode(entry.source, "UTF-8"));
        }
        URL httpUrl = new URL(urlString.toString());
        HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("DELETE");
        BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = rd.readLine()) != null) {
            System.out.println("POST:" + line);
        }
        connection.disconnect();
    }
}

