/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pl;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.pl.PolishRule;
import org.languagetool.tools.StringTools;

public class PolishWordRepeatRule
extends PolishRule {
    private static final Pattern EXC_WORDS = Pattern.compile("nie|tu\u017c|a\u017c|to|siebie|by\u0107|ani|ni|albo|lub|czy|b\u0105d\u017a|jako|z\u0142|np|coraz|bardzo|bardziej|proc|ten|jak|mln|tys|sw\u00f3j|m\u00f3j|tw\u00f3j|nasz|wasz|i|zbyt");
    private static final Pattern EXC_POS = Pattern.compile("prep:.*|ppron.*");
    private static final Pattern EXC_NONWORDS = Pattern.compile("&quot|&gt|&lt|&amp|[0-9].*|M*(D?C{0,3}|C[DM])(L?X{0,3}|X[LC])(V?I{0,3}|I[VX])$");

    public PolishWordRepeatRule(ResourceBundle messages) {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.setDefaultOff();
    }

    public final String getId() {
        return "PL_WORD_REPEAT";
    }

    public final String getDescription() {
        return "Powt\u00f3rzenia wyraz\u00f3w w zdaniu (monotonia stylistyczna)";
    }

    public final RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        boolean repetition = false;
        TreeSet<String> inflectedWords = new TreeSet<String>();
        int curToken = 0;
        for (int i = 1; i < tokens.length; ++i) {
            Matcher m1;
            String token = tokens[i].getToken();
            boolean isWord = true;
            boolean hasLemma = true;
            if (token.length() < 2) {
                isWord = false;
            }
            int readingsLen = tokens[i].getReadingsLength();
            for (int k = 0; k < readingsLen; ++k) {
                String posTag = tokens[i].getAnalyzedToken(k).getPOSTag();
                if (posTag != null) {
                    if (StringTools.isEmpty((String)posTag)) {
                        isWord = false;
                        break;
                    }
                    String lemma = tokens[i].getAnalyzedToken(k).getLemma();
                    if (lemma == null) {
                        hasLemma = false;
                        break;
                    }
                    Matcher m12 = EXC_WORDS.matcher(lemma);
                    if (m12.matches()) {
                        isWord = false;
                        break;
                    }
                    Matcher m2 = EXC_POS.matcher(posTag);
                    if (!m2.matches()) continue;
                    isWord = false;
                    break;
                }
                hasLemma = false;
            }
            if ((m1 = EXC_NONWORDS.matcher(tokens[i].getToken())).matches()) {
                isWord = false;
            }
            String prevLemma = "";
            if (isWord) {
                boolean notSentEnd = false;
                for (int j = 0; j < readingsLen; ++j) {
                    String pos = tokens[i].getAnalyzedToken(j).getPOSTag();
                    if (pos != null) {
                        notSentEnd |= "SENT_END".equals(pos);
                    }
                    if (hasLemma) {
                        String curLemma = tokens[i].getAnalyzedToken(j).getLemma();
                        if (!prevLemma.equals(curLemma) && !notSentEnd) {
                            if (inflectedWords.contains(curLemma) && curToken != i) {
                                repetition = true;
                            } else {
                                inflectedWords.add(tokens[i].getAnalyzedToken(j).getLemma());
                                curToken = i;
                            }
                        }
                        prevLemma = curLemma;
                        continue;
                    }
                    if (inflectedWords.contains(tokens[i].getToken()) && !notSentEnd) {
                        repetition = true;
                        continue;
                    }
                    inflectedWords.add(tokens[i].getToken());
                }
            }
            if (!repetition) continue;
            String msg = "Powt\u00f3rzony wyraz w zdaniu";
            int pos = tokens[i].getStartPos();
            RuleMatch ruleMatch = new RuleMatch((Rule)this, pos, pos + token.length(), "Powt\u00f3rzony wyraz w zdaniu", "Powt\u00f3rzenie wyrazu");
            ruleMatches.add(ruleMatch);
            repetition = false;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public void reset() {
    }
}

