/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ro;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.ManualTagger;

public class RomanianTagger
extends BaseTagger {
    private String RESOURCE_FILENAME = "/ro/romanian.dict";
    private String USER_DICT_FILENAME = "/ro/added.txt";
    private IStemmer morfologik;
    private ManualTagger manualTagger;
    private static final Locale roLocale = new Locale("ro");

    public final String getFileName() {
        return this.RESOURCE_FILENAME;
    }

    public RomanianTagger() {
        this.setLocale(roLocale);
    }

    public RomanianTagger(String dictFileName, String userDictFileName) {
        this.RESOURCE_FILENAME = dictFileName;
        this.USER_DICT_FILENAME = userDictFileName;
        this.setLocale(roLocale);
    }

    public final List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        if (this.morfologik == null) {
            URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(this.RESOURCE_FILENAME);
            this.morfologik = new DictionaryLookup(Dictionary.read((URL)url));
        }
        if (this.manualTagger == null && this.USER_DICT_FILENAME != null) {
            this.manualTagger = new ManualTagger(JLanguageTool.getDataBroker().getFromResourceDirAsStream(this.USER_DICT_FILENAME));
        }
        for (String word : sentenceTokens) {
            String[] manualTags;
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerCaseWord = word.toLowerCase(roLocale);
            List taggerTokens = this.morfologik.lookup((CharSequence)lowerCaseWord);
            if (taggerTokens != null) {
                for (WordData wd : taggerTokens) {
                    String[] tagsArr;
                    for (String currTag : tagsArr = wd.getStem().toString().split("\\+")) {
                        l.add(new AnalyzedToken(word, wd.getTag().toString(), currTag));
                    }
                }
            }
            if (this.manualTagger != null && (manualTags = this.manualTagger.lookup(lowerCaseWord)) != null) {
                for (int i = 0; i < manualTags.length / 2; i += 2) {
                    l.add(new AnalyzedToken(word, manualTags[i + 1], manualTags[i]));
                }
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            tokenReadings.add(new AnalyzedTokenReadings(l.toArray(new AnalyzedToken[l.size()]), pos));
            pos += word.length();
        }
        return tokenReadings;
    }
}

