/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.Cyclotis;
import org.silvestrislab.cyclotis.omegat.PostgresqlCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.proj.EntryKeyStore;
import org.silvestrislab.cyclotis.omegat.tm.PostgresqlMemory;

public class PostgresqlProjectMemory
extends PostgresqlCyclotisTMX<ProjectMemory.ContextTMXEntry>
implements ProjectMemory.IExternalProjectMemory {
    private PreparedStatement pRemove;
    private EntryKeyStore keyStore;
    private long timeStampDiff = 0L;

    public PostgresqlProjectMemory(Properties propList) throws SQLException, ClassNotFoundException {
        super(propList);
        try {
            PreparedStatement sNow = this.connection.prepareStatement("select NOW()");
            ResultSet rs = sNow.executeQuery();
            rs.next();
            this.timeStampDiff = rs.getTimestamp(1).getTime() - System.currentTimeMillis();
            this.logMessage("", "Server to client timestamp difference: " + this.timeStampDiff);
        }
        catch (Exception e) {
            this.logMessage("", "Cannot find server timestamp : " + e.getMessage());
        }
        if (propList.getProperty("remove.setNull") != null) {
            this.pRemove = this.createRemoveRule("true".equals(propList.getProperty("remove.setNull")));
        }
        if (this.col_props != null) {
            this.keyStore = new EntryKeyStore(propList);
            this.logMessage("struct", "Storing properties as " + this.keyStore);
        } else {
            this.logMessage("struct", "Table has no properties, do not store key");
        }
    }

    public IExternalMemory asTranslationMemory() {
        return new PostgresqlMemory(this){

            @Override
            protected PrepareTMXEntry buildEntry(ResultSet set) throws SQLException {
                ProjectMemory.ContextTMXEntry ctx = PostgresqlProjectMemory.this.buildEntry(set);
                if (ctx.entryNum >= 0) {
                    throw new SQLException("Not an orphan");
                }
                return super.buildEntry(set);
            }
        };
    }

    @Override
    protected List<String> insertFields() {
        ArrayList<String> res = new ArrayList<String>(4);
        res.add("SRC");
        res.add("TRA");
        res.add("AUTHOR");
        res.add("CONTEXT");
        if (this.hasNote) {
            res.add("NOTE");
        }
        if (this.col_props != null) {
            res.add("PROPS");
        }
        if (this.mem_id != null && this.mem_id instanceof Integer) {
            res.add("MEM_ID");
        }
        if (this.mem_id instanceof Long) {
            res.add("MEM_CODE");
        } else if (this.mem_id instanceof String) {
            res.add("MEM_PATH");
        }
        return res;
    }

    @Override
    protected String selectCondition() {
        return "date >= ? or changedate >= ?";
    }

    @Override
    protected ProjectMemory.ContextTMXEntry buildEntry(ResultSet set) throws SQLException {
        ProjectMemory.ContextTMXEntry entry = new ProjectMemory.ContextTMXEntry();
        entry.source = this.reformatText(set.getString("SRC"), true);
        entry.translation = this.reformatText(set.getString("TRA"), true);
        try {
            entry.creator = set.getString("AUTHOR");
            entry.creationDate = set.getTimestamp("DATE").getTime();
            entry.changer = set.getString("CHANGER");
            entry.changeDate = set.getTimestamp("CHANGEDATE").getTime();
            entry.note = set.getString("NOTE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        entry.otherProperties = this.col_props.read(set.getObject("PROPS"));
        if (this.keyStore != null) {
            this.keyStore.fillEntry(entry);
        }
        this.contextMode.fillEntry((Cyclotis)this, entry, set);
        return entry;
    }

    public Iterable<ProjectMemory.ContextTMXEntry> findChanges(long timeStamp) throws Exception {
        Timestamp date = new Timestamp(timeStamp + this.timeStampDiff);
        this.logMessage("search", "Searching for segments after " + LONG_LOG_DATE_FORMAT.format(date));
        PreparedStatement pSelect = this.getSelectStatement();
        pSelect.setTimestamp(1, date);
        pSelect.setTimestamp(2, date);
        if ((double)timeStamp < 1.0E9) {
            return this.iterateQuery(pSelect);
        }
        return this.retreiveQuery(pSelect);
    }

    @Override
    public void registerTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        this.logMessage("update", "Writing entry '" + entry.source + "'");
        if (this.pInsert == null) {
            this.pInsert = this.getInsertStatement();
            this.pInsert.setString(3, Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name")));
        }
        SourceTextEntry ste = (SourceTextEntry)Core.getProject().getAllEntries().get(entry.entryNum - 1);
        this.contextMode.setStatementValue(this.pInsert, 4, ste, entry.isDefault);
        if (this.hasNote) {
            this.getInsertStatement().setString(5, entry.note);
        }
        if (this.col_props != null) {
            List<TMXProp> list = this.store.toDatabase((PrepareTMXEntry)entry, ste);
            if (this.keyStore != null && this.keyStore.shouldWrite(entry)) {
                list.addAll(this.keyStore.buildProperties(entry));
            }
            if (entry.linked != null) {
                list.add(new TMXProp("externalLinked", entry.linked.toString()));
            }
            this.pInsert.setObject(this.hasNote ? 6 : 5, this.col_props.write(list));
        }
        super.registerTranslation(entry);
    }

    private PreparedStatement createRemoveRule(Boolean forced) throws SQLException {
        if (forced == null) {
            try {
                this.logMessage("struct", "Trying to ask the server whenever it has a deletion rule or not");
                PreparedStatement pFindDelRule = this.connection.prepareStatement("select definition from pg_rules where schemaname=? and tablename=?");
                if (this.tableWrite.contains(".")) {
                    pFindDelRule.setString(1, this.tableWrite.substring(0, this.tableWrite.indexOf(46)));
                    pFindDelRule.setString(2, this.tableWrite.substring(1 + this.tableWrite.indexOf(46)));
                } else {
                    pFindDelRule.setString(1, "public");
                    pFindDelRule.setString(2, this.tableWrite);
                }
                ResultSet RS = pFindDelRule.executeQuery();
                boolean hasDelRule = false;
                while (RS.next()) {
                    if (!RS.getString("definition").toUpperCase().contains(" ON DELETE ")) continue;
                    hasDelRule = true;
                }
                forced = !hasDelRule;
                this.logMessage("struct", "Detected that the server " + (hasDelRule ? " has " : " does not have ") + " a deletion rule");
            }
            catch (Exception e) {
                this.logMessage("struct", "Could not ask the server for deletion rule: we do as if it does not have it");
                forced = true;
            }
        }
        if (!forced.booleanValue()) {
            return this.connection.prepareStatement("delete from " + this.tableWrite + " where context=?" + (this.contextMode.isUnique() ? "" : " and src=?"));
        }
        return this.connection.prepareStatement("update " + this.tableWrite + " set tra=null where context=?" + (this.contextMode.isUnique() ? "" : " and src=?"));
    }

    public void removeTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        SourceTextEntry ste = (SourceTextEntry)Core.getProject().getAllEntries().get(entry.entryNum - 1);
        this.logMessage("update", "Removing entry '" + entry.source + "', id = " + entry.entryNum);
        try {
            if (this.pRemove == null) {
                this.pRemove = this.createRemoveRule(null);
            }
            this.contextMode.setStatementValue(this.pRemove, 1, ste, entry.isDefault);
            if (!this.contextMode.isUnique()) {
                this.pRemove.setString(2, entry.source);
            }
            this.pRemove.executeUpdate();
        }
        catch (Exception e) {
            this.logException(e);
            throw e;
        }
    }
}

