/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.sh;

import java.io.File;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.AbstractLanguageSupport;
import org.fife.rsta.ac.sh.ShellCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionCellRenderer;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.ToolTipSupplier;

public class ShellLanguageSupport
extends AbstractLanguageSupport {
    private ShellCompletionProvider provider;
    private boolean useLocalManPages;

    public ShellLanguageSupport() {
        this.setParameterAssistanceEnabled(false);
        this.setShowDescWindow(true);
        this.useLocalManPages = File.separatorChar == '/';
    }

    protected ListCellRenderer createDefaultCompletionCellRenderer() {
        return new CompletionCellRenderer();
    }

    private ShellCompletionProvider getProvider() {
        if (this.provider == null) {
            this.provider = new ShellCompletionProvider();
            ShellCompletionProvider.setUseLocalManPages(this.getUseLocalManPages());
        }
        return this.provider;
    }

    public boolean getUseLocalManPages() {
        return this.useLocalManPages;
    }

    public void install(RSyntaxTextArea textArea) {
        ShellCompletionProvider provider = this.getProvider();
        AutoCompletion ac = this.createAutoCompletion((CompletionProvider)provider);
        ac.install((JTextComponent)textArea);
        this.installImpl(textArea, ac);
        textArea.setToolTipSupplier((ToolTipSupplier)provider);
    }

    public void setUseLocalManPages(boolean use) {
        if (use != this.useLocalManPages) {
            this.useLocalManPages = use;
            if (this.provider != null) {
                ShellCompletionProvider.setUseLocalManPages(this.useLocalManPages);
            }
        }
    }

    public void uninstall(RSyntaxTextArea textArea) {
        this.uninstallImpl(textArea);
    }
}

