/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.util.Language;

public class TextFileMemory
implements IBrowsableMemory,
IWritableExternalMemory {
    private File file;
    private Charset code;
    private List<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>();
    private boolean write;
    private static DateFormat WF_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd~hhmmss");

    public TextFileMemory(Properties prop) throws IOException {
        this.file = new File(prop.getProperty("file"));
        try {
            this.code = Charset.forName(prop.getProperty("charset"));
        }
        catch (Exception ex) {
            this.code = TextFileMemory.isUTF16LE(this.file) ? StandardCharsets.UTF_16LE : StandardCharsets.UTF_8;
        }
        this.write = !"true".equals(prop.getProperty("read-only"));
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.code));){
            in.mark(1);
            int ch = in.read();
            if (ch != 65279) {
                in.reset();
            }
            String s = in.readLine();
            while (s != null) {
                String[] tokens;
                if (!s.startsWith("%") && (tokens = s.split("\t")).length >= 7 && tokens[0].length() != 0) {
                    PrepareTMXEntry entry = new PrepareTMXEntry();
                    entry.source = tokens[4].replace("&'9;", "\t");
                    entry.translation = tokens[6].replace("&'9;", "\t");
                    entry.creator = tokens[1];
                    try {
                        entry.creationDate = WF_DATE_FORMAT.parse(tokens[0]).getTime();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    entry.changeDate = Long.parseLong(tokens[2]);
                    this.entries.add(entry);
                }
                s = in.readLine();
            }
        }
    }

    @Override
    public String getMemoryName() {
        return this.file.getPath();
    }

    @Override
    public String getProviderName() {
        return this.file.getPath().substring(this.file.getPath().lastIndexOf(46) + 1) + " file";
    }

    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) {
        return this.entries;
    }

    public List<PrepareTMXEntry> getEntries() {
        return this.entries;
    }

    @Override
    public boolean isWriteMode() {
        return this.write;
    }

    @Override
    public boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        return true;
    }

    @Override
    public void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception {
        if (!this.file.exists()) {
            File parentFile = this.file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            this.file.createNewFile();
        }
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), this.code);
        ((Writer)wr).append(WF_DATE_FORMAT.format(entryContents.creationDate)).append('\t');
        ((Writer)wr).append(entryContents.creator).append('\t');
        long version = 0L;
        for (PrepareTMXEntry pe : this.entries) {
            if (!pe.source.equals(entryContents.source) || version >= pe.changeDate) continue;
            version = pe.changeDate + 1L;
        }
        ((Writer)wr).append(Long.toString(version)).append('\t');
        ((Writer)wr).append(sLang.toString()).append('\t').append(entryContents.source.replace("\t", "&'9;")).append('\t');
        ((Writer)wr).append(tLang.toString()).append('\t').append(entryContents.translation.replace("\t", "&'9;"));
        ((Writer)wr).append(System.getProperty("line.separator"));
        ((Writer)wr).close();
    }

    private static boolean isUTF16LE(File file) throws IOException {
        boolean ret = false;
        try (FileInputStream stream = new FileInputStream(file);){
            byte[] bytes = new byte[2];
            if (stream.read(bytes, 0, 2) == 2 && bytes[0] == -1 && bytes[1] == -2) {
                ret = true;
            }
        }
        return ret;
    }
}

