/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.omegat.core.Core;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.tokenizer.Tokenizer;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public final class PluginUtils {
    public static final String PLUGINS_LIST_FILE = "Plugins.properties";
    protected static ClassLoader pluginsClassLoader;
    protected static final List<Class<?>> LOADED_PLUGINS;
    protected static final List<Class<?>> FILTER_CLASSES;
    protected static final List<Class<?>> TOKENIZER_CLASSES;
    protected static final List<Class<?>> MARKER_CLASSES;
    protected static final List<Class<?>> MACHINE_TRANSLATION_CLASSES;
    protected static final List<Class<?>> TRANSLATION_MEMORY_CLASSES;
    protected static final List<Class<?>> GLOSSARY_CLASSES;
    protected static final List<Class<?>> BASE_PLUGIN_CLASSES;

    private PluginUtils() {
    }

    public static ClassLoader getPluginsClassLoader() {
        if (pluginsClassLoader != null) {
            return pluginsClassLoader;
        }
        pluginsClassLoader = PluginUtils.buildClassLoader(new File(StaticUtils.getConfigDir(), "plugins"), pluginsClassLoader);
        pluginsClassLoader = PluginUtils.buildClassLoader(new File(StaticUtils.installDir(), "plugins"), pluginsClassLoader);
        return pluginsClassLoader;
    }

    private static ClassLoader buildClassLoader(File location, ClassLoader parent) {
        if (parent == null) {
            parent = PluginUtils.class.getClassLoader();
        }
        if (!location.exists()) {
            return parent;
        }
        FileFilter jarFilter = pathname -> pathname.getName().endsWith(".jar");
        List<File> fs = FileUtil.findFiles(location, jarFilter);
        ArrayList<URL> urlList = new ArrayList<URL>(fs.size());
        for (File theFile : fs) {
            try {
                URL toURL = theFile.toURI().toURL();
                urlList.add(toURL);
                Log.logInfoRB("PLUGIN_LOAD_JAR", toURL);
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        if (urlList.size() > 0) {
            return new URLClassLoader(urlList.toArray(new URL[0]), parent);
        }
        return parent;
    }

    public static void loadPlugins(Map<String, String> params) {
        block25: {
            try {
                boolean foundMain = false;
                if (pluginsClassLoader == null) {
                    pluginsClassLoader = PluginUtils.getPluginsClassLoader();
                }
                Enumeration<URL> mlist = pluginsClassLoader.getResources("META-INF/MANIFEST.MF");
                while (mlist.hasMoreElements()) {
                    String[] mu = mlist.nextElement();
                    InputStream in = mu.openStream();
                    try {
                        Manifest m = new Manifest(in);
                        if ("org.omegat.Main".equals(m.getMainAttributes().getValue("Main-Class"))) {
                            foundMain = true;
                        }
                        PluginUtils.loadFromManifest(m, pluginsClassLoader);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                if (foundMain) break block25;
                String manifests = params.get("dev-manifests");
                if (manifests != null) {
                    for (String mf : manifests.split(File.pathSeparator)) {
                        try (FileInputStream in = new FileInputStream(mf);){
                            PluginUtils.loadFromManifest(new Manifest(in), pluginsClassLoader);
                        }
                    }
                    break block25;
                }
                Properties props = new Properties();
                try (FileInputStream fis = new FileInputStream(PLUGINS_LIST_FILE);){
                    props.load(fis);
                    PluginUtils.loadFromProperties(props, pluginsClassLoader);
                }
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        for (Class<?> pl : BASE_PLUGIN_CLASSES) {
            try {
                pl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    public static List<Class<?>> getFilterClasses() {
        return FILTER_CLASSES;
    }

    public static List<Class<?>> getTokenizerClasses() {
        return TOKENIZER_CLASSES;
    }

    public static Class<?> getTokenizerClassForLanguage(Language lang) {
        if (lang == null) {
            return DefaultTokenizer.class;
        }
        Class<?> exactResult = PluginUtils.searchForTokenizer(lang.getLanguage());
        if (PluginUtils.isDefault(exactResult)) {
            return exactResult;
        }
        Class<?> generalResult = PluginUtils.searchForTokenizer(lang.getLanguageCode());
        if (PluginUtils.isDefault(generalResult)) {
            return generalResult;
        }
        if (exactResult != null) {
            return exactResult;
        }
        if (generalResult != null) {
            return generalResult;
        }
        return DefaultTokenizer.class;
    }

    private static boolean isDefault(Class<?> c) {
        if (c == null) {
            return false;
        }
        Tokenizer ann = c.getAnnotation(Tokenizer.class);
        return ann == null ? false : ann.isDefault();
    }

    private static Class<?> searchForTokenizer(String lang) {
        if (lang.isEmpty()) {
            return null;
        }
        lang = lang.toLowerCase(Locale.ENGLISH);
        Class<?> fallback = null;
        for (Class<?> c : TOKENIZER_CLASSES) {
            Tokenizer ann = c.getAnnotation(Tokenizer.class);
            if (ann == null) continue;
            String[] languages = ann.languages();
            try {
                if (languages.length == 1 && languages[0].equals("discoverAtRuntime")) {
                    languages = ((ITokenizer)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getSupportedLanguages();
                }
            }
            catch (Exception ex) {
                Log.log(ex);
            }
            for (String s : languages) {
                if (!lang.equals(s)) continue;
                if (ann.isDefault()) {
                    return c;
                }
                if (fallback != null) continue;
                fallback = c;
            }
        }
        return fallback;
    }

    public static List<Class<?>> getMarkerClasses() {
        return MARKER_CLASSES;
    }

    public static List<Class<?>> getMachineTranslationClasses() {
        return MACHINE_TRANSLATION_CLASSES;
    }

    public static List<Class<?>> getTranslationMemoryClasses() {
        return TRANSLATION_MEMORY_CLASSES;
    }

    public static List<Class<?>> getGlossaryClasses() {
        return GLOSSARY_CLASSES;
    }

    protected static void loadFromManifest(Manifest m, ClassLoader classLoader) throws ClassNotFoundException {
        String pluginClasses = m.getMainAttributes().getValue("OmegaT-Plugins");
        if (pluginClasses != null) {
            for (String clazz : pluginClasses.split("\\s+")) {
                if (clazz.trim().isEmpty()) continue;
                PluginUtils.loadClass(clazz, classLoader);
            }
        }
        PluginUtils.loadFromManifestOld(m, classLoader);
    }

    protected static void loadFromProperties(Properties props, ClassLoader classLoader) throws ClassNotFoundException {
        for (Object o : props.keySet()) {
            String key = o.toString();
            String[] classes = props.getProperty(key).split("\\s+");
            if (key.equals("plugin")) {
                for (String clazz : classes) {
                    PluginUtils.loadClass(clazz, classLoader);
                }
                continue;
            }
            for (String clazz : classes) {
                PluginUtils.loadClassOld(key, clazz, classLoader);
            }
        }
    }

    protected static void loadClass(String clazz, ClassLoader classLoader) {
        try {
            Class<?> c = classLoader.loadClass(clazz);
            if (LOADED_PLUGINS.contains(c)) {
                Log.logInfoRB("PLUGIN_SKIP_PREVIOUSLY_LOADED", clazz);
                return;
            }
            Method load = c.getMethod("loadPlugins", new Class[0]);
            load.invoke(c, new Object[0]);
            LOADED_PLUGINS.add(c);
            Log.logInfoRB("PLUGIN_LOAD_OK", clazz);
        }
        catch (Throwable ex) {
            Log.logErrorRB(ex, "PLUGIN_LOAD_ERROR", clazz, ex.getClass().getSimpleName(), ex.getMessage());
            Core.pluginLoadingError(StringUtil.format(OStrings.getString("PLUGIN_LOAD_ERROR"), clazz, ex.getClass().getSimpleName(), ex.getMessage()));
        }
    }

    public static void unloadPlugins() {
        for (Class<?> p : LOADED_PLUGINS) {
            try {
                Method load = p.getMethod("unloadPlugins", new Class[0]);
                load.invoke(p, new Object[0]);
            }
            catch (Throwable ex) {
                Log.logErrorRB(ex, "PLUGIN_UNLOAD_ERROR", p.getClass().getSimpleName(), ex.getMessage());
            }
        }
    }

    protected static void loadFromManifestOld(Manifest m, ClassLoader classLoader) throws ClassNotFoundException {
        if (m.getMainAttributes().getValue("OmegaT-Plugin") == null) {
            return;
        }
        Map<String, Attributes> entries = m.getEntries();
        for (Map.Entry<String, Attributes> e : entries.entrySet()) {
            String key = e.getKey();
            Attributes attrs = e.getValue();
            String sType = attrs.getValue("OmegaT-Plugin");
            if ("true".equals(attrs.getValue("OmegaT-Tokenizer"))) {
                sType = "tokenizer";
            }
            if (sType == null) continue;
            PluginUtils.loadClassOld(sType, key, classLoader);
        }
    }

    protected static void loadClassOld(String sType, String key, ClassLoader classLoader) throws ClassNotFoundException {
        PluginType pType;
        try {
            pType = PluginType.valueOf(sType.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception ex) {
            pType = PluginType.UNKNOWN;
        }
        switch (pType) {
            case FILTER: {
                FILTER_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case TOKENIZER: {
                TOKENIZER_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case MARKER: {
                MARKER_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case MACHINETRANSLATOR: {
                MACHINE_TRANSLATION_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case TRANSLATION_MEMORY: {
                TRANSLATION_MEMORY_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case BASE: {
                BASE_PLUGIN_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case GLOSSARY: {
                GLOSSARY_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            default: {
                Log.logErrorRB("PLUGIN_UNKNOWN", sType, key);
            }
        }
    }

    static {
        LOADED_PLUGINS = new ArrayList();
        FILTER_CLASSES = new ArrayList();
        TOKENIZER_CLASSES = new ArrayList();
        MARKER_CLASSES = new ArrayList();
        MACHINE_TRANSLATION_CLASSES = new ArrayList();
        TRANSLATION_MEMORY_CLASSES = new ArrayList();
        GLOSSARY_CLASSES = new ArrayList();
        BASE_PLUGIN_CLASSES = new ArrayList();
    }

    static enum PluginType {
        FILTER,
        TOKENIZER,
        MARKER,
        MACHINETRANSLATOR,
        TRANSLATION_MEMORY,
        BASE,
        GLOSSARY,
        UNKNOWN;

    }
}

