/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocString {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/madlonkay/supertmxmerge/Strings");
    private static final List<ResourceBundle> moreBundles = new ArrayList<ResourceBundle>();
    private static final Logger LOGGER = Logger.getLogger(LocString.class.getName());

    public static String get(String id) {
        for (int i = moreBundles.size() - 1; i >= 0; --i) {
            try {
                return moreBundles.get(i).getString(id);
            }
            catch (MissingResourceException ex) {
                LOGGER.log(Level.FINE, "Resource " + id + " not found in supplied resource bundle", ex);
                continue;
            }
        }
        return bundle.getString(id);
    }

    public static String getFormat(String id, Object ... var) {
        return MessageFormat.format(LocString.get(id), var);
    }

    public static void addBundle(ResourceBundle bundle) {
        if (bundle == null) {
            return;
        }
        if (!moreBundles.contains(bundle)) {
            moreBundles.add(bundle);
        }
    }
}

