/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.awt.Window;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import javax.swing.FocusManager;
import org.jasypt.exceptions.AlreadyInitializedException;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.util.text.BasicTextEncryptor;
import org.omegat.core.Core;
import org.omegat.gui.dialogs.PasswordEnterDialogController;
import org.omegat.gui.dialogs.PasswordSetDialogController;
import org.omegat.gui.main.IMainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.UIThreadsUtil;

public final class CredentialsManager {
    private static final Logger LOGGER = Logger.getLogger(CredentialsManager.class.getName());
    private static final String CREDENTIALS_MANAGER_CANARY = "credentials_manager_canary";
    private static final String CREDENTIALS_MASTER_PASSWORD = "credentials_master_password";
    private final IPasswordPrompt prompt = new GuiPasswordPrompt();
    private BasicTextEncryptor textEncryptor = new BasicTextEncryptor();

    public static CredentialsManager getInstance() {
        return SingletonHelper.INSTANCE;
    }

    private CredentialsManager() {
    }

    public boolean store(String key, String value) {
        if (value.isEmpty()) {
            this.clear(key);
            return true;
        }
        Optional<String> encrypted = this.encrypt(value);
        encrypted.ifPresent(ev -> Preferences.setPreference(key, ev));
        return encrypted.isPresent();
    }

    public boolean isStored(String key) {
        return this.isMasterPasswordSet() && !Preferences.getPreference(key).isEmpty();
    }

    private synchronized Optional<String> encrypt(String text) {
        while (true) {
            try {
                return Optional.of(this.textEncryptor.encrypt(text));
            }
            catch (EncryptionInitializationException e) {
                if (this.onEncryptionFailed()) continue;
                return Optional.empty();
            }
            break;
        }
    }

    private void setEncryptionKey(char[] password) {
        try {
            this.textEncryptor.setPasswordCharArray(password);
        }
        catch (AlreadyInitializedException e) {
            this.textEncryptor = new BasicTextEncryptor();
            this.setEncryptionKey(password);
        }
    }

    private void setMasterPassword(char[] masterPassword) {
        this.setEncryptionKey(masterPassword);
        this.store(CREDENTIALS_MANAGER_CANARY, CREDENTIALS_MANAGER_CANARY);
    }

    public boolean isMasterPasswordSet() {
        return !Preferences.getPreference(CREDENTIALS_MANAGER_CANARY).isEmpty();
    }

    public boolean isMasterPasswordStored() {
        return this.isMasterPasswordSet() && !Preferences.getPreference(CREDENTIALS_MASTER_PASSWORD).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMasterPassword() {
        this.clear(CREDENTIALS_MANAGER_CANARY);
        this.clear(CREDENTIALS_MASTER_PASSWORD);
        CredentialsManager credentialsManager = this;
        synchronized (credentialsManager) {
            this.textEncryptor = new BasicTextEncryptor();
        }
    }

    public void clear(String key) {
        Preferences.setPreference(key, "");
    }

    public Optional<String> retrieve(String key) {
        String encrypted = Preferences.getPreference(key);
        if (encrypted.isEmpty()) {
            return Optional.empty();
        }
        return this.decrypt(encrypted);
    }

    private Optional<String> decrypt(String text) {
        if (!this.isMasterPasswordSet()) {
            LOGGER.warning("Trying to retrieve encrypted credentials but no master password has been set.");
            return Optional.empty();
        }
        CredentialsManager credentialsManager = this;
        synchronized (credentialsManager) {
            while (true) {
                try {
                    return Optional.of(this.textEncryptor.decrypt(text));
                }
                catch (EncryptionOperationNotPossibleException e) {
                    LOGGER.severe("Could not decrypt stored credential with supposedly correct master password.");
                    return Optional.empty();
                }
                catch (EncryptionInitializationException e) {
                    if (this.onDecryptionFailed()) continue;
                    return Optional.empty();
                }
                break;
            }
        }
    }

    private boolean onEncryptionFailed() {
        if (this.isMasterPasswordSet()) {
            if (this.useStoredMasterPassword()) {
                return true;
            }
            return this.promptForExistingPassword();
        }
        return this.promptForCreatingPassword();
    }

    private boolean useStoredMasterPassword() {
        String mp = Preferences.getPreference(CREDENTIALS_MASTER_PASSWORD);
        if (!mp.isEmpty()) {
            this.setEncryptionKey(mp.toCharArray());
            if (this.checkCanary()) {
                return true;
            }
        }
        return false;
    }

    private boolean promptForCreatingPassword() {
        PasswordSetResult result = this.prompt.createNewPassword();
        switch (result.responseType) {
            case USE_INPUT: {
                this.setMasterPassword(result.password);
                Arrays.fill(result.password, '\u0000');
                return true;
            }
            case GENERATE_AND_STORE: {
                String pwd = UUID.randomUUID().toString();
                this.setMasterPassword(pwd.toCharArray());
                Preferences.setPreference(CREDENTIALS_MASTER_PASSWORD, pwd);
                return true;
            }
            case CANCEL: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown response: " + (Object)((Object)result.responseType));
    }

    private boolean onDecryptionFailed() {
        if (!this.isMasterPasswordSet()) {
            return false;
        }
        if (this.useStoredMasterPassword()) {
            return true;
        }
        return this.promptForExistingPassword();
    }

    private boolean promptForExistingPassword() {
        Optional<char[]> result;
        String message = OStrings.getString("PASSWORD_ENTER_MESSAGE");
        while ((result = this.prompt.getExistingPassword(message)).isPresent()) {
            this.setEncryptionKey(result.get());
            if (this.checkCanary()) {
                return true;
            }
            message = OStrings.getString("PASSWORD_TRY_AGAIN_MESSAGE");
        }
        LOGGER.info("User declined to input master password");
        return false;
    }

    private boolean checkCanary() {
        if (!this.isMasterPasswordSet()) {
            return false;
        }
        try {
            String decrypted = this.textEncryptor.decrypt(Preferences.getPreference(CREDENTIALS_MANAGER_CANARY));
            return CREDENTIALS_MANAGER_CANARY.equals(decrypted);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class GuiPasswordPrompt
    implements IPasswordPrompt {
        private GuiPasswordPrompt() {
        }

        @Override
        public Optional<char[]> getExistingPassword(String message) {
            return UIThreadsUtil.returnResultFromSwingThread(() -> {
                PasswordEnterDialogController dialog = new PasswordEnterDialogController();
                dialog.show(this.getParentWindow(), message);
                return dialog.getResult();
            });
        }

        @Override
        public PasswordSetResult createNewPassword() {
            return UIThreadsUtil.returnResultFromSwingThread(() -> {
                PasswordSetDialogController dialog = new PasswordSetDialogController();
                dialog.show(this.getParentWindow());
                return dialog.getResult();
            });
        }

        private Window getParentWindow() {
            IMainWindow mw;
            Window window = FocusManager.getCurrentManager().getActiveWindow();
            if (window == null && (mw = Core.getMainWindow()) != null) {
                window = mw.getApplicationFrame();
            }
            return window;
        }
    }

    public static class PasswordSetResult {
        public final ResponseType responseType;
        public final char[] password;

        public PasswordSetResult(ResponseType responseType, char[] password) {
            this.responseType = responseType;
            this.password = password;
        }
    }

    public static enum ResponseType {
        USE_INPUT,
        GENERATE_AND_STORE,
        CANCEL;

    }

    private static class SingletonHelper {
        private static final CredentialsManager INSTANCE = new CredentialsManager();

        private SingletonHelper() {
        }
    }

    public static interface IPasswordPrompt {
        public Optional<char[]> getExistingPassword(String var1);

        public PasswordSetResult createNewPassword();
    }
}

