/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.lucene;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.lucene.NgramAnalyzer;
import org.omegat.util.TMXProp;

public class LuceneWriter {
    private IndexWriter indexWriter;
    private NgramAnalyzer analyzer;
    private File indexDir;

    public LuceneWriter(File indexDirectory, boolean createNewTmIndex) throws IOException {
        this.indexDir = indexDirectory;
        this.analyzer = new NgramAnalyzer();
        this.indexWriter = new IndexWriter((Directory)FSDirectory.open((Path)indexDirectory.toPath()), new IndexWriterConfig((Analyzer)this.analyzer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexAll(Iterable<PrepareTMXEntry> entries) throws Exception {
        this.analyzer.calcstopNgrams(entries, this.indexDir);
        try {
            for (PrepareTMXEntry tu : entries) {
                Document doc = this.createDocument(tu);
                if (doc == null) continue;
                this.indexWriter.addDocument((Iterable)doc);
            }
        }
        finally {
            try {
                this.indexWriter.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() throws Exception {
        this.indexWriter.close();
    }

    public Document createDocument(PrepareTMXEntry tu) {
        Document doc = new Document();
        doc.add((IndexableField)new TextField("src", tu.source, Field.Store.YES));
        if (tu.translation != null) {
            doc.add((IndexableField)new StoredField("tra", tu.translation));
        }
        if (tu.creator != null) {
            doc.add((IndexableField)new StoredField("author", tu.creator));
        }
        if (tu.changer != null) {
            doc.add((IndexableField)new StoredField("changer", tu.changer));
        }
        doc.add((IndexableField)new StoredField("creationDate", tu.creationDate));
        doc.add((IndexableField)new StoredField("changeDate", tu.changeDate));
        for (TMXProp prop : tu.otherProperties) {
            doc.add((IndexableField)new StoredField("prop." + prop.getType(), prop.getValue()));
        }
        return doc;
    }
}

