/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.rmi;

import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.external.rmi.ProjectServer;

public class GUIServer
extends ProjectServer
implements IEntryEventListener,
IProjectEventListener {
    public static final long serialVersionUID = 1L;

    public GUIServer() throws RemoteException {
        CoreEvents.registerEntryEventListener(this);
        CoreEvents.registerProjectChangeListener(this);
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case CLOSE: 
            case CREATE: 
            case LOAD: {
                this.changes.clear();
                this.used.clear();
            }
        }
    }

    @Override
    public void onNewFile(String activeFileName) {
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        try {
            if (this.changes.size() > 0) {
                HashSet<Integer> set = new HashSet<Integer>();
                set.addAll(this.changes);
                Iterator iterator = this.changes.iterator();
                while (iterator.hasNext()) {
                    int change = (Integer)iterator.next();
                    for (SourceTextEntry dup : Core.getProject().getAllEntries().get(change - 1).getDuplicates()) {
                        set.add(dup.entryNum());
                    }
                }
                Core.getEditor().commitAndDeactivate();
                Core.getEditor().refreshEntries(set);
                Core.getEditor().activateEntry();
            }
            this.changes.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.used.add(newEntry);
    }
}

