/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import org.omegat.filters3.Attribute;
import org.omegat.filters3.Tag;
import org.omegat.filters3.xml.XMLUtils;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.util.Language;
import org.xml.sax.Attributes;

public class XMLTag
extends Tag {
    private Language targetLanguage;

    public XMLTag(String tag, String shortcut, Tag.Type type, Attributes attributes, Language targetLanguage) {
        super(tag, shortcut, type, XMLUtils.convertAttributes(attributes));
        this.targetLanguage = targetLanguage;
    }

    @Override
    public String toOriginal() {
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        if (Tag.Type.END == this.getType()) {
            buf.append("/");
        }
        buf.append(this.getTag());
        buf.append(this.getAttributes().toString());
        if (this.getTag().equalsIgnoreCase("w:t") && Tag.Type.BEGIN == this.getType()) {
            Boolean preserve = false;
            for (int i = 0; i < this.getAttributes().size(); ++i) {
                Attribute oneAttribute = this.getAttributes().get(i);
                if (!oneAttribute.getName().equalsIgnoreCase("xml:space")) continue;
                preserve = true;
                break;
            }
            if (!preserve.booleanValue()) {
                buf.append(" xml:space=\"preserve\"");
            }
        }
        boolean alreadyClosed = false;
        if (EditorUtils.isRTL(this.targetLanguage.getLanguageCode())) {
            if (this.getTag().equalsIgnoreCase("w:pPr") && Tag.Type.BEGIN == this.getType()) {
                buf.append("><w:bidi/");
            } else if (this.getTag().equalsIgnoreCase("w:sectPr") && Tag.Type.BEGIN == this.getType()) {
                buf.append("><w:bidi/");
            } else if (this.getTag().equalsIgnoreCase("w:rPr") && Tag.Type.BEGIN == this.getType()) {
                buf.append("><w:rtl/");
            } else if (this.getTag().equalsIgnoreCase("w:tblPr") && Tag.Type.BEGIN == this.getType()) {
                buf.append("><w:bidiVisual/");
            } else if (this.getTag().equalsIgnoreCase("w:tblStyle") && Tag.Type.ALONE == this.getType()) {
                buf.append("/><w:bidiVisual/");
                alreadyClosed = true;
            }
        }
        if (Tag.Type.ALONE == this.getType() && !alreadyClosed) {
            buf.append("/");
        }
        buf.append(">");
        return buf.toString();
    }
}

