/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.mark.EntryMarks;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.util.Log;

public class CalcMarkersThread
extends Thread {
    private final Queue<EntryMarks> forCheck = new LinkedList<EntryMarks>();
    private final MarkerController mController;
    private final int markerIndex;
    public final IMarker marker;

    public CalcMarkersThread(MarkerController mc, IMarker marker, int markerIndex) {
        this.mController = mc;
        this.markerIndex = markerIndex;
        this.marker = marker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Queue<EntryMarks> queue = this.forCheck;
        synchronized (queue) {
            this.forCheck.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SegmentBuilder[] entryBuilders) {
        ArrayList<EntryMarks> vers = new ArrayList<EntryMarks>(entryBuilders.length);
        for (int i = 0; i < entryBuilders.length; ++i) {
            SegmentBuilder builder = entryBuilders[i];
            if (!builder.hasBeenCreated()) continue;
            EntryMarks v = new EntryMarks(builder, builder.getDisplayVersion(), this.markerIndex);
            vers.add(v);
        }
        Queue<EntryMarks> queue = this.forCheck;
        synchronized (queue) {
            this.forCheck.addAll(vers);
            this.forCheck.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SegmentBuilder entryBuilder) {
        EntryMarks v = new EntryMarks(entryBuilder, entryBuilder.getDisplayVersion(), this.markerIndex);
        Queue<EntryMarks> queue = this.forCheck;
        synchronized (queue) {
            this.forCheck.add(v);
            this.forCheck.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setPriority(1);
        Thread.currentThread().setName(this.getClass().getSimpleName() + " - " + this.marker.getClass().getSimpleName());
        block7: while (true) {
            try {
                while (true) {
                    EntryMarks ev;
                    Queue<EntryMarks> queue = this.forCheck;
                    synchronized (queue) {
                        ev = this.forCheck.poll();
                        if (ev == null) {
                            this.forCheck.wait();
                        }
                    }
                    if (ev == null) continue;
                    try {
                        if (ev.isSegmentChanged()) continue;
                        ev.result = this.marker.getMarksForEntry(ev.ste, ev.sourceText, ev.translationText, ev.isActive);
                        if (ev.result == null || ev.isSegmentChanged()) continue;
                        this.mController.queueMarksOutput(ev);
                        continue block7;
                    }
                    catch (Throwable ex) {
                        Log.log(ex);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                Log.log(ex);
                return;
            }
        }
    }
}

