/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import com.vlsolutions.swing.docking.AutoHidePolicy;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.ui.DockingUISettings;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ColorUIResource;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.gui.CustomContainerFactory;
import org.omegat.util.gui.ResourcesUtil;
import org.omegat.util.gui.RoundedCornerBorder;
import org.omegat.util.gui.Styles;

public final class DockingUI {
    private DockingUI() {
    }

    public static void initialize() {
        DockingUISettings.getInstance().installUI();
        DockableContainerFactory.setFactory((DockableContainerFactory)new CustomContainerFactory());
        AutoHidePolicy.getPolicy().setExpandMode(AutoHidePolicy.ExpandMode.EXPAND_ON_ROLLOVER);
        UIManager.put("DockViewTitleBar.minimizeButtonText", OStrings.getString("DOCKING_HINT_MINIMIZE"));
        UIManager.put("DockViewTitleBar.maximizeButtonText", OStrings.getString("DOCKING_HINT_MAXIMIZE"));
        UIManager.put("DockViewTitleBar.restoreButtonText", OStrings.getString("DOCKING_HINT_RESTORE"));
        UIManager.put("DockViewTitleBar.attachButtonText", OStrings.getString("DOCKING_HINT_DOCK"));
        UIManager.put("DockViewTitleBar.floatButtonText", OStrings.getString("DOCKING_HINT_UNDOCK"));
        UIManager.put("DockViewTitleBar.closeButtonText", "");
        UIManager.put("DockTabbedPane.minimizeButtonText", OStrings.getString("DOCKING_HINT_MINIMIZE"));
        UIManager.put("DockTabbedPane.maximizeButtonText", OStrings.getString("DOCKING_HINT_MAXIMIZE"));
        UIManager.put("DockTabbedPane.restoreButtonText", OStrings.getString("DOCKING_HINT_RESTORE"));
        UIManager.put("DockTabbedPane.floatButtonText", OStrings.getString("DOCKING_HINT_UNDOCK"));
        UIManager.put("DockTabbedPane.closeButtonText", "");
        Font defaultFont = UIManager.getFont("Label.font");
        UIManager.put("DockViewTitleBar.titleFont", defaultFont);
        UIManager.put("JTabbedPaneSmartIcon.font", defaultFont);
        UIManager.put("AutoHideButton.font", defaultFont);
        UIManager.put("DockViewTitleBar.isCloseButtonDisplayed", false);
        UIManager.put("DockingDesktop.closeActionAccelerator", null);
        UIManager.put("DockingDesktop.maximizeActionAccelerator", null);
        UIManager.put("DockingDesktop.dockActionAccelerator", null);
        UIManager.put("DockingDesktop.floatActionAccelerator", null);
        UIManager.put("DockViewTitleBar.menu.close", DockingUI.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close", DockingUI.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close.rollover", DockingUI.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close.pressed", DockingUI.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.close", DockingUI.getIcon("empty.gif"));
        DockingUI.installFlatDesign();
        UIManager.put("DockingDesktop.notificationBlinkCount", 2);
        UIManager.put("DockingDesktop.notificationColor", Styles.EditorColor.COLOR_NOTIFICATION_MAX.getColor());
        DockingUI.ensureTitlebarReadability();
    }

    private static void installClassicDesign() {
        UIManager.put("OmegaTStatusArea.border", new MatteBorder(1, 1, 1, 1, Color.BLACK));
        UIManager.put("DockViewTitleBar.hide", DockingUI.getIcon("minimize.gif"));
        UIManager.put("DockViewTitleBar.hide.rollover", DockingUI.getIcon("minimize.rollover.gif"));
        UIManager.put("DockViewTitleBar.hide.pressed", DockingUI.getIcon("minimize.pressed.gif"));
        UIManager.put("DockViewTitleBar.maximize", DockingUI.getIcon("maximize.gif"));
        UIManager.put("DockViewTitleBar.maximize.rollover", DockingUI.getIcon("maximize.rollover.gif"));
        UIManager.put("DockViewTitleBar.maximize.pressed", DockingUI.getIcon("maximize.pressed.gif"));
        UIManager.put("DockViewTitleBar.restore", DockingUI.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.restore.rollover", DockingUI.getIcon("restore.rollover.gif"));
        UIManager.put("DockViewTitleBar.restore.pressed", DockingUI.getIcon("restore.pressed.gif"));
        UIManager.put("DockViewTitleBar.dock", DockingUI.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.dock.rollover", DockingUI.getIcon("restore.rollover.gif"));
        UIManager.put("DockViewTitleBar.dock.pressed", DockingUI.getIcon("restore.pressed.gif"));
        UIManager.put("DockViewTitleBar.float", DockingUI.getIcon("undock.gif"));
        UIManager.put("DockViewTitleBar.float.rollover", DockingUI.getIcon("undock.rollover.gif"));
        UIManager.put("DockViewTitleBar.float.pressed", DockingUI.getIcon("undock.pressed.gif"));
        UIManager.put("DockViewTitleBar.attach", DockingUI.getIcon("dock.gif"));
        UIManager.put("DockViewTitleBar.attach.rollover", DockingUI.getIcon("dock.rollover.gif"));
        UIManager.put("DockViewTitleBar.attach.pressed", DockingUI.getIcon("dock.pressed.gif"));
        UIManager.put("DockViewTitleBar.menu.hide", DockingUI.getIcon("minimize.gif"));
        UIManager.put("DockViewTitleBar.menu.maximize", DockingUI.getIcon("maximize.gif"));
        UIManager.put("DockViewTitleBar.menu.restore", DockingUI.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.menu.dock", DockingUI.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.menu.float", DockingUI.getIcon("undock.gif"));
        UIManager.put("DockViewTitleBar.menu.attach", DockingUI.getIcon("dock.gif"));
        UIManager.put("DockTabbedPane.menu.hide", DockingUI.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.maximize", DockingUI.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.float", DockingUI.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.closeAll", DockingUI.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.closeAllOther", DockingUI.getIcon("empty.gif"));
        UIManager.put("DragControler.detachCursor", DockingUI.getIcon("undock.gif").getImage());
    }

    private static void ensureTitlebarReadability() {
        Color textColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        Color backColor = UIManager.getColor("Panel.background");
        if (textColor != null && backColor != null && textColor.equals(backColor)) {
            float[] hsb = Color.RGBtoHSB(textColor.getRed(), textColor.getGreen(), textColor.getBlue(), null);
            float brightness = hsb[2];
            brightness = brightness >= 0.5f ? (brightness -= 0.5f) : (brightness += 0.5f);
            int rgb = Color.HSBtoRGB(hsb[0], hsb[1], brightness);
            ColorUIResource res = new ColorUIResource(rgb);
            UIManager.put("InternalFrame.inactiveTitleForeground", res);
        }
        UIManager.put("DockingDesktop.notificationBlinkCount", 2);
        UIManager.put("DockingDesktop.notificationColor", Styles.EditorColor.COLOR_NOTIFICATION_MAX.getColor());
    }

    private static void installFlatDesign() {
        Color standardBgColor = UIManager.getColor("Panel.background");
        Color activeTitleBgColor = DockingUI.adjustRGB(standardBgColor, 8);
        Color bottomAreaBgColor = DockingUI.adjustRGB(standardBgColor, -16);
        Color borderColor = DockingUI.adjustRGB(standardBgColor, -83);
        UIManager.put("OmegaTBorder.color", borderColor);
        Color statusAreaColor = DockingUI.adjustRGB(standardBgColor, -151);
        UIManager.put("VLDocking.highlight", activeTitleBgColor);
        UIManager.put("VLDocking.shadow", statusAreaColor);
        int outside = 5;
        UIManager.put("DockingDesktop.border", new EmptyBorder(outside, outside, outside, outside));
        int panel = 2;
        UIManager.put("DockView.singleDockableBorder", new EmptyBorder(panel, panel, panel, panel));
        int maxPanel = outside + panel;
        UIManager.put("DockView.maximizedDockableBorder", new EmptyBorder(maxPanel, maxPanel, maxPanel, maxPanel));
        UIManager.put("OmegaTDockablePanel.border", new MatteBorder(1, 1, 1, 1, borderColor));
        UIManager.put("OmegaTDockablePanelViewport.border", new EmptyBorder(0, 0, 0, 0));
        UIManager.put("OmegaTDockablePanel.isProportionalMargins", true);
        if (Platform.isMacOSX()) {
            UIManager.put("DockView.tabbedDockableBorder", new MatteBorder(0, 5, 5, 5, new Color(0xE6E6E6)));
        } else if (DockingUI.isWindowsLAF() && !DockingUI.isWindowsClassicLAF()) {
            UIManager.put("DockView.tabbedDockableBorder", new MatteBorder(2, 5, 5, 5, Color.WHITE));
        } else {
            UIManager.put("DockView.tabbedDockableBorder", new MatteBorder(5, 5, 5, 5, standardBgColor));
        }
        int cornerRadius = DockingUI.isFlatWindows() ? 0 : 8;
        Color activeTitleText = UIManager.getColor("Label.foreground");
        Color inactiveTitleText = DockingUI.adjustRGB(activeTitleText, 128);
        UIManager.put("DockViewTitleBar.border", new RoundedCornerBorder(cornerRadius, borderColor, 0));
        UIManager.put("InternalFrame.activeTitleForeground", activeTitleText);
        UIManager.put("InternalFrame.activeTitleBackground", activeTitleBgColor);
        UIManager.put("InternalFrame.inactiveTitleForeground", inactiveTitleText);
        UIManager.put("InternalFrame.inactiveTitleBackground", standardBgColor);
        UIManager.put("DockViewTitleBar.disableCustomPaint", true);
        UIManager.put("AutoHideButtonPanel.bottomBorder", new CompoundBorder(new MatteBorder(1, 0, 0, 0, borderColor), new EmptyBorder(0, 2 * outside, 0, 2 * outside)));
        UIManager.put("AutoHideButtonPanel.background", bottomAreaBgColor);
        UIManager.put("AutoHideButton.expandBorderBottom", new RoundedCornerBorder(cornerRadius, borderColor, 2));
        UIManager.put("AutoHideButton.background", standardBgColor);
        UIManager.put("OmegaTStatusArea.border", new MatteBorder(1, 1, 1, 1, statusAreaColor));
        UIManager.put("OmegaTMainWindowBottomMargin.border", new EmptyBorder(0, 2 * outside, outside, 2 * outside));
        UIManager.put("OmegaTEditorFilter.border", new MatteBorder(1, 1, 0, 1, borderColor));
        UIManager.put("activeCaption", Color.WHITE);
        UIManager.put("activeCaptionBorder", borderColor);
        UIManager.put("inactiveCaption", standardBgColor);
        UIManager.put("inactiveCaptionBorder", borderColor);
        UIManager.put("DockViewTitleBar.maximize", DockingUI.getIcon("appbar.app.tall.inactive.png"));
        UIManager.put("DockViewTitleBar.maximize.rollover", DockingUI.getIcon("appbar.app.tall.png"));
        UIManager.put("DockViewTitleBar.maximize.pressed", DockingUI.getIcon("appbar.app.tall.pressed.png"));
        UIManager.put("DockViewTitleBar.restore", DockingUI.getIcon("appbar.window.restore.inactive.png"));
        UIManager.put("DockViewTitleBar.restore.rollover", DockingUI.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.restore.pressed", DockingUI.getIcon("appbar.window.restore.pressed.png"));
        UIManager.put("DockViewTitleBar.hide", DockingUI.getIcon("appbar.hide.inactive.png"));
        UIManager.put("DockViewTitleBar.hide.rollover", DockingUI.getIcon("appbar.hide.png"));
        UIManager.put("DockViewTitleBar.hide.pressed", DockingUI.getIcon("appbar.hide.pressed.png"));
        UIManager.put("DockViewTitleBar.float", DockingUI.getIcon("appbar.fullscreen.inactive.png"));
        UIManager.put("DockViewTitleBar.float.rollover", DockingUI.getIcon("appbar.fullscreen.png"));
        UIManager.put("DockViewTitleBar.float.pressed", DockingUI.getIcon("appbar.fullscreen.pressed.png"));
        UIManager.put("DockViewTitleBar.dock", DockingUI.getIcon("appbar.window.restore.inactive.png"));
        UIManager.put("DockViewTitleBar.dock.rollover", DockingUI.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.dock.pressed", DockingUI.getIcon("appbar.window.restore.pressed.png"));
        UIManager.put("DockViewTitleBar.attach", DockingUI.getIcon("appbar.dock.window.inactive.png"));
        UIManager.put("DockViewTitleBar.attach.rollover", DockingUI.getIcon("appbar.dock.window.png"));
        UIManager.put("DockViewTitleBar.attach.pressed", DockingUI.getIcon("appbar.dock.window.pressed.png"));
        UIManager.put("DockViewTitleBar.menu.hide", DockingUI.getIcon("appbar.hide.png"));
        UIManager.put("DockViewTitleBar.menu.maximize", DockingUI.getIcon("appbar.app.tall.png"));
        UIManager.put("DockViewTitleBar.menu.restore", DockingUI.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.menu.dock", DockingUI.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.menu.float", DockingUI.getIcon("appbar.fullscreen.png"));
        UIManager.put("DockViewTitleBar.menu.attach", DockingUI.getIcon("appbar.dock.window.png"));
        UIManager.put("DockTabbedPane.menu.hide", DockingUI.getIcon("appbar.hide.png"));
        UIManager.put("DockTabbedPane.menu.maximize", DockingUI.getIcon("appbar.app.tall.png"));
        UIManager.put("DockTabbedPane.menu.float", DockingUI.getIcon("appbar.fullscreen.png"));
        UIManager.put("DragControler.detachCursor", ResourcesUtil.getBundledImage("appbar.fullscreen.cursor32x32.png"));
        if (Platform.isMacOSX()) {
            UIManager.put("DockViewTitleBar.maximize", DockingUI.getIcon("appbar.fullscreen.corners.inactive.png"));
            UIManager.put("DockViewTitleBar.maximize.rollover", DockingUI.getIcon("appbar.fullscreen.corners.png"));
            UIManager.put("DockViewTitleBar.maximize.pressed", DockingUI.getIcon("appbar.fullscreen.corners.pressed.png"));
            UIManager.put("DockViewTitleBar.restore", DockingUI.getIcon("appbar.restore.corners.inactive.png"));
            UIManager.put("DockViewTitleBar.restore.rollover", DockingUI.getIcon("appbar.restore.corners.png"));
            UIManager.put("DockViewTitleBar.restore.pressed", DockingUI.getIcon("appbar.restore.corners.pressed.png"));
            UIManager.put("DockViewTitleBar.hide", DockingUI.getIcon("appbar.minus.inactive.png"));
            UIManager.put("DockViewTitleBar.hide.rollover", DockingUI.getIcon("appbar.minus.png"));
            UIManager.put("DockViewTitleBar.hide.pressed", DockingUI.getIcon("appbar.minus.pressed.png"));
            UIManager.put("DockViewTitleBar.menu.hide", DockingUI.getIcon("appbar.minus.png"));
            UIManager.put("DockViewTitleBar.menu.maximize", DockingUI.getIcon("appbar.fullscreen.corners.png"));
            UIManager.put("DockViewTitleBar.menu.restore", DockingUI.getIcon("appbar.restore.corners.png"));
            UIManager.put("DockTabbedPane.menu.hide", DockingUI.getIcon("appbar.minus.png"));
            UIManager.put("DockTabbedPane.menu.maximize", DockingUI.getIcon("appbar.fullscreen.corners.png"));
            UIManager.put("DragControler.detachCursor", ResourcesUtil.getBundledImage("appbar.fullscreen.png"));
        }
    }

    private static Color adjustRGB(Color color, int adjustment) {
        Color result = new Color(Math.max(0, Math.min(255, color.getRed() + adjustment)), Math.max(0, Math.min(255, color.getGreen() + adjustment)), Math.max(0, Math.min(255, color.getBlue() + adjustment)));
        return result;
    }

    private static boolean isWindowsLAF() {
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }

    private static boolean isWindowsClassicLAF() {
        return DockingUI.isWindowsLAF() && (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive") == false;
    }

    private static boolean isFlatWindows() {
        return System.getProperty("os.name").startsWith("Windows") && System.getProperty("os.version").matches("6\\.[23]|10\\..*");
    }

    private static ImageIcon getIcon(String iconName) {
        Image image = ResourcesUtil.getBundledImage(iconName);
        return image == null ? null : new ImageIcon(image);
    }

    public static void removeUnusedMenuSeparators(JPopupMenu menu) {
        if (menu.getComponentCount() > 0 && menu.getComponent(0) instanceof JSeparator) {
            menu.remove(0);
        }
        if (menu.getComponentCount() > 0 && menu.getComponent(menu.getComponentCount() - 1) instanceof JSeparator) {
            menu.remove(menu.getComponentCount() - 1);
        }
        for (int i = 0; i < menu.getComponentCount() - 1; ++i) {
            if (!(menu.getComponent(i) instanceof JSeparator) || !(menu.getComponent(i + 1) instanceof JSeparator)) continue;
            menu.remove(i);
        }
    }

    public static void ensureDockablesVisible(DockingDesktop desktop) {
        for (DockableState state : desktop.getDockables()) {
            if (!state.isClosed()) continue;
            desktop.addDockable(state.getDockable());
        }
    }

    public static DockingDesktop getDesktop(Container c) {
        while (c != null && !(c instanceof DockingDesktop)) {
            c = c.getParent();
        }
        return (DockingDesktop)c;
    }
}

