/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.matching.external.rmi.IDistantExternalMemory;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;

public class ProjectServer
extends UnicastRemoteObject
implements IDistantExternalMemory {
    public static final long serialVersionUID = 1L;
    protected Set<Integer> changes = new HashSet<Integer>();
    protected Set<SourceTextEntry> used = new HashSet<SourceTextEntry>();

    @Override
    public int getProjectSignature() {
        List<SourceTextEntry> entries = Core.getProject().getAllEntries();
        int signature = entries.size();
        for (SourceTextEntry ste : entries) {
            signature += ste.getKey().hashCode();
        }
        return signature;
    }

    @Override
    public List<ProjectMemory.ContextTMXEntry> findChanges(boolean withProperties, long timeStamp) {
        IProject proj = Core.getProject();
        if (!(proj instanceof RealProject)) {
            return Collections.emptyList();
        }
        ArrayList<ProjectMemory.ContextTMXEntry> res = new ArrayList<ProjectMemory.ContextTMXEntry>();
        List<SourceTextEntry> usedEntries = timeStamp == 0L ? Core.getProject().getAllEntries() : (this.used.isEmpty() ? Core.getProject().getAllEntries() : this.used);
        for (SourceTextEntry sourceEntry : usedEntries) {
            TMXEntry trans = proj.getTranslationInfo(sourceEntry);
            if (trans.changeDate < timeStamp && trans.creationDate < timeStamp) continue;
            ProjectMemory.ContextTMXEntry entry = new ProjectMemory.ContextTMXEntry(trans, sourceEntry);
            if (withProperties) {
                EntryKey eKey = sourceEntry.getKey();
                entry.otherProperties = new ArrayList();
                entry.otherProperties.add(new TMXProp("file", eKey.file));
                entry.otherProperties.add(new TMXProp("id", eKey.id));
                entry.otherProperties.add(new TMXProp("prev", eKey.prev));
                entry.otherProperties.add(new TMXProp("next", eKey.next));
                entry.otherProperties.add(new TMXProp("path", eKey.path));
            }
            res.add(entry);
        }
        return res;
    }

    @Override
    public void registerTranslation(ProjectMemory.ContextTMXEntry entry) {
        try {
            int num = entry.entryNum;
            this.changes.add(num);
            SourceTextEntry ste = Core.getProject().getAllEntries().get(num - 1);
            this.used.add(ste);
            Core.getProject().setTranslation(ste, entry, entry.isDefault, entry.linked);
        }
        catch (Exception iie) {
            EntryKey eKey = new EntryKey("unknown", entry.source, "unknown" + entry.hashCode(), "unknown", "unknown", "unknown");
            if (entry.otherProperties != null) {
                eKey = new EntryKey(StringUtil.nvl(entry.getPropValue("file"), "unknown"), entry.source, StringUtil.nvl(entry.getPropValue("id"), "unknown" + entry.hashCode()), StringUtil.nvl(entry.getPropValue("prev"), "unknown"), StringUtil.nvl(entry.getPropValue("file"), "unknown"), StringUtil.nvl(entry.getPropValue("path"), "unknown"));
            }
            Core.getProject().setTranslation(new SourceTextEntry(eKey, -1, null, "", Collections.emptyList()), entry, entry.isDefault, entry.linked);
        }
    }

    @Override
    public void removeTranslation(ProjectMemory.ContextTMXEntry entry) {
        this.registerTranslation(entry);
    }

    @Override
    public long timeStamp() {
        return System.currentTimeMillis();
    }
}

