/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.function.IntPredicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.omegat.core.statistics.StatCount;

public class MatchStatCounts {
    private static final int BASE_FOR_PERCENTS = 2;
    private final StatCount[] counts = new StatCount[8];

    public MatchStatCounts() {
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = new StatCount();
        }
    }

    public void addRepetition(StatCount count) {
        this.counts[0].add(count);
    }

    public void addRepetitionWithinThisFile(StatCount count) {
        this.counts[0].add(count);
    }

    public void addRepetitionFromOtherFiles(StatCount count) {
        this.counts[1].add(count);
    }

    public void addExact(StatCount count) {
        this.counts[this.getRowByPercent(101)].add(count);
    }

    public void addForPercents(int percent, StatCount count) {
        this.counts[this.getRowByPercent(percent)].add(count);
    }

    public MatchStatCounts addCounts(MatchStatCounts other) {
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i].add(other.counts[i]);
        }
        return this;
    }

    private int getRowByPercent(int percent) {
        if (percent == 101) {
            return 2;
        }
        if (percent >= 95) {
            return 3;
        }
        if (percent >= 85) {
            return 4;
        }
        if (percent >= 75) {
            return 5;
        }
        if (percent >= 50) {
            return 6;
        }
        return 7;
    }

    public String[][] calcTableWithoutPercentage(String[] rows) {
        String[][] table = new String[3][5];
        for (int i = 0; i <= 2; ++i) {
            table[i][0] = rows[i];
            table[i][1] = Integer.toString(this.counts[i].segments);
            table[i][2] = Integer.toString(this.counts[i].words);
            table[i][3] = Integer.toString(this.counts[i].charsWithoutSpaces);
            table[i][4] = Integer.toString(this.counts[i].charsWithSpaces);
        }
        return table;
    }

    public String[][] calcTable(String[] rows) {
        if (rows.length != this.counts.length + 1) {
            throw new IllegalArgumentException("Must supply headers for " + (this.counts.length + 1) + " rows");
        }
        return this.calcTable(rows, i -> true);
    }

    public String[][] calcTable(String[] rows, IntPredicate rowFilter) {
        StatCount total = Stream.of(this.counts).collect(Collector.of(StatCount::new, StatCount::add, StatCount::add, new Collector.Characteristics[0]));
        String[][] table = new String[rows.length][5];
        int offset = 0;
        for (int i = 0; i <= this.counts.length; ++i) {
            if (!rowFilter.test(i)) {
                ++offset;
                continue;
            }
            StatCount c = i == this.counts.length ? total : this.counts[i];
            int offsetIndex = i - offset;
            table[offsetIndex][0] = rows[offsetIndex];
            table[offsetIndex][1] = Integer.toString(c.segments);
            table[offsetIndex][2] = Integer.toString(c.words);
            table[offsetIndex][3] = Integer.toString(c.charsWithoutSpaces);
            table[offsetIndex][4] = Integer.toString(c.charsWithSpaces);
        }
        return table;
    }
}

